/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Campaign;
import pcgen.core.CharacterDomain;
import pcgen.core.Constants;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.NoteItem;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.SpecialProperty;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.EquipSet;
import pcgen.core.character.Follower;
import pcgen.core.character.SpellInfo;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.gui.PCGen_Frame1;
import pcgen.io.PCGParseException;
import pcgen.io.PCGParser;
import pcgen.io.parsers.CharacterDomainParser;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.PersistenceManager;
import pcgen.util.Logging;

final class PCGVer0Parser
implements PCGParser {
    private List warnings = new ArrayList();
    private PlayerCharacter aPC;
    private int ignoreDomainClassLine = 0;
    private int pcgVersion;

    PCGVer0Parser(PlayerCharacter aPC) {
        this.aPC = aPC;
    }

    public List getWarnings() {
        return this.warnings;
    }

    public void parsePCG(String[] lines) throws PCGParseException {
        int i = 0;
        if (PCGVer0Parser.checkCampaignLine(lines[i])) {
            ++i;
        }
        this.pcgVersion = PCGVer0Parser.parseVersionLine(lines[i]);
        if (this.pcgVersion > -1) {
            // empty if block
        }
        int n = ++i;
        this.parseNameLine(lines[n]);
        int n2 = ++i;
        this.parseStatsLine(lines[n2]);
        int n3 = ++i;
        this.parseClassesLine(lines[n3]);
        int n4 = ++i;
        this.parseFeatsLine(lines[n4]);
        this.parseRaceLine(lines[++i + 2]);
        this.parseSkillsLine(lines[i++]);
        this.parseDeityLine(lines[i++]);
        ++i;
        i = this.parseAutoSpellsLine(lines, i);
        i = this.pcgVersion < 272 ? this.parseOldSpellLine(lines, i) : this.parseSpellLine(lines, i);
        this.parseLanguagesLine(lines[i++]);
        int weaponProfLine = i++;
        this.parseUnusedPointsLine(lines[i++]);
        this.parseMiscLine(lines[i++]);
        this.parseEquipmentLine(lines[i++]);
        if (this.pcgVersion > 254) {
            this.parsePortraitLine(lines[i++]);
        }
        i = this.parseGoldBioDescriptionLine(lines, i);
        int dx = 0;
        Iterator it = this.aPC.getClassList().iterator();
        while (it.hasNext()) {
            if (++dx == this.ignoreDomainClassLine) {
                // empty if block
            }
            int n5 = ++i;
            ++i;
            this.parseClassesSkillLine(lines[n5]);
            it.next();
        }
        if (++dx == this.ignoreDomainClassLine) {
            ++i;
        }
        i = this.parseExperienceAndMiscLine(lines, i);
        if ((i = this.parseClassSpecialtyAndSaveLines(lines, i)) < lines.length) {
            this.parseTemplateLine(lines[i++]);
        }
        i = this.parseEquipSetLine(lines, i);
        i = this.parseFollowerLine(lines, i);
        i = this.parseNoteLine(lines, i);
        this.parseWeaponProfLine(lines[weaponProfLine]);
    }

    private static boolean checkCampaignLine(String line) throws PCGParseException {
        if (line.startsWith("CAMPAIGNS:")) {
            PCGVer0Parser.loadCampaignsForPC(line);
            if (!Globals.displayListsHappy()) {
                Logging.errorPrint("Insufficient campaign information to load character file.");
                throw new PCGParseException("checkCampaignLine", line, "Insufficient campaign information to load character file.");
            }
            return true;
        }
        return false;
    }

    private static void loadCampaignsForPC(String line) throws PCGParseException {
        StringTokenizer aTok = new StringTokenizer(line, ":", false);
        String sCamp = aTok.nextToken();
        if ("CAMPAIGNS".equals(sCamp) && SettingsHandler.isLoadCampaignsWithPC()) {
            ArrayList<Campaign> campList = new ArrayList<Campaign>();
            while (aTok.hasMoreTokens()) {
                Campaign aCamp = Globals.getCampaignNamed(aTok.nextToken());
                if (aCamp == null || aCamp.isLoaded()) continue;
                campList.add(aCamp);
            }
            if (campList.size() > 0) {
                try {
                    PersistenceManager pManager = PersistenceManager.getInstance();
                    pManager.loadCampaigns(campList);
                }
                catch (PersistenceLayerException e) {
                    throw new PCGParseException("loadCampaignsForPC", line, e.getMessage());
                }
                if (Globals.getUseGUI()) {
                    PCGen_Frame1.getInst().getMainSource().updateLoadedCampaignsUI();
                }
            }
        }
    }

    private static Float parseCarried(Float qty, String aName) {
        float carried;
        if ("Y".equals(aName)) {
            carried = qty.floatValue();
        } else if ("N".equals(aName)) {
            carried = 0.0f;
        } else {
            try {
                carried = Float.parseFloat(aName);
            }
            catch (NumberFormatException e) {
                carried = 0.0f;
            }
        }
        return new Float(carried);
    }

    private static int parseVersionLine(String line) throws PCGParseException {
        int version = -1;
        StringTokenizer aTok = new StringTokenizer(line, ":");
        String tag = aTok.hasMoreTokens() ? aTok.nextToken() : "";
        String ver = aTok.hasMoreTokens() ? aTok.nextToken() : "";
        try {
            if ("VERSION".equals(tag)) {
                aTok = new StringTokenizer(ver, ".");
                version = 0;
                while (aTok.hasMoreTokens()) {
                    version = version * 10 + Integer.parseInt(aTok.nextToken());
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new PCGParseException("parseVersionLine", line, ex.getMessage());
        }
        return version;
    }

    private int parseAutoSpellsLine(String[] lines, int i) {
        if (i >= lines.length) {
            return i;
        }
        if (lines[i].startsWith("AUTOSPELLS:NO")) {
            this.aPC.setAutoSpells(false);
            ++i;
        }
        if (lines[i].startsWith("AUTOSPELLS:YES")) {
            this.aPC.setAutoSpells(true);
            ++i;
        }
        return i;
    }

    private int parseClassSpecialtyAndSaveLines(String[] lines, int start) throws PCGParseException {
        int current = start;
        try {
            for (int i = 0; i < this.aPC.getClassList().size(); ++i) {
                String line;
                if ((line = lines[current++]) == null) {
                    return current;
                }
                StringTokenizer aTok = new StringTokenizer(line, ":", true);
                String bString = aTok.nextToken();
                PCClass aClass = this.aPC.getClassKeyed(bString);
                if (aClass == null || "Domain".equals(aClass.getKeyName())) continue;
                while (aTok.hasMoreTokens()) {
                    String token = aTok.nextToken();
                    if (token.startsWith("SPECIAL")) {
                        aClass.getSpecialtyList().add(token.substring(7));
                        continue;
                    }
                    if ("Smite Evil".equals(token) || ":".equals(token)) continue;
                    if (token.startsWith("BONUS")) {
                        aClass.addBonusList(token.substring(6));
                        if (token.lastIndexOf("|PCLEVEL|") > -1) {
                            String tmp = token.substring(token.lastIndexOf("PCLEVEL"));
                            StringTokenizer cTok = new StringTokenizer(tmp, "|");
                            cTok.nextToken();
                            if (cTok.hasMoreTokens()) {
                                SpecialAbility sa = new SpecialAbility("Bonus Caster Level for " + cTok.nextToken());
                                if (this.pcgVersion > 270 && cTok.hasMoreTokens()) {
                                    sa.setSASource("PCCLASS|" + aClass.getName() + "|" + cTok.nextToken());
                                }
                                aClass.addSpecialAbilityToList(sa);
                            }
                        }
                    } else if (!this.aPC.hasSpecialAbility(token)) {
                        SpecialAbility sa = new SpecialAbility(token);
                        String src = "";
                        if (this.pcgVersion > 270 && aTok.hasMoreTokens()) {
                            src = aTok.nextToken();
                        }
                        if (":".equals(src)) {
                            src = "";
                        }
                        aClass.addSpecialAbilityToList(sa);
                    }
                    if (aClass.containsSave(token) && !token.startsWith("BONUS")) continue;
                    aClass.addSave(token);
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new PCGParseException("parseClassSpecialtyAndSaveLines", lines[current], ex.getMessage());
        }
        return current;
    }

    private void parseClassesLine(String line) throws PCGParseException {
        StringTokenizer aTok = new StringTokenizer(line, ":");
        boolean getNext = true;
        String aString = "";
        int x = 0;
        while (aTok.hasMoreTokens()) {
            String aName;
            if (getNext) {
                ++x;
                aName = aTok.nextToken();
            } else {
                aName = aString;
            }
            getNext = true;
            if (!aTok.hasMoreTokens()) break;
            boolean needCopy = true;
            PCClass aClass = this.aPC.getClassKeyed(aName);
            if (aClass == null) {
                aClass = Globals.getClassKeyed(aName);
            } else {
                needCopy = false;
            }
            if (aClass == null && aName.equalsIgnoreCase("Domain")) {
                Logging.errorPrint("Domain class found and ignored. Please check character to verify conversion is successful.");
                this.ignoreDomainClassLine = x;
            } else if (aClass == null) {
                String message = "Class not found: " + aName + "." + Constants.s_LINE_SEP + "Check loaded campaigns.";
                throw new PCGParseException("parseClassesLine", line, message);
            }
            String subClassName = aTok.nextToken().trim();
            String prohibitedString = aTok.nextToken().trim();
            int k = Integer.parseInt(aTok.nextToken());
            if (aClass != null) {
                if (needCopy) {
                    aClass = (PCClass)aClass.clone();
                    this.aPC.getClassList().add(aClass);
                }
                aClass.setSubClassName(subClassName);
                aClass.setProhibitedString(prohibitedString);
            }
            for (int i = 0; i < k; ++i) {
                int iHp = Integer.parseInt(aTok.nextToken());
                if (aClass == null) continue;
                aClass.addLevel(false, this.aPC);
                aClass.setHitPoint(i, new Integer(iHp));
                this.aPC.saveLevelInfo(aClass.getKeyName());
            }
            Integer skillPool = new Integer(aTok.nextToken());
            if (aClass != null) {
                aClass.setSkillPool(skillPool);
            }
            if (!aTok.hasMoreTokens()) continue;
            aString = aTok.nextToken();
            if (SettingsHandler.getGame().getStatFromAbbrev(aString.toUpperCase()) > -1 || aString.equalsIgnoreCase("None") || "Any".equalsIgnoreCase(aString) || "SPELL".equalsIgnoreCase(aString)) {
                if (aClass == null) continue;
                aClass.setSpellBaseStat(aString);
                continue;
            }
            getNext = false;
        }
        this.aPC.setCurrentHP(this.aPC.hitPoints());
    }

    private void parseClassesSkillLine(String line) {
    }

    private void parseDeityLine(String line) {
        StringTokenizer deityTokenizer = new StringTokenizer(line, ":");
        int i = 0;
        while (deityTokenizer.hasMoreElements()) {
            String token = deityTokenizer.nextToken();
            switch (i) {
                case 0: {
                    boolean deityFound = false;
                    Iterator it = Globals.getDeityList().iterator();
                    while (it.hasNext()) {
                        Deity aDeity = (Deity)it.next();
                        if (!aDeity.toString().equals(token)) continue;
                        this.aPC.setDeity(aDeity);
                        deityFound = true;
                        break;
                    }
                    if (deityFound || token.equals("None")) break;
                    String message = "Deity not found: " + token + "." + Constants.s_LINE_SEP + "Check loaded campaigns.";
                    this.warnings.add(message);
                    break;
                }
                default: {
                    int j = this.aPC.indexOfFirstEmptyCharacterDomain();
                    if (j == -1) {
                        CharacterDomain aCD = new CharacterDomain();
                        this.aPC.getCharacterDomainList().add(aCD);
                        j = this.aPC.getCharacterDomainList().size() - 1;
                    }
                    if (j < 0) break;
                    StringTokenizer cdTok = new StringTokenizer(token, "=", false);
                    String domainName = cdTok.nextToken();
                    CharacterDomain aCD = (CharacterDomain)this.aPC.getCharacterDomainList().get(j);
                    Domain aDomain = Globals.getDomainKeyed(domainName);
                    if (aDomain != null) {
                        aDomain = aCD.setDomain(aDomain, this.aPC);
                        while (cdTok.hasMoreTokens()) {
                            String sSource = cdTok.nextToken();
                            if (sSource.startsWith("LIST|")) {
                                aDomain.addAllToAssociated(CoreUtility.split(sSource.substring(5), '|'));
                                continue;
                            }
                            CharacterDomainParser parser = new CharacterDomainParser();
                            parser.setDomainSource(aCD, sSource);
                        }
                        aDomain.setIsLocked(true, this.aPC);
                        break;
                    }
                    if (domainName.equals("None")) break;
                    String message = "Domain not found: " + token + "." + Constants.s_LINE_SEP + "Check loaded campaigns.";
                    this.warnings.add(message);
                }
            }
            ++i;
        }
    }

    private int parseEquipSetLine(String[] lines, int i) {
        if (i >= lines.length) {
            return i;
        }
        String aString = lines[i];
        while (aString.startsWith("EQUIPSET:")) {
            Equipment eqT = null;
            StringTokenizer aTok = new StringTokenizer(aString.substring(9), ":", false);
            String id = aTok.nextToken();
            String name = aTok.nextToken();
            EquipSet aSet = new EquipSet(id, name);
            if (aTok.hasMoreTokens()) {
                String value = aTok.nextToken();
                aSet.setValue(value);
                Equipment eqI = EquipmentList.getEquipmentNamed(value);
                if (eqI == null) {
                    String message = "parseEquipSetLine: equipment not found: " + value;
                    this.warnings.add(message);
                } else {
                    Equipment eq = (Equipment)eqI.clone();
                    StringTokenizer iTok = new StringTokenizer(id, ".", false);
                    if (aTok.hasMoreTokens()) {
                        float fNum = Float.parseFloat(aTok.nextToken());
                        Float num = new Float(fNum);
                        aSet.setQty(num);
                        eq.setQty(num);
                        eq.setNumberCarried(num);
                    }
                    if (iTok.countTokens() > 3) {
                        EquipSet es = this.aPC.getEquipSetByIdPath(aSet.getParentIdPath());
                        if (es != null) {
                            eqT = es.getItem();
                        }
                        if (eqT != null) {
                            eqT.insertChild(this.aPC, eq);
                            eq.setParent(eqT);
                        }
                    }
                    aSet.setItem(eq);
                }
            }
            if (aSet != null) {
                this.aPC.addEquipSet(aSet);
            }
            if (++i >= lines.length) {
                return i;
            }
            aString = lines[i];
        }
        return i;
    }

    private void parseEquipmentLine(String line) {
        Equipment eq;
        String aName;
        StringTokenizer aTok = new StringTokenizer(line, ":");
        HashMap<String, String> containers = new HashMap<String, String>();
        ArrayList headerChildren = new ArrayList();
        while (aTok.hasMoreTokens()) {
            boolean bFound;
            aName = aTok.nextToken().trim();
            String customName = "";
            if (aName.indexOf(";NAME=") > -1 || aName.indexOf(";SIZE=") > -1 || aName.indexOf(";EQMOD=") > -1 || aName.indexOf(";ALTEQMOD=") > -1 || aName.indexOf(";SPROP=") > -1 || aName.indexOf(";COSTMOD=") > -1 || aName.indexOf(";WEIGHTMOD=") > -1) {
                int idx = aName.indexOf(59);
                String baseItemKey = aName.substring(0, idx);
                String aLine = aName.substring(idx + 1);
                Equipment aEq = EquipmentList.getEquipmentKeyed(baseItemKey);
                if (aEq != null) {
                    eq = (Equipment)aEq.clone();
                    eq.load(aLine, ";", "=", this.aPC);
                    EquipmentList.addEquipment((Equipment)eq.clone());
                    bFound = true;
                } else {
                    eq = new Equipment();
                    bFound = false;
                }
            } else {
                Equipment aEq;
                StringTokenizer anTok = new StringTokenizer(aName, ";");
                String sized = "";
                String head1 = "";
                String head2 = "";
                String customProp = "";
                int tokenCount = anTok.countTokens();
                if (tokenCount >= 4 && tokenCount <= 6) {
                    if (tokenCount >= 5) {
                        customName = anTok.nextToken();
                    }
                    String baseName = anTok.nextToken();
                    sized = anTok.nextToken();
                    head1 = anTok.nextToken();
                    head2 = anTok.nextToken();
                    aName = baseName;
                    if (tokenCount == 6) {
                        customProp = anTok.nextToken();
                    }
                }
                if ((aEq = EquipmentList.getEquipmentKeyed(aName)) == null) {
                    aEq = EquipmentList.getEquipmentFromName(aName, this.aPC);
                }
                bFound = true;
                if (aEq == null) {
                    eq = new Equipment();
                    bFound = false;
                } else {
                    eq = (Equipment)aEq.clone();
                    if (customName.length() == 0 && eq.getEqModifierList(true).size() + eq.getEqModifierList(false).size() != 0) {
                        customName = aName;
                    }
                }
                if (customProp.length() != 0) {
                    eq.addSpecialProperty(SpecialProperty.createFromLst(customProp));
                }
                eq.addEqModifiers(head1, true);
                eq.addEqModifiers(head2, false);
                if (sized.length() != 0 && !eq.getSize().equals(sized) || eq.getEqModifierList(true).size() + eq.getEqModifierList(false).size() != 0 || customProp.length() != 0) {
                    if (sized.length() == 0) {
                        sized = eq.getSize();
                    }
                    eq.resizeItem(this.aPC, sized);
                    eq.nameItemFromModifiers(this.aPC);
                }
                if (bFound) {
                    if (customName.length() > 0) {
                        eq.setName(customName);
                    }
                    EquipmentList.addEquipment((Equipment)eq.clone());
                }
            }
            eq.setQty(aTok.nextToken());
            if (this.pcgVersion >= 269) {
                eq.setOutputIndex(Integer.parseInt(aTok.nextToken()));
            }
            aTok.nextToken();
            StringTokenizer bTok = new StringTokenizer(aTok.nextToken(), "@", false);
            eq.setCarried(PCGVer0Parser.parseCarried(new Float(eq.qty()), bTok.nextToken()));
            if (bTok.hasMoreTokens()) {
                containers.put(eq.getKeyName(), bTok.nextToken());
            }
            eq.setLocation(Equipment.getLocationNum(aTok.nextToken()));
            if (eq.getLocation() == 4) {
                eq.setNumberEquipped(Integer.parseInt(aTok.nextToken()));
            }
            if (bFound) {
                this.aPC.addEquipment(eq);
                this.aPC.equipmentListAddAll(headerChildren);
                continue;
            }
            if (aName.indexOf("Natural/") >= 0) continue;
            String message = "Equipment not found: " + aName + " (" + eq.qty() + ")." + Constants.s_LINE_SEP + "Check loaded campaigns.";
            this.warnings.add(message);
        }
        Iterator it = containers.keySet().iterator();
        while (it.hasNext()) {
            aName = (String)it.next();
            eq = this.aPC.getEquipmentNamed(aName);
            if (eq == null) continue;
            String containerName = (String)containers.get(aName);
            Equipment aParent = this.aPC.getEquipmentNamed(containerName);
            if (aParent != null) {
                aParent.insertChild(this.aPC, eq);
                continue;
            }
            Logging.errorPrint("Container \"" + containerName + "\" not found for \"" + aName + "\"");
        }
    }

    private int parseExperienceAndMiscLine(String[] lines, int start) throws PCGParseException {
        int current = start;
        try {
            int i = 0;
            boolean nextLine = true;
            String line = "";
            String cString = "";
            while (i < 6) {
                if (nextLine) {
                    line = lines[current++];
                }
                int k = line.indexOf(58);
                while (k > 0 && line.charAt(k - 1) == '\\') {
                    k = line.indexOf(58, k + 1);
                }
                if (k < 0 || line.charAt(k - 1) == '\\') {
                    k = -1;
                }
                if (k == -1) {
                    cString = cString.concat(line);
                    cString = cString.concat(Constants.s_LINE_SEP);
                    nextLine = true;
                    if (i <= 3) continue;
                    break;
                }
                k = line.indexOf(58);
                while (line.charAt(k - 1) == '\\') {
                    k = line.indexOf(58, k + 1);
                }
                cString = cString.concat(line.substring(0, k));
                switch (i) {
                    case 0: {
                        this.aPC.setXP(Integer.parseInt(cString));
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        String tempStr = "";
                        for (int j = 0; j < cString.length(); ++j) {
                            if (cString.charAt(j) != '\\') {
                                tempStr = tempStr + cString.charAt(j);
                                continue;
                            }
                            if (j + 1 >= cString.length() || cString.charAt(j + 1) == ':') continue;
                            tempStr = tempStr + "\\";
                        }
                        this.aPC.getMiscList().set(i - 1, tempStr.trim());
                        break;
                    }
                    default: {
                        Logging.errorPrint("In PCGVer0Parser.parseExperienceAndMiscLine the i value " + i + " is not handled.");
                    }
                }
                if (i < 6) {
                    line = line.substring(k + 1);
                }
                cString = "";
                nextLine = false;
                ++i;
            }
        }
        catch (NumberFormatException ex) {
            throw new PCGParseException("parseExperienceAndMiscLine", lines[current], ex.getMessage());
        }
        return current;
    }

    private void parseFeatsLine(String line) throws PCGParseException {
        try {
            StringTokenizer aTok = new StringTokenizer(line, ":");
            while (aTok.hasMoreTokens()) {
                String aString;
                String aName = aTok.nextToken().trim();
                if (aName.length() == 0) continue;
                int k = Integer.parseInt(aTok.nextToken());
                StringTokenizer bTok = new StringTokenizer(aName, "[]");
                Feat aFeat = Globals.getFeatKeyed(aName = bTok.nextToken());
                if (aFeat != null) {
                    aFeat = (Feat)aFeat.clone();
                    this.aPC.modFeat(aFeat.getKeyName(), true, !aFeat.isMultiples());
                    if (aFeat.isMultiples() && aFeat.getAssociatedCount() == 0 && this.aPC.getFeatKeyed(aFeat.getKeyName()) == null) {
                        this.aPC.addFeat(aFeat);
                    }
                    aFeat = this.aPC.getFeatKeyed(aFeat.getKeyName());
                    while (bTok.hasMoreTokens()) {
                        aString = bTok.nextToken();
                        if (aString.startsWith("BONUS") && aString.length() > 6) {
                            aFeat.addBonusList(aString.substring(6));
                        }
                        aFeat.addSave(aString);
                    }
                } else {
                    aFeat = new Feat();
                }
                for (int j = 0; j < k; ++j) {
                    aString = aTok.nextToken();
                    if (aName.endsWith("Weapon Proficiency")) {
                        this.aPC.addWeaponProf(aString);
                        continue;
                    }
                    if ((!aFeat.isMultiples() || !aFeat.isStacks()) && aFeat.containsAssociated(aString)) continue;
                    aFeat.addAssociated(aString);
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new PCGParseException("parseFeatsLine", line, ex.getMessage());
        }
    }

    private int parseFollowerLine(String[] lines, int i) {
        if (i >= lines.length) {
            return i;
        }
        String aString = lines[i];
        while (aString.startsWith("FOLLOWER") || aString.startsWith("MASTER")) {
            StringTokenizer aTok = new StringTokenizer(aString, "|", false);
            String who = aTok.nextToken();
            String fName = aTok.nextToken();
            String aName = aTok.nextToken();
            String aType = aTok.nextToken();
            int usedHD = Integer.parseInt(aTok.nextToken());
            Follower aF = new Follower(fName, aName, aType);
            aF.setUsedHD(usedHD);
            if ("FOLLOWER".equals(who)) {
                this.aPC.addFollower(aF);
            } else if ("MASTER".equals(who)) {
                this.aPC.setMaster(aF, this.aPC);
            }
            if (++i >= lines.length) {
                return i;
            }
            aString = lines[i];
        }
        return i;
    }

    private int parseGoldBioDescriptionLine(String[] lines, int start) throws PCGParseException {
        int current = start;
        int i = 0;
        try {
            boolean nextLine = true;
            String line = "";
            String cString = "";
            while (i < 3) {
                if (nextLine) {
                    line = lines[current++];
                }
                int k = line.indexOf(58);
                while (k > 0 && line.charAt(k - 1) == '\\') {
                    k = line.indexOf(58, k + 1);
                }
                if (k < 0 || k > 0 && line.charAt(k - 1) == '\\') {
                    k = -1;
                }
                if (k == -1) {
                    cString = cString.concat(line);
                    cString = cString.concat(Constants.s_LINE_SEP);
                    nextLine = true;
                    continue;
                }
                k = line.indexOf(58);
                while (k > 0 && line.charAt(k - 1) == '\\') {
                    k = line.indexOf(58, k + 1);
                }
                cString = cString.concat(line.substring(0, k));
                String tempStr = "";
                for (int j = 0; j < cString.length(); ++j) {
                    if (cString.charAt(j) != '\\') {
                        tempStr = tempStr + cString.charAt(j);
                        continue;
                    }
                    if (j + 1 >= cString.length() || cString.charAt(j + 1) == ':') continue;
                    tempStr = tempStr + "\\";
                }
                switch (i) {
                    case 0: {
                        this.aPC.setGold(tempStr);
                        break;
                    }
                    case 1: {
                        this.aPC.setBio(tempStr);
                        break;
                    }
                    case 2: {
                        this.aPC.setDescription(tempStr);
                        break;
                    }
                    default: {
                        Logging.errorPrint("In PCGVer0Parser.parseGoldBioValue the i value " + i + " is not handled.");
                    }
                }
                if (i < 3) {
                    line = line.substring(k + 1);
                }
                cString = "";
                nextLine = false;
                ++i;
            }
        }
        catch (NumberFormatException ex) {
            throw new PCGParseException("parseGoldBioDescriptionLine", Integer.toString(i) + ":" + lines[current], ex.getMessage());
        }
        return current;
    }

    private void parseLanguagesLine(String line) {
        StringTokenizer aTok = new StringTokenizer(line, ":");
        while (aTok.hasMoreTokens()) {
            this.aPC.addLanguage(aTok.nextToken());
        }
    }

    private void parseMiscLine(String line) {
        StringTokenizer aTok = new StringTokenizer(line, ":");
        int i = 0;
        while (aTok.hasMoreTokens()) {
            String token = CoreUtility.unEscapeColons2(aTok.nextToken().trim());
            switch (i) {
                case 0: {
                    this.aPC.setEyeColor(token);
                    break;
                }
                case 1: {
                    this.aPC.setSkinColor(token);
                    break;
                }
                case 2: {
                    this.aPC.setHairColor(token);
                    break;
                }
                case 3: {
                    this.aPC.setHairStyle(token);
                    break;
                }
                case 4: {
                    this.aPC.setSpeechTendency(token);
                    break;
                }
                case 5: {
                    this.aPC.setPhobias(token);
                    break;
                }
                case 6: {
                    this.aPC.setInterests(token);
                    break;
                }
                case 7: {
                    this.aPC.setTrait1(token);
                    break;
                }
                case 8: {
                    this.aPC.setTrait2(token);
                    break;
                }
                case 9: {
                    this.aPC.setCatchPhrase(token);
                    break;
                }
                case 10: {
                    this.aPC.setLocation(token);
                    break;
                }
                case 11: {
                    this.aPC.setResidence(token);
                    break;
                }
                default: {
                    Logging.errorPrint("In PCGVer0Parser.parseMiscLine the i value " + i + " is not handled.");
                }
            }
            ++i;
        }
    }

    private void parseNameLine(String line) throws PCGParseException {
        StringTokenizer aTok = new StringTokenizer(line, ":");
        if (!aTok.hasMoreTokens()) {
            throw new PCGParseException("parseNameLine", line, "No character name found.");
        }
        this.aPC.setName(CoreUtility.unEscapeColons2(aTok.nextToken()));
        if (aTok.hasMoreTokens() && aTok.countTokens() > 1) {
            this.aPC.setTabName(CoreUtility.unEscapeColons2(aTok.nextToken()));
        }
        if (aTok.hasMoreTokens()) {
            this.aPC.setPlayersName(CoreUtility.unEscapeColons2(aTok.nextToken()));
        }
    }

    private int parseNoteLine(String[] lines, int i) {
        if (i >= lines.length) {
            return i;
        }
        String lastLineParsed = lines[i];
        boolean flag = lastLineParsed.startsWith("NOTES:");
        NoteItem anItem = null;
        while (flag) {
            if (lastLineParsed.startsWith("NOTES:")) {
                StringTokenizer aTok = new StringTokenizer(lastLineParsed.substring(6), ":", false);
                int id_value = Integer.parseInt(aTok.nextToken());
                int id_parent = Integer.parseInt(aTok.nextToken());
                String id_name = aTok.nextToken();
                String id_text = "";
                if (aTok.hasMoreTokens()) {
                    id_text = aTok.nextToken();
                }
                anItem = new NoteItem(id_value, id_parent, id_name, id_text);
                this.aPC.addNotesItem(anItem);
            } else if (anItem != null) {
                anItem.setValue(anItem.getValue() + Constants.s_LINE_SEP + lastLineParsed);
            }
            if (++i >= lines.length) {
                return i;
            }
            lastLineParsed = lines[i];
            flag = lastLineParsed != null && !":ENDNOTES:".equals(lastLineParsed);
        }
        return i;
    }

    private int parseOldSpellLine(String[] lines, int i) {
        if (i >= lines.length) {
            return i;
        }
        String aString = lines[i];
        while (aString.startsWith("SPELL:")) {
            aString = aString.substring(6);
            StringTokenizer aTok = new StringTokenizer(aString, ":", false);
            aString = lines[++i];
            String name = aTok.nextToken();
            Spell aSpell = Globals.getSpellNamed(name);
            if (aSpell == null) {
                String message = "Unable to find spell named: " + name;
                this.warnings.add(message);
                continue;
            }
            int times = Integer.parseInt(aTok.nextToken());
            String pdName = aTok.nextToken();
            String className = aTok.nextToken();
            String book = aTok.nextToken();
            PCClass aClass = this.aPC.getClassNamed(className);
            if (aClass == null) {
                String message = "Bad spell info - no class named " + className;
                this.warnings.add(message);
                continue;
            }
            PObject aObject = this.aPC.getCharacterDomainNamed(pdName);
            if (aObject == null) {
                aObject = aClass;
            }
            if (aObject == null) {
                String message = "Bad spell info - no class or domain named " + pdName;
                this.warnings.add(message);
                continue;
            }
            int sLevel = aSpell.getFirstLevelForKey(aObject.getSpellKey(), this.aPC);
            if (sLevel == -1) {
                String message = "Bad spell info -" + aSpell.getName() + " doesn't have valid level info for " + pdName;
                this.warnings.add(message);
                continue;
            }
            if (book.equals(Globals.getDefaultSpellBook()) && aClass.isAutoKnownSpell(aSpell.getKeyName(), sLevel, this.aPC)) continue;
            CharacterSpell cs = aClass.getCharacterSpellForSpell(aSpell, aClass);
            if (cs == null) {
                cs = new CharacterSpell(aClass, aSpell);
                cs.addInfo(sLevel, 1, Globals.getDefaultSpellBook());
                aClass.addCharacterSpell(cs);
            }
            SpellInfo si = null;
            if (!book.equals(Globals.getDefaultSpellBook())) {
                si = cs.addInfo(sLevel, times, book);
            }
            ArrayList<Feat> featList = new ArrayList<Feat>();
            while (aTok.hasMoreTokens()) {
                String bString = aTok.nextToken();
                Feat aFeat = Globals.getFeatNamed(bString);
                if (aFeat == null) continue;
                featList.add(aFeat);
            }
            if (si != null) {
                si.addFeatsToList(featList);
            }
            this.aPC.addSpellBook(book);
        }
        return i;
    }

    private void parsePortraitLine(String line) throws PCGParseException {
        if (line == null || !line.startsWith("PORTRAIT:")) {
            throw new PCGParseException("parsePortraitLine", line, "Invalid portrait line ignored.");
        }
        this.aPC.setPortraitPath(line.substring(9));
    }

    private void parseRaceLine(String line) throws PCGParseException {
        StringTokenizer aTok = new StringTokenizer(line, ":");
        int x = 0;
        HashMap<String, Integer> hitPointMap = new HashMap<String, Integer>();
        Race aRace = null;
        String raceName = "";
        int i = 0;
        while (aTok.hasMoreElements()) {
            String token = aTok.nextToken();
            switch (i) {
                case 0: {
                    aRace = Globals.getRaceKeyed(token);
                    raceName = token;
                    if (aRace != null) {
                        this.aPC.setRace(aRace);
                        break;
                    }
                    String message = "Race not found: " + token + "." + Constants.s_LINE_SEP + "Check loaded campaigns.";
                    throw new PCGParseException("parseRaceLine", line, message);
                }
                case 1: {
                    try {
                        this.aPC.setAlignment(Integer.parseInt(token), true);
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new PCGParseException("parseRaceLine", line, ex.getMessage());
                    }
                }
                case 2: {
                    try {
                        this.aPC.setHeightInInches(Integer.parseInt(token));
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new PCGParseException("parseRaceLine", line, ex.getMessage());
                    }
                }
                case 3: {
                    try {
                        this.aPC.setWeightInPounds(Integer.parseInt(token));
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new PCGParseException("parseRaceLine", line, ex.getMessage());
                    }
                }
                case 4: {
                    try {
                        this.aPC.setAge(Integer.parseInt(token));
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new PCGParseException("parseRaceLine", line, ex.getMessage());
                    }
                }
                case 5: {
                    this.aPC.setGender(token);
                    break;
                }
                case 6: {
                    this.aPC.setHanded(token);
                    break;
                }
                default: {
                    try {
                        hitPointMap.put(Integer.toString(x++), new Integer(token));
                    }
                    catch (NumberFormatException ex) {
                        throw new PCGParseException("parseRaceLine", line, ex.getMessage());
                    }
                    if (aRace == null || x != aRace.hitDice(this.aPC)) break;
                    this.aPC.getRace().setHitPointMap(hitPointMap);
                    return;
                }
            }
            ++i;
        }
    }

    private void parseSkillsLine(String line) throws PCGParseException {
        StringTokenizer skillTokenizer = new StringTokenizer(line, ":");
        try {
            while (skillTokenizer.hasMoreElements()) {
                Skill aSkill;
                int i;
                String skillName = skillTokenizer.nextToken();
                if (!skillTokenizer.hasMoreTokens()) {
                    return;
                }
                Float aFloat = new Float(skillTokenizer.nextToken());
                Integer outputIndex = this.pcgVersion >= 268 ? new Integer(skillTokenizer.nextToken()) : new Integer(0);
                ArrayList<String> aRankList = new ArrayList<String>();
                if (this.pcgVersion >= 2) {
                    int iCount = Integer.parseInt(skillTokenizer.nextToken());
                    for (i = 0; i < iCount; ++i) {
                        aRankList.add(skillTokenizer.nextToken() + ":" + skillTokenizer.nextToken());
                    }
                }
                if ((aSkill = this.aPC.getSkillKeyed(skillName)) == null) {
                    for (i = 0; i < Globals.getSkillList().size(); ++i) {
                        if (!skillName.equals(Globals.getSkillList().get(i).toString())) continue;
                        aSkill = (Skill)Globals.getSkillList().get(i);
                        aSkill = (Skill)aSkill.clone();
                        this.aPC.getSkillList().add(aSkill);
                        break;
                    }
                }
                if (aSkill != null) {
                    String bRank;
                    for (i = 0; i < aRankList.size(); ++i) {
                        String bRank2 = (String)aRankList.get(i);
                        int iOffs = bRank2.indexOf(58);
                        Float fRank = new Float(bRank2.substring(iOffs + 1));
                        PCClass aClass = this.aPC.getClassKeyed(bRank2.substring(0, iOffs));
                        if (aClass != null || bRank2.substring(0, iOffs).equals("None")) {
                            bRank2 = aSkill.modRanks(fRank.doubleValue(), aClass, true, this.aPC);
                            if (bRank2.length() == 0) continue;
                            Logging.errorPrint("loadSkillsLine: " + bRank2);
                            continue;
                        }
                        Logging.errorPrint("Class not found: " + bRank2.substring(0, iOffs));
                    }
                    if (this.pcgVersion < 2 && (bRank = aSkill.modRanks(aFloat.doubleValue(), null, true, this.aPC)).length() != 0) {
                        Logging.errorPrint("loadSkillsLine: " + bRank);
                    }
                    aSkill.setOutputIndex(outputIndex);
                    continue;
                }
                Logging.errorPrint("Skill not found: " + skillName);
                if (CoreUtility.doublesEqual(aFloat.doubleValue(), 0.0)) continue;
                String message = "Ranked skill not found: " + skillName + "(" + aFloat + ")." + Constants.s_LINE_SEP + "Check loaded campaigns.";
                this.warnings.add(message);
            }
        }
        catch (NumberFormatException ex) {
            throw new PCGParseException("parseSkillsLine", line, ex.getMessage());
        }
    }

    private int parseSpellLine(String[] lines, int i) {
        if (i >= lines.length) {
            return i;
        }
        String aString = lines[i];
        while (aString.startsWith("SPELL:")) {
            int level;
            PObject aObject;
            aString = aString.substring(6);
            StringTokenizer aTok = new StringTokenizer(aString, ":", false);
            aString = lines[++i];
            String name = aTok.nextToken();
            Spell aSpell = Globals.getSpellNamed(name);
            if (aSpell == null) {
                String message = "Unable to find spell named: " + name;
                this.warnings.add(message);
                continue;
            }
            int times = Integer.parseInt(aTok.nextToken());
            String typeName = aTok.nextToken();
            String objName = aTok.nextToken();
            String className = aTok.nextToken();
            String book = aTok.nextToken();
            int sLevel = Integer.parseInt(aTok.nextToken());
            PCClass aClass = this.aPC.getClassNamed(className);
            if (aClass == null) {
                String message = "Bad spell info - no class named " + className;
                this.warnings.add(message);
                continue;
            }
            if ("DOMAIN".equals(typeName)) {
                aObject = this.aPC.getCharacterDomainNamed(objName);
                if (aObject == null) {
                    String message = "No Domain named " + objName + " (" + aString + ")";
                    this.warnings.add(message);
                    continue;
                }
            } else {
                aObject = this.aPC.getClassNamed(objName);
                if (aObject == null) {
                    aObject = aClass;
                }
            }
            if ((level = aSpell.getFirstLevelForKey(((PObject)aObject).getSpellKey(), this.aPC)) == -1) {
                String message = "Bad spell info - no spell for " + aSpell.getName() + " in " + typeName + " " + objName;
                this.warnings.add(message);
                continue;
            }
            if (book.equals(Globals.getDefaultSpellBook()) && aClass.isAutoKnownSpell(aSpell.getKeyName(), level, this.aPC) && this.aPC.getAutoSpells()) continue;
            ArrayList<Feat> featList = new ArrayList<Feat>();
            while (aTok.hasMoreTokens()) {
                String fName = aTok.nextToken();
                Feat aFeat = Globals.getFeatNamed(fName);
                if (aFeat == null) continue;
                featList.add(aFeat);
            }
            CharacterSpell cs = aClass.getCharacterSpellForSpell(aSpell, aClass);
            if (cs == null) {
                cs = new CharacterSpell(aClass, aSpell);
                if (!"DOMAIN".equals(typeName)) {
                    cs.addInfo(level, 1, Globals.getDefaultSpellBook());
                }
                aClass.addCharacterSpell(cs);
            }
            SpellInfo si = null;
            if (!(!objName.equals(className) && book.equals(Globals.getDefaultSpellBook()) || (si = cs.getSpellInfoFor(book, sLevel, -1)) != null && featList.isEmpty())) {
                si = cs.addInfo(sLevel, times, book);
            }
            if (si != null && !featList.isEmpty()) {
                si.addFeatsToList(featList);
            }
            this.aPC.addSpellBook(book);
            if (i < lines.length) continue;
            return i;
        }
        Iterator sp = this.aPC.getClassList().iterator();
        while (sp.hasNext()) {
            PCClass aClass = (PCClass)sp.next();
            aClass.sortCharacterSpellList();
        }
        return i;
    }

    private void parseStatsLine(String line) throws PCGParseException {
        StringTokenizer aTok = new StringTokenizer(line, ":");
        int statCount = 6;
        if (line.startsWith("STATS:")) {
            aTok.nextToken();
            statCount = Integer.parseInt(aTok.nextToken());
        }
        if (statCount != SettingsHandler.getGame().s_ATTRIBLONG.length) {
            String message = "Number of Stats for character is " + statCount + ". " + "PCGen is currently using " + SettingsHandler.getGame().s_ATTRIBLONG.length + ". " + "Cannot load character.";
            throw new PCGParseException("parseStatsLine", line, message);
        }
        try {
            for (int i = 0; aTok.hasMoreTokens() && i < SettingsHandler.getGame().s_ATTRIBLONG.length; ++i) {
                ((PCStat)this.aPC.getStatList().getStats().get(i)).setBaseScore(Integer.parseInt(aTok.nextToken()));
            }
            if (aTok.hasMoreTokens()) {
                this.aPC.setPoolAmount(Integer.parseInt(aTok.nextToken()));
            }
            if (aTok.hasMoreTokens()) {
                this.aPC.setCostPool(Integer.parseInt(aTok.nextToken()));
            }
        }
        catch (NumberFormatException ex) {
            throw new PCGParseException("parseStatsLine", line, ex.getMessage());
        }
    }

    private void parseTemplateLine(String line) {
        if (line == null) {
            return;
        }
        String work = line;
        if (work.startsWith("TEMPLATE:")) {
            work = work.substring(9);
        }
        StringTokenizer tokens = new StringTokenizer(work, ":");
        while (tokens.hasMoreTokens()) {
            PCTemplate aTemplate = Globals.getTemplateNamed(tokens.nextToken());
            if (aTemplate == null) continue;
            this.aPC.addTemplate(aTemplate);
        }
    }

    private void parseUnusedPointsLine(String line) throws PCGParseException {
        StringTokenizer aTok = new StringTokenizer(line, ":");
        try {
            int remainingSkillPoints = Integer.parseInt(aTok.nextToken());
            this.aPC.setSkillPoints(remainingSkillPoints);
            int classSkillPoints = 0;
            Iterator e = this.aPC.getClassList().iterator();
            while (e.hasNext()) {
                PCClass aClass = (PCClass)e.next();
                classSkillPoints += aClass.getSkillPool(this.aPC).intValue();
            }
            if (classSkillPoints != remainingSkillPoints) {
                String message = "Remaining class skill points incorrect (i.e. " + classSkillPoints + " instead of " + remainingSkillPoints + ")." + Constants.s_LINE_SEP + "Please correct manually on the Skills tab";
                this.warnings.add(message);
            }
            this.aPC.setFeats(Double.parseDouble(aTok.nextToken()));
        }
        catch (NumberFormatException ex) {
            throw new PCGParseException("parseUnusedPointsLine", line, ex.getMessage());
        }
    }

    private void parseWeaponProfLine(String line) {
        int iState = 0;
        StringTokenizer aTok = new StringTokenizer(line, ":", false);
        Race aRace = null;
        PCClass aClass = null;
        Domain aDomain = null;
        PObject aFeat = null;
        ArrayList<String> myProfs = new ArrayList<String>();
        block6: while (aTok.hasMoreTokens()) {
            String aString = aTok.nextToken();
            if (aString.startsWith("RACE=")) {
                iState = 1;
                aRace = this.aPC.getRace();
                continue;
            }
            if (aString.startsWith("CLASS=")) {
                iState = 2;
                aString = aString.substring(6);
                aClass = this.aPC.getClassNamed(aString);
                continue;
            }
            if (aString.startsWith("DOMAIN=")) {
                iState = 3;
                aString = aString.substring(7);
                aDomain = this.aPC.getCharacterDomainNamed(aString);
                continue;
            }
            if (aString.startsWith("FEAT=")) {
                iState = 4;
                aString = aString.substring(5);
                aFeat = this.aPC.getFeatNamed(aString);
                continue;
            }
            switch (iState) {
                case 1: {
                    if (aRace == null) continue block6;
                    aRace.addSelectedWeaponProfBonus(aString);
                    continue block6;
                }
                case 2: {
                    if (aClass == null) continue block6;
                    aClass.addSelectedWeaponProfBonus(aString);
                    continue block6;
                }
                case 3: {
                    if (aDomain == null) continue block6;
                    aDomain.addSelectedWeaponProfBonus(aString);
                    continue block6;
                }
                case 4: {
                    if (aFeat == null) continue block6;
                    aFeat.addSelectedWeaponProfBonus(aString);
                    continue block6;
                }
            }
            myProfs.add(aString);
        }
        this.aPC.setAutomaticFeatsStable(false);
        this.aPC.rebuildFeatAutoList();
        ArrayList<String> nonproficient = new ArrayList<String>();
        Iterator e = myProfs.iterator();
        while (e.hasNext()) {
            String aString = (String)e.next();
            if (this.aPC.hasWeaponProfNamed(aString)) continue;
            nonproficient.add(aString);
        }
        if (nonproficient.size() != 0) {
            String s = ((Object)nonproficient).toString();
            s = s.substring(1, s.length() - 1);
            String message = "No longer proficient with following weapon(s):" + Constants.s_LINE_SEP + s;
            this.warnings.add(message);
        }
    }
}

