/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import pcgen.core.Campaign;
import pcgen.core.CharacterDomain;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Feat;
import pcgen.core.FeatMultipleChoice;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.LevelAbility;
import pcgen.core.NoteItem;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.EquipSet;
import pcgen.core.character.Follower;
import pcgen.core.character.SpellInfo;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.spell.Spell;
import pcgen.io.Cache;
import pcgen.io.EntityEncoder;
import pcgen.io.IOConstants;

final class PCGVer2Creator
implements IOConstants {
    private static final String LINE_SEP = "\n";
    private PlayerCharacter aPC;

    PCGVer2Creator(PlayerCharacter aPC) {
        this.aPC = aPC;
    }

    public String createPCGString() {
        StringBuffer buffer = new StringBuffer(1000);
        PCGVer2Creator.appendPCGVersionLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("System Information", buffer);
        PCGVer2Creator.appendCampaignLine(buffer);
        PCGVer2Creator.appendVersionLine(buffer);
        PCGVer2Creator.appendRollMethodLine(buffer);
        PCGVer2Creator.appendPurchasePointsLine(buffer);
        this.appendPoolPointsLine(buffer);
        PCGVer2Creator.appendGameModeLine(buffer);
        PCGVer2Creator.appendTabLabelLine(buffer);
        this.appendAutoSpellsLine(buffer);
        this.appendLoadCompanionLine(buffer);
        this.appendUseTempModsLine(buffer);
        this.appendOutputSheetsLines(buffer);
        this.appendAutoSortLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Bio", buffer);
        this.appendCharacterNameLine(buffer);
        this.appendTabNameLine(buffer);
        this.appendPlayerNameLine(buffer);
        this.appendHeightLine(buffer);
        this.appendWeightLine(buffer);
        this.appendAgeLine(buffer);
        this.appendGenderLine(buffer);
        this.appendHandedLine(buffer);
        this.appendSkinColorLine(buffer);
        this.appendEyeColorLine(buffer);
        this.appendHairColorLine(buffer);
        this.appendHairStyleLine(buffer);
        this.appendLocationLine(buffer);
        this.appendResidenceLine(buffer);
        this.appendBirthplaceLine(buffer);
        this.appendPersonalityTrait1Line(buffer);
        this.appendPersonalityTrait2Line(buffer);
        this.appendSpeechPatternLine(buffer);
        this.appendPhobiasLine(buffer);
        this.appendInterestsLine(buffer);
        this.appendCatchPhraseLine(buffer);
        this.appendPortraitLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Attributes", buffer);
        this.appendStatLines(buffer);
        this.appendAlignmentLine(buffer);
        this.appendRaceLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Class(es)", buffer);
        this.appendClassLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Experience", buffer);
        this.appendExperienceLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Templates", buffer);
        this.appendTemplateLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Region", buffer);
        this.appendRegionLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Skills", buffer);
        this.appendSkillLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Languages", buffer);
        this.appendLanguageLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Feats", buffer);
        this.appendFeatLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Weapon proficiencies", buffer);
        this.appendWeaponProficiencyLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Equipment", buffer);
        this.appendMoneyLine(buffer);
        this.appendEquipmentLines(buffer);
        this.appendEquipmentSetLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Temporary Bonuses", buffer);
        this.appendTempBonuses(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("EquipSet Temp Bonuses", buffer);
        this.appendEqSetBonuses(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Deity/Domain", buffer);
        this.appendDeityLine(buffer);
        this.appendDomainLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Spells Information", buffer);
        this.appendSpellLines(buffer);
        this.appendSpellListLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Description/Bio/History", buffer);
        this.appendCharacterBioLine(buffer);
        this.appendCharacterDescLine(buffer);
        this.appendCharacterCompLine(buffer);
        this.appendCharacterAssetLine(buffer);
        this.appendCharacterMagicLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Master/Follower", buffer);
        this.appendFollowerLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Notes Tab", buffer);
        this.appendNotesLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Kits", buffer);
        this.appendKitLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Chosen Armor Profs", buffer);
        this.appendArmorProfLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Age Set Selections", buffer);
        this.appendAgeSetLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        return buffer.toString();
    }

    private static void appendCampaignLine(StringBuffer buffer) {
        String del = "";
        Iterator it = Globals.getCampaignList().iterator();
        while (it.hasNext()) {
            Campaign aCamp = (Campaign)it.next();
            if (!aCamp.isLoaded()) continue;
            buffer.append(del);
            buffer.append("CAMPAIGN").append(':');
            buffer.append(aCamp.getName());
            del = "|";
        }
        buffer.append(LINE_SEP);
    }

    private static void appendGameModeLine(StringBuffer buffer) {
        buffer.append("GAMEMODE").append(':');
        buffer.append(SettingsHandler.getGame().getName());
        buffer.append(LINE_SEP);
    }

    private static void appendPCGVersionLine(StringBuffer buffer) {
        buffer.append("PCGVERSION").append(':');
        buffer.append("2.0");
        buffer.append(LINE_SEP);
    }

    private static void appendPurchasePointsLine(StringBuffer buffer) {
        buffer.append("PURCHASEPOINTS").append(':');
        buffer.append(SettingsHandler.isPurchaseStatMode() ? "Y" : "N");
        buffer.append('|');
        buffer.append("TYPE").append(':');
        buffer.append(LINE_SEP);
    }

    private static void appendRollMethodLine(StringBuffer buffer) {
        buffer.append("ROLLMETHOD").append(':');
        buffer.append(SettingsHandler.getRollMethod());
        buffer.append('|');
        buffer.append("EXPRESSION").append(':');
        buffer.append(SettingsHandler.getRollMethodExpression(SettingsHandler.getRollMethod()));
        buffer.append(LINE_SEP);
    }

    private static void appendVersionLine(StringBuffer buffer) {
        buffer.append("VERSION").append(':');
        try {
            ResourceBundle d_properties = ResourceBundle.getBundle("pcgen/gui/prop/PCGenProp");
            buffer.append(d_properties.getString("VersionNumber"));
        }
        catch (MissingResourceException mre) {
            Object d_properties = null;
        }
        buffer.append(LINE_SEP);
    }

    private void appendAgeLine(StringBuffer buffer) {
        buffer.append("AGE").append(':');
        buffer.append(this.aPC.getAge());
        buffer.append(LINE_SEP);
    }

    private void appendAgeSetLine(StringBuffer buffer) {
        buffer.append("AGESET");
        for (int i = 0; i < 10; ++i) {
            buffer.append(":");
            if (this.aPC.hasMadeKitSelectionForAgeSet(i)) {
                buffer.append("1");
                continue;
            }
            buffer.append("0");
        }
    }

    private void appendAlignmentLine(StringBuffer buffer) {
        if (Globals.getGameModeAlignmentText().length() != 0) {
            buffer.append("ALIGN").append(':');
            buffer.append(SettingsHandler.getGame().getShortAlignmentAtIndex(this.aPC.getAlignment()));
            buffer.append(LINE_SEP);
        }
    }

    private void appendArmorProfLines(StringBuffer buffer) {
        Iterator i;
        if (this.aPC.getDeity() != null && this.aPC.getDeity().getSelectedArmorProfs() != null) {
            buffer.append("ARMORPROF").append(':').append("DEITY").append('=').append(this.aPC.getDeity().getName()).append(':');
            Iterator i2 = this.aPC.getDeity().getSelectedArmorProfs().iterator();
            while (i2.hasNext()) {
                buffer.append((String)i2.next()).append(':');
            }
            buffer.append(LINE_SEP);
        }
        Iterator j = this.aPC.getClassList().iterator();
        while (j.hasNext()) {
            PCClass aClass = (PCClass)j.next();
            if (aClass.getSelectedArmorProfs() == null) continue;
            buffer.append("ARMORPROF").append(':').append("CLASS").append('=').append(aClass.getName()).append(':');
            i = aClass.getSelectedArmorProfs().iterator();
            while (i.hasNext()) {
                buffer.append((String)i.next()).append(':');
            }
            buffer.append(LINE_SEP);
        }
        j = this.aPC.aggregateFeatList().iterator();
        while (j.hasNext()) {
            Feat aFeat = (Feat)j.next();
            if (aFeat.getSelectedArmorProfs() == null) continue;
            buffer.append("ARMORPROF").append(':').append("FEAT").append('=').append(aFeat.getName()).append(':');
            i = aFeat.getSelectedArmorProfs().iterator();
            while (i.hasNext()) {
                buffer.append((String)i.next()).append(':');
            }
            buffer.append(LINE_SEP);
        }
        j = this.aPC.getSkillList().iterator();
        while (j.hasNext()) {
            Skill aSkill = (Skill)j.next();
            if (aSkill.getSelectedArmorProfs() == null) continue;
            buffer.append("ARMORPROF").append(':').append("SKILL").append('=').append(aSkill.getName()).append(':');
            i = aSkill.getSelectedArmorProfs().iterator();
            while (i.hasNext()) {
                buffer.append((String)i.next()).append(':');
            }
            buffer.append(LINE_SEP);
        }
        j = this.aPC.getCharacterDomainList().iterator();
        while (j.hasNext()) {
            CharacterDomain aCD = (CharacterDomain)j.next();
            if (aCD.getDomain() == null || aCD.getDomain().getSelectedArmorProfs() == null) continue;
            buffer.append("ARMORPROF").append(':').append("DOMAIN").append('=').append(aCD.getDomain().getName()).append(':');
            i = aCD.getDomain().getSelectedArmorProfs().iterator();
            while (i.hasNext()) {
                buffer.append((String)i.next()).append(':');
            }
            buffer.append(LINE_SEP);
        }
        Iterator e = this.aPC.getEquipmentMasterList().iterator();
        while (e.hasNext()) {
            Equipment eq = (Equipment)e.next();
            if (!eq.isEquipped() || eq.getSelectedArmorProfs() == null) continue;
            buffer.append("ARMORPROF").append(':').append("EQUIPMENT").append('=').append(eq.getName()).append(':');
            i = eq.getSelectedArmorProfs().iterator();
            while (i.hasNext()) {
                buffer.append((String)i.next()).append(':');
            }
            buffer.append(LINE_SEP);
        }
        j = this.aPC.getTemplateList().iterator();
        while (j.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)j.next();
            if (aTemplate.getSelectedArmorProfs() == null) continue;
            buffer.append("ARMORPROF").append(':').append("TEMPLATE").append('=').append(aTemplate.getName()).append(':');
            i = aTemplate.getSelectedArmorProfs().iterator();
            while (i.hasNext()) {
                buffer.append((String)i.next()).append(':');
            }
            buffer.append(LINE_SEP);
        }
    }

    private void appendBirthplaceLine(StringBuffer buffer) {
        buffer.append("BIRTHPLACE").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getBirthplace()));
        buffer.append(LINE_SEP);
    }

    private void appendCatchPhraseLine(StringBuffer buffer) {
        buffer.append("CATCHPHRASE").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getCatchPhrase()));
        buffer.append(LINE_SEP);
    }

    private void appendCharacterAssetLine(StringBuffer buffer) {
        buffer.append("CHARACTERASSET").append(':');
        buffer.append(EntityEncoder.encode((String)this.aPC.getMiscList().get(0)));
        buffer.append(LINE_SEP);
    }

    private void appendCharacterBioLine(StringBuffer buffer) {
        buffer.append("CHARACTERBIO").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getBio()));
        buffer.append(LINE_SEP);
    }

    private void appendCharacterCompLine(StringBuffer buffer) {
        buffer.append("CHARACTERCOMP").append(':');
        buffer.append(EntityEncoder.encode((String)this.aPC.getMiscList().get(1)));
        buffer.append(LINE_SEP);
    }

    private void appendCharacterDescLine(StringBuffer buffer) {
        buffer.append("CHARACTERDESC").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getDescription()));
        buffer.append(LINE_SEP);
    }

    private void appendCharacterMagicLine(StringBuffer buffer) {
        buffer.append("CHARACTERMAGIC").append(':');
        buffer.append(EntityEncoder.encode((String)this.aPC.getMiscList().get(2)));
        buffer.append(LINE_SEP);
    }

    private void appendClassLines(StringBuffer buffer) {
        PCClass aClass;
        Cache specials = new Cache();
        Iterator it = this.aPC.getClassList().iterator();
        while (it.hasNext()) {
            String prohibited;
            boolean isPsionic;
            aClass = (PCClass)it.next();
            int classLevel = aClass.getLevel();
            buffer.append("CLASS").append(':');
            buffer.append(EntityEncoder.encode(aClass.getKeyName()));
            String subClassName = aClass.getSubClassName();
            if (!"".equals(subClassName)) {
                buffer.append('|');
                buffer.append("SUBCLASS").append(':');
                buffer.append(EntityEncoder.encode(subClassName));
            }
            buffer.append('|');
            buffer.append("LEVEL").append(':');
            buffer.append(classLevel);
            buffer.append('|');
            buffer.append("SKILLPOOL").append(':');
            buffer.append(aClass.skillPool().toString());
            boolean isCaster = false;
            if (!aClass.zeroCastSpells()) {
                isCaster = true;
            }
            boolean bl = isPsionic = aClass.getKnownList().size() > 0 && !isCaster;
            if (isCaster || isPsionic) {
                buffer.append('|');
                buffer.append("SPELLBASE").append(':');
                buffer.append(EntityEncoder.encode(aClass.getSpellBaseStat()));
                buffer.append('|');
                buffer.append("CANCASTPERDAY").append(':');
                buffer.append(aClass.getCastStringForLevel(classLevel));
            }
            if (!"".equals(prohibited = aClass.getProhibitedString())) {
                buffer.append('|');
                buffer.append("PROHIBITED").append(':');
                buffer.append(EntityEncoder.encode(prohibited));
            }
            buffer.append(LINE_SEP);
            String key = aClass.getKeyName() + "SPECIALTY" + '0';
            Iterator it2 = aClass.getSpecialtyList().iterator();
            while (it2.hasNext()) {
                specials.put(key, (String)it2.next());
            }
            key = aClass.getKeyName() + "SAVE" + '0';
            for (int i = 0; i < aClass.getSaveCount(); ++i) {
                String aSave = aClass.getSave(i);
                SpecialAbility aSpecialAbility = aClass.getSpecialAbilityNamed(aSave);
                if (aSpecialAbility != null) {
                    int relevantLevel = 1;
                    String aSource = aSpecialAbility.getSASource();
                    try {
                        relevantLevel = Integer.parseInt(aSource.substring(aSource.lastIndexOf(124) + 1));
                        if (relevantLevel < 0) {
                            relevantLevel = 1;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    specials.put(aClass.getKeyName() + "SA" + (relevantLevel - 1), aSpecialAbility.getName());
                    continue;
                }
                specials.put(key, aSave);
            }
        }
        Iterator i = this.aPC.getLevelInfo().iterator();
        while (i.hasNext()) {
            int sp;
            List statList;
            PCLevelInfo pcl = (PCLevelInfo)i.next();
            String classKeyName = pcl.getClassKeyName();
            int lvl = pcl.getLevel() - 1;
            aClass = this.aPC.getClassKeyed(classKeyName);
            buffer.append("CLASSABILITIESLEVEL").append(':');
            if (aClass == null && (aClass = Globals.getClassNamed(classKeyName)) != null) {
                aClass = this.aPC.getClassNamed(aClass.getExClass());
            }
            if (aClass != null) {
                buffer.append(EntityEncoder.encode(aClass.getKeyName()));
            } else {
                buffer.append(EntityEncoder.encode("???"));
            }
            buffer.append('=').append(lvl + 1);
            if (aClass != null) {
                buffer.append('|');
                buffer.append("HITPOINTS").append(':');
                buffer.append(aClass.getHitPoint(lvl).toString());
                PCGVer2Creator.appendSpecials(buffer, specials.get(aClass.getKeyName() + "SAVE" + lvl), "SAVES", "SAVE", lvl);
                PCGVer2Creator.appendSpecials(buffer, specials.get(aClass.getKeyName() + "SPECIALTY" + lvl), "SPECIALTIES", "SPECIALTY", lvl);
                PCGVer2Creator.appendSpecials(buffer, specials.get(aClass.getKeyName() + "SA" + lvl), "SPECIALABILITIES", "SA", lvl);
                if (lvl == 0) {
                    PCGVer2Creator.appendSpecials(buffer, specials.get(aClass.getKeyName() + "SA" + (lvl - 1)), "SPECIALABILITIES", "SA", -1);
                }
                if (aClass.getLevelAbilityList() != null) {
                    Iterator it2 = aClass.getLevelAbilityList().iterator();
                    while (it2.hasNext()) {
                        LevelAbility la = (LevelAbility)it2.next();
                        if (la.level() - 1 != lvl || la.getAssociatedCount() == 0) continue;
                        buffer.append('|').append("ABILITY").append(":[").append("PROMPT").append(':').append(EntityEncoder.encode(la.getList()));
                        for (int j = 0; j < la.getAssociatedCount(true); ++j) {
                            buffer.append('|').append("CHOICE").append(':').append(EntityEncoder.encode(la.getAssociated(j, true)));
                        }
                        buffer.append(']');
                    }
                }
            }
            if ((statList = pcl.getModifiedStats(true)) != null) {
                for (int j = 0; j < statList.size(); ++j) {
                    buffer.append('|').append("PRESTAT").append(':').append(statList.get(j).toString());
                }
            }
            if ((statList = pcl.getModifiedStats(false)) != null) {
                for (int j = 0; j < statList.size(); ++j) {
                    buffer.append('|').append("POSTSTAT").append(':').append(statList.get(j).toString());
                }
            }
            if ((sp = pcl.getSkillPointsGained(false, this.aPC)) != 0) {
                buffer.append('|').append("SKILLSGAINED").append(":" + sp);
            }
            if ((sp = pcl.getSkillPointsRemaining(false, this.aPC)) != 0) {
                buffer.append('|').append("SKILLSREMAINING").append(":" + sp);
            }
            buffer.append(LINE_SEP);
        }
    }

    private static void appendComment(String comment, StringBuffer buffer) {
        buffer.append(PCGVer2Creator.createComment(comment));
    }

    private void appendDeityLine(StringBuffer buffer) {
        if (this.aPC.getDeity() != null) {
            Deity aDeity = this.aPC.getDeity();
            buffer.append("DEITY").append(':');
            buffer.append(EntityEncoder.encode(aDeity.getKeyName()));
            buffer.append('|');
            buffer.append("DEITYDOMAINS").append(':');
            buffer.append('[');
            String del = "";
            Iterator it = aDeity.getDomainList().iterator();
            while (it.hasNext()) {
                buffer.append(del);
                buffer.append("DOMAIN").append(':');
                Domain aDomain = (Domain)it.next();
                if (aDomain == null) {
                    buffer.append(EntityEncoder.encode("None"));
                } else {
                    buffer.append(EntityEncoder.encode(aDomain.getKeyName()));
                }
                del = "|";
            }
            buffer.append(']');
            buffer.append('|');
            buffer.append("ALIGNALLOW").append(':');
            buffer.append(aDeity.getFollowerAlignments());
            buffer.append('|');
            buffer.append("DESC").append(':');
            buffer.append(EntityEncoder.encode(aDeity.getDescription()));
            buffer.append('|');
            buffer.append("HOLYITEM").append(':');
            buffer.append(EntityEncoder.encode(aDeity.getHolyItem()));
            buffer.append('|');
            buffer.append("DEITYFAVWEAP").append(':');
            buffer.append('[');
            StringTokenizer tokens = new StringTokenizer(aDeity.getFavoredWeapon(), "|");
            del = "";
            while (tokens.hasMoreTokens()) {
                buffer.append(del);
                buffer.append("WEAPON").append(':');
                buffer.append(EntityEncoder.encode(tokens.nextToken()));
                del = "|";
            }
            buffer.append(']');
            buffer.append('|');
            buffer.append("DEITYALIGN").append(':');
            buffer.append(aDeity.getAlignment());
            buffer.append(LINE_SEP);
        }
    }

    private void appendDomainLines(StringBuffer buffer) {
        Iterator it = this.aPC.getCharacterDomainList().iterator();
        while (it.hasNext()) {
            Domain aDomain;
            CharacterDomain aCharDomain = (CharacterDomain)it.next();
            if (aCharDomain == null || (aDomain = aCharDomain.getDomain()) == null) continue;
            buffer.append("DOMAIN").append(':');
            buffer.append(EntityEncoder.encode(aDomain.getKeyName()));
            for (int i = 0; i < aDomain.getAssociatedCount(); ++i) {
                buffer.append('|');
                buffer.append("ASSOCIATEDDATA").append(':');
                buffer.append(EntityEncoder.encode(aDomain.getAssociated(i)));
            }
            buffer.append('|');
            buffer.append("DOMAINGRANTS").append(':');
            buffer.append(EntityEncoder.encode(aDomain.getDescription()));
            buffer.append('|');
            PCGVer2Creator.appendSourceInTaggedFormat(buffer, aCharDomain.getDomainSourcePcgString());
            buffer.append(LINE_SEP);
        }
    }

    private void appendEqSetBonuses(StringBuffer buffer) {
        List eqSetList = this.aPC.getEquipSet();
        Iterator it = eqSetList.iterator();
        while (it.hasNext()) {
            EquipSet eSet = (EquipSet)it.next();
            if (!eSet.useTempBonusList()) continue;
            buffer.append("EQSETBONUS").append(':');
            buffer.append(eSet.getIdPath());
            List aList = eSet.getTempBonusList();
            LinkedList<String> trackList = new LinkedList<String>();
            Iterator ab = aList.iterator();
            while (ab.hasNext()) {
                Object tObj;
                BonusObj bObj = (BonusObj)ab.next();
                Object cObj = bObj.getCreatorObject();
                String aName = this.tempBonusName(cObj, tObj = bObj.getTargetObject());
                if (trackList.contains(aName)) continue;
                trackList.add(aName);
                buffer.append('|');
                buffer.append("TBBONUS").append(':');
                buffer.append(EntityEncoder.encode(aName));
            }
            buffer.append(LINE_SEP);
        }
    }

    private void appendEquipmentLines(StringBuffer buffer) {
        Iterator it = this.aPC.getEquipmentMasterList().iterator();
        while (it.hasNext()) {
            Equipment aEquip = (Equipment)it.next();
            buffer.append("EQUIPNAME").append(':');
            buffer.append(EntityEncoder.encode(aEquip.getName()));
            buffer.append('|');
            buffer.append("OUTPUTORDER").append(':');
            buffer.append(aEquip.getOutputIndex());
            buffer.append('|');
            buffer.append("COST").append(':');
            buffer.append(aEquip.getCost(this.aPC).toString());
            buffer.append('|');
            buffer.append("WT").append(':');
            buffer.append(aEquip.getWeight(this.aPC).toString());
            buffer.append('|');
            buffer.append("QUANTITY").append(':');
            buffer.append(aEquip.qty());
            String customization = aEquip.formatSaveLine("$", "=").trim();
            int delimiterIndex = customization.indexOf(36);
            if (customization.length() > 0 && delimiterIndex >= 0) {
                buffer.append('|');
                buffer.append("CUSTOMIZATION").append(':');
                buffer.append('[');
                buffer.append("BASEITEM").append(':');
                buffer.append(EntityEncoder.encode(customization.substring(0, delimiterIndex)));
                buffer.append('|');
                buffer.append("DATA").append(':');
                buffer.append(EntityEncoder.encode(customization.substring(delimiterIndex + 1)));
                buffer.append(']');
            }
            buffer.append(LINE_SEP);
        }
    }

    private void appendEquipmentSetLines(StringBuffer buffer) {
        List eqSetList = this.aPC.getEquipSet();
        Collections.sort(eqSetList);
        Iterator it = eqSetList.iterator();
        while (it.hasNext()) {
            EquipSet aEquipSet = (EquipSet)it.next();
            buffer.append("EQUIPSET").append(':');
            buffer.append(EntityEncoder.encode(aEquipSet.getName()));
            buffer.append('|');
            buffer.append("ID").append(':');
            buffer.append(aEquipSet.getIdPath());
            if (aEquipSet.getValue().length() > 0) {
                buffer.append('|');
                buffer.append("VALUE").append(':');
                buffer.append(EntityEncoder.encode(aEquipSet.getValue()));
                buffer.append('|');
                buffer.append("QUANTITY").append(':');
                buffer.append(aEquipSet.getQty());
            }
            if (aEquipSet.getNote().length() > 0) {
                buffer.append('|');
                buffer.append("NOTE").append(':');
                buffer.append(aEquipSet.getNote());
            }
            if (aEquipSet.getUseTempMods()) {
                buffer.append('|');
                buffer.append("USETEMPMODS").append(':');
                buffer.append(aEquipSet.getUseTempMods() ? "Y" : "N");
            }
            buffer.append(LINE_SEP);
        }
        String calcEquipSet = this.aPC.getCalcEquipSetId();
        buffer.append("CALCEQUIPSET").append(':');
        buffer.append(calcEquipSet);
        buffer.append(LINE_SEP);
    }

    private void appendEyeColorLine(StringBuffer buffer) {
        buffer.append("EYECOLOR").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getEyeColor()));
        buffer.append(LINE_SEP);
    }

    private void appendFeatLines(StringBuffer buffer) {
        Feat aFeat;
        ArrayList aList = this.aPC.getFeatList();
        ArrayList<Feat> bList = new ArrayList<Feat>();
        Iterator it = this.aPC.getVirtualFeatList().iterator();
        while (it.hasNext()) {
            aFeat = (Feat)it.next();
            if (!aFeat.needsSaving()) continue;
            bList.add(aFeat);
        }
        aList.addAll(bList);
        it = aList.iterator();
        while (it.hasNext()) {
            aFeat = (Feat)it.next();
            if (aFeat.isMultiples()) {
                for (int it2 = 0; it2 < aFeat.getAssociatedCount(); ++it2) {
                    if (bList.contains(aFeat)) {
                        buffer.append("VFEAT");
                    } else {
                        buffer.append("FEAT");
                    }
                    buffer.append(':');
                    buffer.append(EntityEncoder.encode(aFeat.getKeyName()));
                    buffer.append('|');
                    buffer.append("APPLIEDTO").append(':');
                    if (aFeat.getAssociatedObject(0) instanceof FeatMultipleChoice) {
                        buffer.append("MULTISELECT").append(':');
                    }
                    buffer.append(EntityEncoder.encode(aFeat.getAssociated(it2)));
                    buffer.append('|');
                    buffer.append("TYPE").append(':');
                    buffer.append(EntityEncoder.encode(aFeat.getType()));
                    int it3 = 0;
                    int maxit3 = aFeat.getSaveCount();
                    if (aFeat.getAssociatedCount() == aFeat.getSaveCount()) {
                        it3 = it2;
                        maxit3 = it3 + 1;
                    }
                    while (it3 < maxit3) {
                        buffer.append('|');
                        buffer.append("SAVE").append(':');
                        buffer.append(EntityEncoder.encode(aFeat.getSave(it3)));
                        ++it3;
                    }
                    buffer.append('|');
                    buffer.append("DESC").append(':');
                    buffer.append(EntityEncoder.encode(aFeat.getDescription()));
                    buffer.append(LINE_SEP);
                }
                continue;
            }
            if (bList.contains(aFeat)) {
                buffer.append("VFEAT");
            } else {
                buffer.append("FEAT");
            }
            buffer.append(':');
            buffer.append(EntityEncoder.encode(aFeat.getKeyName()));
            buffer.append('|');
            buffer.append("TYPE").append(':');
            buffer.append(EntityEncoder.encode(aFeat.getType()));
            for (int it3 = 0; it3 < aFeat.getSaveCount(); ++it3) {
                buffer.append('|');
                buffer.append("SAVE").append(':');
                buffer.append(EntityEncoder.encode(aFeat.getSave(it3)));
            }
            buffer.append('|');
            buffer.append("DESC").append(':');
            buffer.append(EntityEncoder.encode(aFeat.getDescription()));
            buffer.append(LINE_SEP);
        }
        buffer.append("FEATPOOL").append(':');
        buffer.append(this.aPC.getFeats());
        buffer.append(LINE_SEP);
        aList.removeAll(bList);
    }

    private void appendFollowerLines(StringBuffer buffer) {
        List followers;
        Follower aMaster = this.aPC.getMaster();
        if (aMaster != null) {
            buffer.append("MASTER").append(':');
            buffer.append(EntityEncoder.encode(aMaster.getName()));
            buffer.append('|');
            buffer.append("TYPE").append(':');
            buffer.append(EntityEncoder.encode(aMaster.getType()));
            buffer.append('|');
            buffer.append("HITDICE").append(':');
            buffer.append(aMaster.getUsedHD());
            buffer.append('|');
            buffer.append("FILE").append(':');
            buffer.append(EntityEncoder.encode(aMaster.getRelativeFileName()));
            buffer.append(LINE_SEP);
        }
        if (!(followers = this.aPC.getFollowerList()).isEmpty()) {
            Iterator it = followers.iterator();
            while (it.hasNext()) {
                Follower aFollower = (Follower)it.next();
                buffer.append("FOLLOWER").append(':');
                buffer.append(EntityEncoder.encode(aFollower.getName()));
                buffer.append('|');
                buffer.append("TYPE").append(':');
                buffer.append(EntityEncoder.encode(aFollower.getType()));
                buffer.append('|');
                buffer.append("RACE").append(':');
                buffer.append(EntityEncoder.encode(aFollower.getRace().toUpperCase()));
                buffer.append('|');
                buffer.append("HITDICE").append(':');
                buffer.append(aFollower.getUsedHD());
                buffer.append('|');
                buffer.append("FILE").append(':');
                buffer.append(EntityEncoder.encode(aFollower.getRelativeFileName()));
                buffer.append(LINE_SEP);
            }
        }
    }

    private void appendGenderLine(StringBuffer buffer) {
        buffer.append("GENDER").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getGender()));
        buffer.append(LINE_SEP);
    }

    private void appendHairColorLine(StringBuffer buffer) {
        buffer.append("HAIRCOLOR").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getHairColor()));
        buffer.append(LINE_SEP);
    }

    private void appendHairStyleLine(StringBuffer buffer) {
        buffer.append("HAIRSTYLE").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getHairStyle()));
        buffer.append(LINE_SEP);
    }

    private void appendHandedLine(StringBuffer buffer) {
        buffer.append("HANDED").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getHanded()));
        buffer.append(LINE_SEP);
    }

    private void appendInterestsLine(StringBuffer buffer) {
        buffer.append("INTERESTS").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getInterests()));
        buffer.append(LINE_SEP);
    }

    private void appendKitLines(StringBuffer buffer) {
        if (this.aPC.getKitInfo() != null) {
            Iterator it = this.aPC.getKitInfo().iterator();
            while (it.hasNext()) {
                Kit aKit = (Kit)it.next();
                buffer.append("KIT").append(':').append(aKit.getKeyName()).append(LINE_SEP);
            }
        }
    }

    private void appendLanguageLine(StringBuffer buffer) {
        String del = "";
        Iterator it = this.aPC.getLanguagesList().iterator();
        while (it.hasNext()) {
            buffer.append(del);
            buffer.append("LANGUAGE").append(':');
            buffer.append(EntityEncoder.encode(it.next().toString()));
            del = "|";
        }
        buffer.append(LINE_SEP);
    }

    private void appendLocationLine(StringBuffer buffer) {
        buffer.append("LOCATION").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getLocation()));
        buffer.append(LINE_SEP);
    }

    private static void appendNewline(StringBuffer buffer) {
        buffer.append(LINE_SEP);
    }

    private void appendNotesLines(StringBuffer buffer) {
        Iterator i = this.aPC.getNotesList().iterator();
        while (i.hasNext()) {
            NoteItem ni = (NoteItem)i.next();
            buffer.append("NOTE").append(':');
            buffer.append(EntityEncoder.encode(ni.getName()));
            buffer.append('|');
            buffer.append("ID").append(':');
            buffer.append(ni.getId());
            buffer.append('|');
            buffer.append("PARENTID").append(':');
            buffer.append(ni.getParentId());
            buffer.append('|');
            buffer.append("VALUE").append(':');
            buffer.append(EntityEncoder.encode(ni.getValue()));
            buffer.append(LINE_SEP);
        }
    }

    private void appendPersonalityTrait1Line(StringBuffer buffer) {
        buffer.append("PERSONALITYTRAIT1").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getTrait1()));
        buffer.append(LINE_SEP);
    }

    private void appendPersonalityTrait2Line(StringBuffer buffer) {
        buffer.append("PERSONALITYTRAIT2").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getTrait2()));
        buffer.append(LINE_SEP);
    }

    private void appendPhobiasLine(StringBuffer buffer) {
        buffer.append("PHOBIAS").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getPhobias()));
        buffer.append(LINE_SEP);
    }

    private void appendPoolPointsLine(StringBuffer buffer) {
        buffer.append("POOLPOINTS").append(':');
        buffer.append(this.aPC.getPoolAmount());
        buffer.append(LINE_SEP);
    }

    private static void appendTabLabelLine(StringBuffer buffer) {
        buffer.append("TABLABEL").append(':');
        buffer.append(SettingsHandler.getNameDisplayStyle());
        buffer.append(LINE_SEP);
    }

    private void appendAutoSortLines(StringBuffer buffer) {
        buffer.append("AUTOSORTGEAR").append(':');
        buffer.append(this.aPC.isAutoSortGear() ? "Y" : "N");
        buffer.append(LINE_SEP);
        buffer.append("SKILLSOUTPUTORDER").append(':');
        buffer.append(this.aPC.getSkillsOutputOrder());
        buffer.append(LINE_SEP);
    }

    private void appendAutoSpellsLine(StringBuffer buffer) {
        buffer.append("AUTOSPELLS").append(':');
        buffer.append(this.aPC.getAutoSpells() ? "Y" : "N");
        buffer.append(LINE_SEP);
    }

    private void appendCharacterNameLine(StringBuffer buffer) {
        buffer.append("CHARACTERNAME").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getName()));
        buffer.append(LINE_SEP);
    }

    private void appendHeightLine(StringBuffer buffer) {
        buffer.append("HEIGHT").append(':');
        buffer.append(this.aPC.getHeightInInches());
        buffer.append(LINE_SEP);
    }

    private void appendLoadCompanionLine(StringBuffer buffer) {
        buffer.append("LOADCOMPANIONS").append(':');
        buffer.append(this.aPC.getLoadCompanion() ? "Y" : "N");
        buffer.append(LINE_SEP);
    }

    private void appendOutputSheetsLines(StringBuffer buffer) {
        if (SettingsHandler.getSaveOutputSheetWithPC()) {
            buffer.append("OUTPUTSHEETHTML").append(':');
            buffer.append(EntityEncoder.encode(SettingsHandler.getSelectedCharacterHTMLOutputSheet(this.aPC)));
            buffer.append(LINE_SEP);
            buffer.append("OUTPUTSHEETPDF").append(':');
            buffer.append(EntityEncoder.encode(SettingsHandler.getSelectedCharacterPDFOutputSheet(this.aPC)));
            buffer.append(LINE_SEP);
        }
    }

    private void appendPlayerNameLine(StringBuffer buffer) {
        buffer.append("PLAYERNAME").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getPlayersName()));
        buffer.append(LINE_SEP);
    }

    private void appendPortraitLine(StringBuffer buffer) {
        buffer.append("PORTRAIT").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getPortraitPath()));
        buffer.append(LINE_SEP);
    }

    private void appendRaceLine(StringBuffer buffer) {
        buffer.append("RACE").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getRace().getKeyName()));
        int hitDice = this.aPC.getRace().hitDice(this.aPC);
        if (hitDice != 0) {
            buffer.append('|').append("HITPOINTS");
            for (int j = 0; j < hitDice; ++j) {
                buffer.append(':').append(this.aPC.getRace().getHitPoint(j).toString());
            }
        }
        buffer.append(LINE_SEP);
    }

    private void appendResidenceLine(StringBuffer buffer) {
        buffer.append("CITY").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getResidence()));
        buffer.append(LINE_SEP);
    }

    private void appendSkinColorLine(StringBuffer buffer) {
        buffer.append("SKINCOLOR").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getSkinColor()));
        buffer.append(LINE_SEP);
    }

    private static void appendSourceInTaggedFormat(StringBuffer buffer, String source) {
        StringTokenizer tokens = new StringTokenizer(source, "|=");
        buffer.append("SOURCE").append(':');
        buffer.append('[');
        buffer.append("TYPE").append(':');
        buffer.append(tokens.nextToken());
        buffer.append('|');
        buffer.append("NAME").append(':');
        buffer.append(tokens.nextToken());
        if (tokens.hasMoreTokens()) {
            buffer.append('|');
            buffer.append("LEVEL").append(':');
            buffer.append(tokens.nextToken());
        }
        if (source.indexOf(61) >= 0) {
            buffer.append('|');
            buffer.append("DEFINED").append(':');
            buffer.append("Y");
        }
        buffer.append(']');
    }

    private static void appendSourceInTaggedFormat(StringBuffer buffer, PObject source) {
        buffer.append("SOURCE").append(':');
        buffer.append('[');
        buffer.append("TYPE").append(':');
        Class<?> srcClass = source.getClass();
        String pckName = srcClass.getPackage().getName();
        String srcName = srcClass.getName().substring(pckName.length() + 1);
        buffer.append(srcName.toUpperCase());
        buffer.append('|');
        buffer.append("NAME").append(':');
        buffer.append(source.getName());
        buffer.append(']');
    }

    private static void appendSpecials(StringBuffer buffer, List specials, String tag_group, String tag_item, int lvl) {
        if (specials != null && !specials.isEmpty()) {
            buffer.append('|');
            buffer.append(tag_group).append(':');
            buffer.append('[');
            String del = "";
            Iterator it2 = specials.iterator();
            while (it2.hasNext()) {
                buffer.append(del);
                buffer.append(tag_item).append(':');
                buffer.append(EntityEncoder.encode((String)it2.next()));
                if (lvl == -1) {
                    buffer.append(":-1");
                }
                del = "|";
            }
            buffer.append(']');
        }
    }

    private void appendExperienceLine(StringBuffer buffer) {
        buffer.append("EXPERIENCE").append(':');
        buffer.append(this.aPC.getXP());
        buffer.append(LINE_SEP);
    }

    private void appendRegionLine(StringBuffer buffer) {
        String r = this.aPC.getRegion(false);
        if (r != null) {
            buffer.append("REGION").append(':').append(r).append(LINE_SEP);
        }
    }

    private void appendSkillLines(StringBuffer buffer) {
        Iterator it = this.aPC.getSkillList().iterator();
        while (it.hasNext()) {
            Skill aSkill = (Skill)it.next();
            if (!(aSkill.getRank().doubleValue() > 0.0) && aSkill.getOutputIndex() == 0) continue;
            buffer.append("SKILL").append(':');
            buffer.append(EntityEncoder.encode(aSkill.getKeyName()));
            String del = "|SYNERGY:";
            Iterator it2 = aSkill.getSynergyList().iterator();
            while (it2.hasNext()) {
                buffer.append(del).append((String)it2.next());
                del = ",";
            }
            buffer.append('|');
            buffer.append("OUTPUTORDER").append(':');
            buffer.append(aSkill.getOutputIndex());
            buffer.append('|');
            Iterator it22 = aSkill.getRankList().iterator();
            while (it22.hasNext()) {
                String classRanks = (String)it22.next();
                int index = classRanks.indexOf(58);
                String className = classRanks.substring(0, index);
                String ranks = classRanks.substring(index + 1);
                PCClass aPCClass = this.aPC.getClassKeyed(className);
                buffer.append("CLASSBOUGHT").append(':');
                buffer.append('[');
                buffer.append("CLASS").append(':');
                buffer.append(EntityEncoder.encode(className));
                buffer.append('|');
                buffer.append("RANKS").append(':');
                buffer.append(ranks);
                buffer.append('|');
                buffer.append("COST").append(':');
                buffer.append(aSkill.costForPCClass(aPCClass, this.aPC).toString());
                buffer.append('|');
                buffer.append("CLASSSKILL").append(':');
                buffer.append(aSkill.isClassSkill(aPCClass, this.aPC) ? "Y" : "N");
                buffer.append(']');
            }
            for (int i = 0; i < aSkill.getAssociatedCount(); ++i) {
                buffer.append('|');
                buffer.append("ASSOCIATEDDATA").append(':');
                buffer.append(EntityEncoder.encode(aSkill.getAssociated(i)));
            }
            buffer.append(LINE_SEP);
        }
    }

    private void appendSpeechPatternLine(StringBuffer buffer) {
        buffer.append("SPEECHPATTERN").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getSpeechTendency()));
        buffer.append(LINE_SEP);
    }

    private void appendSpellLines(StringBuffer buffer) {
        Iterator it = this.aPC.getClassList().iterator();
        while (it.hasNext()) {
            PCClass aClass = (PCClass)it.next();
            Iterator it2 = aClass.getCharacterSpell(null, "", -1).iterator();
            while (it2.hasNext()) {
                CharacterSpell aCharacterSpell = (CharacterSpell)it2.next();
                Iterator it3 = aCharacterSpell.getInfoListIterator();
                while (it3.hasNext()) {
                    SpellInfo aSpellInfo = (SpellInfo)it3.next();
                    String spellKey = aCharacterSpell.getOwner().getSpellKey();
                    if (aSpellInfo.getBook().equals(Globals.getDefaultSpellBook()) && aClass.isAutoKnownSpell(aCharacterSpell.getSpell().getKeyName(), aCharacterSpell.getSpell().getFirstLevelForKey(spellKey, this.aPC), this.aPC) && this.aPC.getAutoSpells()) continue;
                    buffer.append("SPELLNAME").append(':');
                    buffer.append(EntityEncoder.encode(aCharacterSpell.getSpell().getKeyName()));
                    buffer.append('|');
                    buffer.append("TIMES").append(':');
                    buffer.append(aSpellInfo.getTimes());
                    buffer.append('|');
                    buffer.append("CLASS").append(':');
                    buffer.append(EntityEncoder.encode(aClass.getName()));
                    buffer.append('|');
                    buffer.append("BOOK").append(':');
                    buffer.append(EntityEncoder.encode(aSpellInfo.getBook()));
                    buffer.append('|');
                    buffer.append("SPELLLEVEL").append(':');
                    buffer.append(aSpellInfo.getActualLevel());
                    List metaFeats = aSpellInfo.getFeatList();
                    if (metaFeats != null && !metaFeats.isEmpty()) {
                        buffer.append('|');
                        buffer.append("FEATLIST").append(':');
                        buffer.append('[');
                        String del = "";
                        Iterator it4 = metaFeats.iterator();
                        while (it4.hasNext()) {
                            buffer.append(del);
                            buffer.append("FEAT").append(':');
                            buffer.append(EntityEncoder.encode(((Feat)it4.next()).getName()));
                            del = "|";
                        }
                        buffer.append(']');
                    }
                    buffer.append('|');
                    PCGVer2Creator.appendSourceInTaggedFormat(buffer, spellKey);
                    buffer.append(LINE_SEP);
                }
            }
        }
    }

    private void appendSpellListLines(StringBuffer buffer) {
        Iterator it = this.aPC.getClassList().iterator();
        while (it.hasNext()) {
            PCClass aClass = (PCClass)it.next();
            if (aClass.getClassSpellList() == null || aClass.getClassSpellList().size() <= 0) continue;
            buffer.append("SPELLLIST:");
            buffer.append(aClass.getName());
            Iterator ic = aClass.getClassSpellList().iterator();
            while (ic.hasNext()) {
                buffer.append('|').append(ic.next().toString());
            }
            buffer.append(LINE_SEP);
        }
    }

    private void appendStatLines(StringBuffer buffer) {
        Iterator i = this.aPC.getStatList().getStats().iterator();
        while (i.hasNext()) {
            PCStat aStat = (PCStat)i.next();
            buffer.append("STAT").append(':');
            buffer.append(aStat.getAbb());
            buffer.append('|');
            buffer.append("SCORE").append(':');
            buffer.append(aStat.getBaseScore());
            buffer.append(LINE_SEP);
        }
    }

    private void appendTabNameLine(StringBuffer buffer) {
        buffer.append("TABNAME").append(':');
        buffer.append(EntityEncoder.encode(this.aPC.getTabName()));
        buffer.append(LINE_SEP);
    }

    private void appendTempBonuses(StringBuffer buffer) {
        LinkedList<String> trackList = new LinkedList<String>();
        List tmList = this.aPC.getTempBonusList();
        Iterator it = tmList.iterator();
        while (it.hasNext()) {
            Object tarObj;
            BonusObj aBonus = (BonusObj)it.next();
            Object creObj = aBonus.getCreatorObject();
            String outString = this.tempBonusName(creObj, tarObj = aBonus.getTargetObject());
            if (trackList.contains(outString)) continue;
            trackList.add(outString);
            String tarString = this.tempBonusName(creObj, tarObj);
            buffer.append(tarString);
            Iterator b = this.aPC.getTempBonusList().iterator();
            while (b.hasNext()) {
                Object tObj;
                BonusObj bObj = (BonusObj)b.next();
                Object cObj = bObj.getCreatorObject();
                String inString = this.tempBonusName(cObj, tObj = bObj.getTargetObject());
                if (!inString.equals(outString)) continue;
                buffer.append('|');
                buffer.append("TBBONUS").append(':');
                buffer.append(EntityEncoder.encode(bObj.getPCCText()));
            }
            buffer.append(LINE_SEP);
        }
    }

    private void appendTemplateLines(StringBuffer buffer) {
        Iterator it = this.aPC.getTemplateList().iterator();
        while (it.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)it.next();
            buffer.append("TEMPLATESAPPLIED").append(':').append('[');
            buffer.append("NAME").append(':').append(EntityEncoder.encode(aTemplate.getKeyName()));
            String chosenFeats = this.chosenFeats(aTemplate);
            if (chosenFeats.length() != 0) {
                buffer.append('|').append(chosenFeats);
            }
            buffer.append(']').append(LINE_SEP);
        }
    }

    private void appendUseTempModsLine(StringBuffer buffer) {
        buffer.append("USETEMPMODS").append(':');
        buffer.append(this.aPC.getUseTempMods() ? "Y" : "N");
        buffer.append(LINE_SEP);
    }

    private void appendWeaponProficiencyLines(StringBuffer buffer) {
        int size = this.aPC.getWeaponProfList().size();
        if (size > 0) {
            String[] weaponProficiencies = new String[size];
            int j = 0;
            Iterator it = this.aPC.getWeaponProfList().iterator();
            while (it.hasNext()) {
                weaponProficiencies[j] = it.next().toString();
                ++j;
            }
            int step = 10;
            int times = size / 10 + (size % 10 > 0 ? 1 : 0);
            for (int k = 0; k < times; ++k) {
                buffer.append("WEAPONPROF").append(':');
                buffer.append('[');
                String del = "";
                int stop = Math.min(size, k * 10 + 10);
                for (int i = k * 10; i < stop; ++i) {
                    buffer.append(del);
                    buffer.append("WEAPON").append(':');
                    buffer.append(EntityEncoder.encode(weaponProficiencies[i]));
                    del = "|";
                }
                buffer.append(']');
                buffer.append(LINE_SEP);
            }
        }
        PCGVer2Creator.appendWeaponProficiencyLines(buffer, this.aPC.getRace());
        Iterator e = this.aPC.getClassList().iterator();
        while (e.hasNext()) {
            PCGVer2Creator.appendWeaponProficiencyLines(buffer, (PObject)e.next());
        }
        e = this.aPC.getCharacterDomainList().iterator();
        while (e.hasNext()) {
            PCGVer2Creator.appendWeaponProficiencyLines(buffer, ((CharacterDomain)e.next()).getDomain());
        }
        e = this.aPC.getFeatList().iterator();
        while (e.hasNext()) {
            PCGVer2Creator.appendWeaponProficiencyLines(buffer, (PObject)e.next());
        }
    }

    private static void appendWeaponProficiencyLines(StringBuffer buffer, PObject source) {
        int size;
        int n = size = source != null ? source.getSelectedWeaponProfBonusCount() : 0;
        if (size > 0) {
            int step = 10;
            int times = size / 10 + 1;
            for (int k = 0; k < times; ++k) {
                buffer.append("WEAPONPROF").append(':');
                buffer.append('[');
                String del = "";
                int stop = Math.min(size, k * 10 + 10);
                for (int i = k * 10; i < stop; ++i) {
                    buffer.append(del);
                    buffer.append("WEAPON").append(':');
                    buffer.append(EntityEncoder.encode(source.getSelectedWeaponProfBonus(i)));
                    del = "|";
                }
                buffer.append(']');
                buffer.append('|');
                PCGVer2Creator.appendSourceInTaggedFormat(buffer, source);
                buffer.append(LINE_SEP);
            }
        }
    }

    private void appendMoneyLine(StringBuffer buffer) {
        buffer.append("MONEY").append(':');
        buffer.append(this.aPC.getGold().toString());
        buffer.append(LINE_SEP);
    }

    private void appendWeightLine(StringBuffer buffer) {
        buffer.append("WEIGHT").append(':');
        buffer.append(this.aPC.getWeightInPounds());
        buffer.append(LINE_SEP);
    }

    private String chosenFeats(PCTemplate aTemplate) {
        StringBuffer aString = new StringBuffer(50);
        HashMap chosenFeatStrings = aTemplate.getChosenFeatStrings();
        if (chosenFeatStrings != null) {
            Iterator e = chosenFeatStrings.entrySet().iterator();
            while (e.hasNext()) {
                Map.Entry entry = e.next();
                if (aString.length() != 0) {
                    aString.append('|');
                }
                aString.append("CHOSENFEAT").append(':');
                aString.append('[');
                aString.append("KEY").append(':').append(EntityEncoder.encode(entry.getKey().toString())).append('|');
                aString.append("VALUE").append(':').append(EntityEncoder.encode(entry.getValue().toString()));
                aString.append(']');
            }
        }
        return aString.toString();
    }

    private static String createComment(String s) {
        String work = s + LINE_SEP;
        work = work.replace('\t', ' ');
        work = work.replace('\f', ' ');
        StringBuffer buffer = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(work, "#");
        while (tokens.hasMoreTokens()) {
            buffer.append(tokens.nextToken());
        }
        work = buffer.toString();
        buffer = new StringBuffer();
        tokens = new StringTokenizer(work, "\r\n");
        while (tokens.hasMoreTokens()) {
            buffer.append("# ").append(tokens.nextToken()).append(LINE_SEP);
        }
        return buffer.toString();
    }

    private String tempBonusName(Object creator, Object target) {
        PObject oCreator;
        StringBuffer cb = new StringBuffer();
        cb.append("TEMPBONUS").append(':');
        if (creator instanceof PObject) {
            oCreator = (PObject)creator;
            if (oCreator instanceof Feat) {
                cb.append("FEAT=");
            } else if (oCreator instanceof Spell) {
                cb.append("SPELL=");
            } else if (oCreator instanceof Equipment) {
                cb.append("EQUIPMENT=");
            } else if (oCreator instanceof PCClass) {
                cb.append("CLASS=");
            } else if (oCreator instanceof PCTemplate) {
                cb.append("TEMPLATE=");
            } else if (oCreator instanceof Skill) {
                cb.append("SKILL=");
            } else {
                cb.append("ERROR=");
            }
        } else {
            return "";
        }
        cb.append(EntityEncoder.encode(oCreator.getName()));
        cb.append("|");
        cb.append("TBTARGET").append(':');
        if (target instanceof PlayerCharacter) {
            cb.append("PC");
        } else if (target instanceof Equipment) {
            cb.append(EntityEncoder.encode(((Equipment)target).getName()));
        }
        return cb.toString();
    }
}

