/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import pcgen.core.Campaign;
import pcgen.core.CharacterDomain;
import pcgen.core.Constants;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.Feat;
import pcgen.core.FeatMultipleChoice;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.LevelAbility;
import pcgen.core.NoteItem;
import pcgen.core.PCClass;
import pcgen.core.PCSpell;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.EquipSet;
import pcgen.core.character.Follower;
import pcgen.core.character.SpellInfo;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.spell.Spell;
import pcgen.gui.PCGen_Frame1;
import pcgen.io.Cache;
import pcgen.io.EntityEncoder;
import pcgen.io.IOConstants;
import pcgen.io.PCGParseException;
import pcgen.io.PCGParser;
import pcgen.io.parsers.CharacterDomainParser;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.PersistenceManager;
import pcgen.util.Logging;

final class PCGVer2Parser
implements PCGParser,
IOConstants {
    private static final String LINE_SEP = "\n";
    private final List warnings = new ArrayList();
    private Cache cache;
    private final List weaponprofs = new ArrayList();
    private PlayerCharacter aPC;
    private final Set seenStats = new HashSet();
    private int[] pcgenVersion = new int[]{0, 0, 0};

    PCGVer2Parser(PlayerCharacter aPC) {
        this.aPC = aPC;
    }

    public List getWarnings() {
        return this.warnings;
    }

    public void parsePCG(String[] lines) throws PCGParseException {
        this.initCache(lines.length);
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].trim().length() <= 0 || PCGVer2Parser.isComment(lines[i])) continue;
            this.cacheLine(lines[i].trim());
        }
        this.parseCachedLines();
        this.aPC.setDirty(false);
    }

    private static boolean isComment(String line) {
        return line.trim().startsWith("#");
    }

    private List getBonusFromName(String sName, String tName) {
        String sourceStr = sName.substring("TEMPBONUS".length() + 1);
        String targetStr = tName.substring("TBTARGET".length() + 1);
        PObject oSource = null;
        Equipment oTarget = null;
        if (sourceStr.startsWith("FEAT=")) {
            sourceStr = sourceStr.substring(5);
            oSource = this.aPC.getFeatNamed(sourceStr);
        } else if (sourceStr.startsWith("SPELL=")) {
            sourceStr = sourceStr.substring(6);
            oSource = Globals.getSpellNamed(sourceStr);
        } else if (sourceStr.startsWith("EQUIPMENT=")) {
            sourceStr = sourceStr.substring(10);
            oSource = this.aPC.getEquipmentNamed(sourceStr);
        } else if (sourceStr.startsWith("CLASS=")) {
            sourceStr = sourceStr.substring(6);
            oSource = this.aPC.getClassNamed(sourceStr);
        } else if (sourceStr.startsWith("TEMPLATE=")) {
            sourceStr = sourceStr.substring(9);
            oSource = this.aPC.getTemplateNamed(sourceStr);
        } else if (sourceStr.startsWith("SKILL=")) {
            sourceStr = sourceStr.substring(6);
            oSource = this.aPC.getSkillNamed(sourceStr);
        }
        if (oSource != null) {
            sourceStr = ((PObject)oSource).getName();
        }
        if (targetStr.equals("PC")) {
            targetStr = this.aPC.getName();
        } else {
            oTarget = this.aPC.getEquipmentNamed(targetStr);
            targetStr = ((PObject)oTarget).getName();
        }
        List aList = this.aPC.getTempBonusList(sourceStr, targetStr);
        return aList;
    }

    private PCTemplate addNamedTemplate(String templateName) {
        PCTemplate aPCTemplate = Globals.getTemplateNamed(EntityEncoder.decode(templateName));
        if (aPCTemplate != null) {
            int preXP = this.aPC.getXP();
            aPCTemplate = this.aPC.addTemplate(aPCTemplate);
            if (this.aPC.getXP() != preXP) {
                this.aPC.setXP(preXP);
            }
        }
        return aPCTemplate;
    }

    private void cacheLine(String s) {
        this.cache.put(s.substring(0, s.indexOf(58)), s);
    }

    private void checkSkillPools() {
        int skillPoints = 0;
        Iterator it = this.aPC.getClassList().iterator();
        while (it.hasNext()) {
            skillPoints += ((PCClass)it.next()).getSkillPool(this.aPC).intValue();
        }
        this.aPC.setSkillPoints(skillPoints);
    }

    private void checkStats() throws PCGParseException {
        if (this.seenStats.size() != SettingsHandler.getGame().s_ATTRIBSHORT.length) {
            String message = "Number of attributes for character is " + this.seenStats.size() + ". " + "PCGen is currently using " + SettingsHandler.getGame().s_ATTRIBSHORT.length + ". " + "Cannot load character.";
            throw new PCGParseException("parseStatLines", "N/A", message);
        }
    }

    private void initCache(int capacity) {
        this.cache = new Cache(capacity * 4 / 3);
    }

    private void parseAgeLine(String line) {
        try {
            this.aPC.setAge(Integer.parseInt(line.substring("AGE".length() + 1)));
        }
        catch (NumberFormatException nfe) {
            String message = "Illegal Age line ignored: " + line;
            this.warnings.add(message);
        }
    }

    private void parseAgeSet(String line) {
        StringTokenizer aTok = new StringTokenizer(line, ":", false);
        int i = 0;
        aTok.nextToken();
        while (aTok.hasMoreTokens() && i < 10) {
            this.aPC.setHasMadeKitSelectionForAgeSet(i++, aTok.nextToken().equals("1"));
        }
    }

    private void parseAlignmentLine(String line) {
        String alignment = line.substring("ALIGN".length() + 1);
        int i = SettingsHandler.getGame().getIndexOfAlignment(alignment);
        if (i >= 0) {
            this.aPC.setAlignment(i, true);
            return;
        }
        String message = "Invalid alignment specification.";
        this.warnings.add("Invalid alignment specification.");
    }

    private void parseArmorProfLine(String line) {
        StringTokenizer stok = new StringTokenizer(line.substring("ARMORPROF".length() + 1), ":", false);
        String objecttype = stok.nextToken();
        String objectname = objecttype.substring(objecttype.indexOf(61) + 1);
        ArrayList<String> aList = new ArrayList<String>();
        while (stok.hasMoreTokens()) {
            aList.add(stok.nextToken());
        }
        if (objecttype.startsWith("DEITY")) {
            if (this.aPC.getDeity() != null) {
                this.aPC.getDeity().addSelectedArmorProfs(aList);
            }
        } else if (objecttype.startsWith("CLASS")) {
            PCClass aClass = this.aPC.getClassNamed(objectname);
            if (aClass != null) {
                aClass.addSelectedArmorProfs(aList);
            } else {
                Logging.errorPrint("Error in line:" + line + "\n Could not find class " + objectname);
            }
        } else if (objecttype.startsWith("FEAT")) {
            Feat aFeat = this.aPC.getFeatNamed(objectname);
            if (aFeat != null) {
                aFeat.addSelectedArmorProfs(aList);
            } else {
                Logging.errorPrint("Error in line:" + line + "\n Could not find feat " + objectname);
            }
        } else if (objecttype.startsWith("SKILL")) {
            Skill aSkill = this.aPC.getSkillNamed(objectname);
            if (aSkill != null) {
                aSkill.addSelectedArmorProfs(aList);
            } else {
                Logging.errorPrint("Error in line:" + line + "\n Could not find skill " + objectname);
            }
        } else if (objecttype.startsWith("DOMAIN")) {
            Domain aDomain = this.aPC.getCharacterDomainNamed(objectname);
            if (aDomain != null) {
                aDomain.addSelectedArmorProfs(aList);
            } else {
                Logging.errorPrint("Error in line:" + line + "\n Could not find domain " + objectname);
            }
        } else if (objecttype.startsWith("EQUIPMENT")) {
            Equipment eq = this.aPC.getEquipmentNamed(objectname);
            if (eq != null) {
                eq.addSelectedArmorProfs(aList);
            } else {
                Logging.errorPrint("Error in line:" + line + "\n Could not find equipment named " + objectname);
            }
        } else if (objecttype.startsWith("TEMPLATE")) {
            PCTemplate aTemplate = this.aPC.getTemplateNamed(objectname);
            if (aTemplate != null) {
                aTemplate.addSelectedArmorProfs(aList);
            } else {
                Logging.errorPrint("Error in line:" + line + "\n Could not find template " + objectname);
            }
        } else {
            Logging.errorPrint("Error loading line :" + line);
            return;
        }
    }

    private void parseAutoSortGearLine(String line) {
        this.aPC.setAutoSortGear(line.endsWith("Y"));
    }

    private void parseAutoSortSkillsLine(String line) {
        if (line.endsWith("Y")) {
            this.aPC.setSkillsOutputOrder(0);
        } else {
            this.aPC.setSkillsOutputOrder(4);
        }
    }

    private void parseAutoSpellsLine(String line) {
        this.aPC.setAutoSpells(line.endsWith("Y"));
    }

    private void parseBirthplaceLine(String line) {
        this.aPC.setBirthplace(EntityEncoder.decode(line.substring("BIRTHPLACE".length() + 1)));
    }

    private void parseCachedLines() throws PCGParseException {
        Iterator it;
        if (this.cache.containsKey("GAMEMODE")) {
            this.parseGameMode((String)this.cache.get("GAMEMODE").get(0));
        }
        if (this.cache.containsKey("CAMPAIGN")) {
            this.parseCampaignLines(this.cache.get("CAMPAIGN"));
        }
        if (this.cache.containsKey("VERSION")) {
            this.parseVersionLine((String)this.cache.get("VERSION").get(0));
        }
        if (this.cache.containsKey("STAT")) {
            it = this.cache.get("STAT").iterator();
            while (it.hasNext()) {
                this.parseStatLine((String)it.next());
            }
            this.checkStats();
        }
        if (this.cache.containsKey("ALIGN")) {
            this.parseAlignmentLine((String)this.cache.get("ALIGN").get(0));
        }
        if (this.cache.containsKey("RACE")) {
            this.parseRaceLine((String)this.cache.get("RACE").get(0));
        }
        if (this.cache.containsKey("POOLPOINTS")) {
            this.parsePoolPointsLine((String)this.cache.get("POOLPOINTS").get(0));
        }
        if (this.cache.containsKey("AUTOSPELLS")) {
            this.parseAutoSpellsLine((String)this.cache.get("AUTOSPELLS").get(0));
        }
        if (this.cache.containsKey("LOADCOMPANIONS")) {
            this.parseLoadCompanionLine((String)this.cache.get("LOADCOMPANIONS").get(0));
        }
        if (this.cache.containsKey("USETEMPMODS")) {
            this.parseUseTempModsLine((String)this.cache.get("USETEMPMODS").get(0));
        }
        if (this.cache.containsKey("OUTPUTSHEETHTML")) {
            this.parseHTMLOutputSheetLine((String)this.cache.get("OUTPUTSHEETHTML").get(0));
        }
        if (this.cache.containsKey("OUTPUTSHEETPDF")) {
            this.parsePDFOutputSheetLine((String)this.cache.get("OUTPUTSHEETPDF").get(0));
        }
        if (this.cache.containsKey("AUTOSORTGEAR")) {
            this.parseAutoSortGearLine((String)this.cache.get("AUTOSORTGEAR").get(0));
        }
        if (this.cache.containsKey("AUTOSORTSKILLS")) {
            this.parseAutoSortSkillsLine((String)this.cache.get("AUTOSORTSKILLS").get(0));
        }
        if (this.cache.containsKey("SKILLSOUTPUTORDER")) {
            this.parseSkillsOutputOrderLine((String)this.cache.get("SKILLSOUTPUTORDER").get(0));
        }
        if (this.cache.containsKey("CLASS")) {
            it = this.cache.get("CLASS").iterator();
            while (it.hasNext()) {
                this.parseClassLine((String)it.next());
            }
            this.checkSkillPools();
        }
        if (this.cache.containsKey("CLASSABILITIESLEVEL")) {
            it = this.cache.get("CLASSABILITIESLEVEL").iterator();
            while (it.hasNext()) {
                this.parseClassAbilitiesLevelLine((String)it.next());
            }
        }
        if (this.cache.containsKey("EXPERIENCE")) {
            this.parseExperienceLine((String)this.cache.get("EXPERIENCE").get(0));
        }
        if (this.cache.containsKey("TEMPLATESAPPLIED")) {
            it = this.cache.get("TEMPLATESAPPLIED").iterator();
            while (it.hasNext()) {
                this.parseTemplateLine((String)it.next());
            }
        }
        if (this.cache.containsKey("REGION")) {
            it = this.cache.get("REGION").iterator();
            while (it.hasNext()) {
                this.parseRegionLine((String)it.next());
            }
        }
        if (this.cache.containsKey("SKILL")) {
            it = this.cache.get("SKILL").iterator();
            while (it.hasNext()) {
                this.parseSkillLine((String)it.next());
            }
        }
        if (this.cache.containsKey("LANGUAGE")) {
            it = this.cache.get("LANGUAGE").iterator();
            while (it.hasNext()) {
                this.parseLanguageLine((String)it.next());
            }
        }
        if (this.cache.containsKey("FEAT")) {
            it = this.cache.get("FEAT").iterator();
            while (it.hasNext()) {
                this.parseFeatLine((String)it.next());
            }
        }
        if (this.cache.containsKey("VFEAT")) {
            it = this.cache.get("VFEAT").iterator();
            while (it.hasNext()) {
                this.parseVFeatLine((String)it.next());
            }
        }
        if (this.cache.containsKey("FEATPOOL")) {
            it = this.cache.get("FEATPOOL").iterator();
            while (it.hasNext()) {
                this.parseFeatPoolLine((String)it.next());
            }
        }
        if (this.cache.containsKey("MONEY")) {
            it = this.cache.get("MONEY").iterator();
            while (it.hasNext()) {
                this.parseMoneyLine((String)it.next());
            }
        }
        if (this.cache.containsKey("EQUIPNAME")) {
            it = this.cache.get("EQUIPNAME").iterator();
            while (it.hasNext()) {
                this.parseEquipmentLine((String)it.next());
            }
        }
        if (this.cache.containsKey("EQUIPSET")) {
            it = this.cache.get("EQUIPSET").iterator();
            while (it.hasNext()) {
                this.parseEquipmentSetLine((String)it.next());
            }
        }
        if (this.cache.containsKey("CALCEQUIPSET")) {
            it = this.cache.get("CALCEQUIPSET").iterator();
            while (it.hasNext()) {
                this.parseCalcEquipSet((String)it.next());
            }
        }
        if (this.cache.containsKey("DEITY")) {
            it = this.cache.get("DEITY").iterator();
            while (it.hasNext()) {
                this.parseDeityLine((String)it.next());
            }
        }
        if (this.cache.containsKey("DOMAIN")) {
            it = this.cache.get("DOMAIN").iterator();
            while (it.hasNext()) {
                this.parseDomainLine((String)it.next());
            }
        }
        if (this.cache.containsKey("DOMAINSPELLS")) {
            it = this.cache.get("DOMAINSPELLS").iterator();
            while (it.hasNext()) {
                this.parseDomainSpellsLine((String)it.next());
            }
        }
        if (this.cache.containsKey("SPELLLIST")) {
            it = this.cache.get("SPELLLIST").iterator();
            while (it.hasNext()) {
                this.parseSpellListLines((String)it.next());
            }
        }
        if (this.cache.containsKey("SPELLNAME")) {
            it = this.cache.get("SPELLNAME").iterator();
            while (it.hasNext()) {
                this.parseSpellLine((String)it.next());
            }
            this.sortCharacterSpells();
        }
        if (this.cache.containsKey("CHARACTERBIO")) {
            this.parseCharacterBioLine((String)this.cache.get("CHARACTERBIO").get(0));
        }
        if (this.cache.containsKey("CHARACTERDESC")) {
            this.parseCharacterDescLine((String)this.cache.get("CHARACTERDESC").get(0));
        }
        if (this.cache.containsKey("CHARACTERCOMP")) {
            it = this.cache.get("CHARACTERCOMP").iterator();
            while (it.hasNext()) {
                this.parseCharacterCompLine((String)it.next());
            }
        }
        if (this.cache.containsKey("CHARACTERASSET")) {
            it = this.cache.get("CHARACTERASSET").iterator();
            while (it.hasNext()) {
                this.parseCharacterAssetLine((String)it.next());
            }
        }
        if (this.cache.containsKey("CHARACTERMAGIC")) {
            it = this.cache.get("CHARACTERMAGIC").iterator();
            while (it.hasNext()) {
                this.parseCharacterMagicLine((String)it.next());
            }
        }
        if (this.cache.containsKey("MASTER")) {
            it = this.cache.get("MASTER").iterator();
            while (it.hasNext()) {
                this.parseMasterLine((String)it.next());
            }
        }
        if (this.cache.containsKey("FOLLOWER")) {
            it = this.cache.get("FOLLOWER").iterator();
            while (it.hasNext()) {
                this.parseFollowerLine((String)it.next());
            }
        }
        if (this.cache.containsKey("NOTE")) {
            it = this.cache.get("NOTE").iterator();
            while (it.hasNext()) {
                this.parseNoteLine((String)it.next());
            }
        }
        if (this.cache.containsKey("CHARACTERNAME")) {
            this.parseCharacterNameLine((String)this.cache.get("CHARACTERNAME").get(0));
        }
        if (this.cache.containsKey("TABNAME")) {
            this.parseTabNameLine((String)this.cache.get("TABNAME").get(0));
        }
        if (this.cache.containsKey("PLAYERNAME")) {
            this.parsePlayerNameLine((String)this.cache.get("PLAYERNAME").get(0));
        }
        if (this.cache.containsKey("HEIGHT")) {
            this.parseHeightLine((String)this.cache.get("HEIGHT").get(0));
        }
        if (this.cache.containsKey("WEIGHT")) {
            this.parseWeightLine((String)this.cache.get("WEIGHT").get(0));
        }
        if (this.cache.containsKey("AGE")) {
            this.parseAgeLine((String)this.cache.get("AGE").get(0));
        }
        if (this.cache.containsKey("GENDER")) {
            this.parseGenderLine((String)this.cache.get("GENDER").get(0));
        }
        if (this.cache.containsKey("HANDED")) {
            this.parseHandedLine((String)this.cache.get("HANDED").get(0));
        }
        if (this.cache.containsKey("SKINCOLOR")) {
            this.parseSkinColorLine((String)this.cache.get("SKINCOLOR").get(0));
        }
        if (this.cache.containsKey("EYECOLOR")) {
            this.parseEyeColorLine((String)this.cache.get("EYECOLOR").get(0));
        }
        if (this.cache.containsKey("HAIRCOLOR")) {
            this.parseHairColorLine((String)this.cache.get("HAIRCOLOR").get(0));
        }
        if (this.cache.containsKey("HAIRSTYLE")) {
            this.parseHairStyleLine((String)this.cache.get("HAIRSTYLE").get(0));
        }
        if (this.cache.containsKey("LOCATION")) {
            this.parseLocationLine((String)this.cache.get("LOCATION").get(0));
        }
        if (this.cache.containsKey("RESIDENCE")) {
            this.parseResidenceLine((String)this.cache.get("RESIDENCE").get(0));
        }
        if (this.cache.containsKey("CITY")) {
            this.parseCityLine((String)this.cache.get("CITY").get(0));
        }
        if (this.cache.containsKey("BIRTHPLACE")) {
            this.parseBirthplaceLine((String)this.cache.get("BIRTHPLACE").get(0));
        }
        if (this.cache.containsKey("PERSONALITYTRAIT1")) {
            it = this.cache.get("PERSONALITYTRAIT1").iterator();
            while (it.hasNext()) {
                this.parsePersonalityTrait1Line((String)it.next());
            }
        }
        if (this.cache.containsKey("PERSONALITYTRAIT2")) {
            it = this.cache.get("PERSONALITYTRAIT2").iterator();
            while (it.hasNext()) {
                this.parsePersonalityTrait2Line((String)it.next());
            }
        }
        if (this.cache.containsKey("SPEECHPATTERN")) {
            this.parseSpeechPatternLine((String)this.cache.get("SPEECHPATTERN").get(0));
        }
        if (this.cache.containsKey("PHOBIAS")) {
            this.parsePhobiasLine((String)this.cache.get("PHOBIAS").get(0));
        }
        if (this.cache.containsKey("INTERESTS")) {
            this.parseInterestsLine((String)this.cache.get("INTERESTS").get(0));
        }
        if (this.cache.containsKey("CATCHPHRASE")) {
            this.parseCatchPhraseLine((String)this.cache.get("CATCHPHRASE").get(0));
        }
        if (this.cache.containsKey("PORTRAIT")) {
            this.parsePortraitLine((String)this.cache.get("PORTRAIT").get(0));
        }
        if (this.cache.containsKey("WEAPONPROF")) {
            it = this.cache.get("WEAPONPROF").iterator();
            while (it.hasNext()) {
                this.parseWeaponProficienciesLine((String)it.next());
            }
            this.checkWeaponProficiencies();
        }
        if (this.cache.containsKey("KIT")) {
            it = this.cache.get("KIT").iterator();
            while (it.hasNext()) {
                this.parseKitLine((String)it.next());
            }
        }
        if (this.cache.containsKey("ARMORPROF")) {
            it = this.cache.get("ARMORPROF").iterator();
            while (it.hasNext()) {
                this.parseArmorProfLine((String)it.next());
            }
        }
        if (this.cache.containsKey("TEMPBONUS")) {
            it = this.cache.get("TEMPBONUS").iterator();
            while (it.hasNext()) {
                this.parseTempBonusLine((String)it.next());
            }
        }
        if (this.cache.containsKey("EQSETBONUS")) {
            it = this.cache.get("EQSETBONUS").iterator();
            while (it.hasNext()) {
                this.parseEquipSetTempBonusLine((String)it.next());
            }
        }
        if (this.cache.containsKey("AGESET")) {
            it = this.cache.get("AGESET").iterator();
            while (it.hasNext()) {
                this.parseAgeSet((String)it.next());
            }
        }
    }

    private void parseCampaignLines(List lines) throws PCGParseException {
        ArrayList<Campaign> campaigns = new ArrayList<Campaign>();
        if (SettingsHandler.isLoadCampaignsWithPC()) {
            Iterator it = lines.iterator();
            while (it.hasNext()) {
                PCGTokenizer tokens;
                String line = (String)it.next();
                try {
                    tokens = new PCGTokenizer(line);
                }
                catch (PCGParseException pcgpex) {
                    throw new PCGParseException("parseCampaignLines", line, pcgpex.getMessage());
                }
                Iterator it2 = tokens.getElements().iterator();
                while (it2.hasNext()) {
                    Campaign aCampaign = Globals.getCampaignNamed(((PCGElement)it2.next()).getText());
                    if (aCampaign == null || aCampaign.isLoaded()) continue;
                    campaigns.add(aCampaign);
                }
            }
            if (campaigns.size() > 0) {
                try {
                    PersistenceManager pManager = PersistenceManager.getInstance();
                    pManager.loadCampaigns(campaigns);
                }
                catch (PersistenceLayerException e) {
                    throw new PCGParseException("parseCampaignLines", "N/A", e.getMessage());
                }
                if (Globals.getUseGUI()) {
                    PCGen_Frame1.getInst().getMainSource().updateLoadedCampaignsUI();
                }
            }
        }
        if (!Globals.displayListsHappy()) {
            throw new PCGParseException("parseCampaignLines", "N/A", "Insufficient campaign information to load character file.");
        }
    }

    private void parseCatchPhraseLine(String line) {
        this.aPC.setCatchPhrase(EntityEncoder.decode(line.substring("CATCHPHRASE".length() + 1)));
    }

    private void parseCharacterAssetLine(String line) {
        this.aPC.getMiscList().set(0, EntityEncoder.decode(line.substring("CHARACTERASSET".length() + 1)));
    }

    private void parseCharacterCompLine(String line) {
        this.aPC.getMiscList().set(1, EntityEncoder.decode(line.substring("CHARACTERCOMP".length() + 1)));
    }

    private void parseCharacterDescLine(String line) {
        this.aPC.setDescription(EntityEncoder.decode(line.substring("CHARACTERDESC".length() + 1)));
    }

    private void parseCharacterMagicLine(String line) {
        this.aPC.getMiscList().set(2, EntityEncoder.decode(line.substring("CHARACTERMAGIC".length() + 1)));
    }

    private void parseCharacterNameLine(String line) {
        this.aPC.setName(EntityEncoder.decode(line.substring("CHARACTERNAME".length() + 1)));
    }

    private void parseCityLine(String line) {
        this.aPC.setResidence(EntityEncoder.decode(line.substring("CITY".length() + 1)));
    }

    private void parseClassAbilitiesLevelLine(String line) {
        PCGElement element;
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Class abilities line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        int level = -1;
        PCClass aPCClass = null;
        PCLevelInfo pcl = null;
        Iterator it = tokens.getElements().iterator();
        if (it.hasNext()) {
            element = (PCGElement)it.next();
            int index = element.getText().indexOf(61);
            if (index < 0) {
                String message = "Invalid class/level specification: " + element.getText();
                this.warnings.add(message);
                return;
            }
            String classKeyName = EntityEncoder.decode(element.getText().substring(0, index));
            aPCClass = this.aPC.getClassKeyed(classKeyName);
            if (aPCClass == null) {
                String message = "Could not find class: " + classKeyName;
                this.warnings.add(message);
                return;
            }
            try {
                level = Integer.parseInt(element.getText().substring(index + 1));
            }
            catch (NumberFormatException nfe) {
                String message = "Invalid level specification: " + element.getText();
                this.warnings.add(message);
                return;
            }
            if (level < 1) {
                String message = "Invalid level specification: " + element.getText();
                this.warnings.add(message);
                return;
            }
            pcl = this.aPC.saveLevelInfo(classKeyName);
            pcl.setLevel(level);
        }
        while (it.hasNext()) {
            element = (PCGElement)it.next();
            String tag = element.getName();
            if ("HITPOINTS".equals(tag)) {
                try {
                    aPCClass.setHitPoint(level - 1, new Integer(element.getText()));
                }
                catch (NumberFormatException nfe) {
                    String message = "Invalid hitpoint specification: " + tag + ":" + element.getText();
                    this.warnings.add(message);
                }
                continue;
            }
            if ("SAVES".equals(tag)) {
                Iterator it2 = element.getChildren().iterator();
                while (it2.hasNext()) {
                    String dString = EntityEncoder.decode(((PCGElement)it2.next()).getText());
                    if (dString.startsWith("BONUS|")) {
                        aPCClass.addBonusList(dString.substring(6), aPCClass);
                    }
                    aPCClass.addSave(dString);
                }
                continue;
            }
            if ("SPECIALTIES".equals(tag)) {
                Iterator it2 = element.getChildren().iterator();
                while (it2.hasNext()) {
                    aPCClass.getSpecialtyList().add(EntityEncoder.decode(((PCGElement)it2.next()).getText()));
                }
                continue;
            }
            if ("SPECIALABILITIES".equals(tag)) {
                Iterator it2 = element.getChildren().iterator();
                while (it2.hasNext()) {
                    String saSource = "";
                    String specialAbilityName = EntityEncoder.decode(((PCGElement)it2.next()).getText());
                    if (this.pcgenVersion[0] <= 5 && this.pcgenVersion[1] <= 5 && this.pcgenVersion[2] < 6) {
                        if (specialAbilityName.equals("Turn Undead")) {
                            this.parseFeatLine("FEAT:Turn Undead|TYPE:SPECIAL.TURNUNDEAD|DESC:");
                            continue;
                        }
                        if (specialAbilityName.equals("Rebuke Undead")) {
                            this.parseFeatLine("FEAT:Rebuke Undead|TYPE:SPECIAL.TURNUNDEAD|DESC:");
                            continue;
                        }
                    }
                    SpecialAbility specialAbility = new SpecialAbility(specialAbilityName);
                    if (specialAbilityName.endsWith(":-1")) {
                        specialAbilityName = specialAbilityName.substring(0, specialAbilityName.length() - 3);
                        specialAbility = new SpecialAbility(specialAbilityName);
                        specialAbility.setSASource("PCClass|" + aPCClass.getName() + '|' + 0);
                    } else {
                        specialAbility = new SpecialAbility(specialAbilityName);
                        specialAbility.setSASource("PCCLASS|" + aPCClass.getName() + '|' + level);
                    }
                    if (!this.aPC.hasSpecialAbility(specialAbilityName)) {
                        aPCClass.addSpecialAbilityToList(specialAbility);
                    }
                    if (aPCClass.containsSave(specialAbilityName)) continue;
                    aPCClass.addSave(specialAbilityName);
                }
                continue;
            }
            if (tag.equals("ABILITY")) {
                Iterator it2 = element.getChildren().iterator();
                if (!it2.hasNext()) continue;
                String dString = EntityEncoder.decode(((PCGElement)it2.next()).getText());
                LevelAbility la = aPCClass.addAddList(level, dString);
                ArrayList<String> choiceList = new ArrayList<String>();
                if (la == null) continue;
                la.process(choiceList, this.aPC);
                choiceList.clear();
                while (it2.hasNext()) {
                    dString = EntityEncoder.decode(((PCGElement)it2.next()).getText());
                    choiceList.add(dString);
                }
                la.processChoice(null, choiceList, "", this.aPC);
                continue;
            }
            if (tag.equals("PRESTAT") || tag.equals("POSTSTAT")) {
                int idx;
                boolean isPre = false;
                if (tag.equals("PRESTAT")) {
                    isPre = true;
                }
                if ((idx = element.getText().indexOf(61)) > 0) {
                    int idxStat = SettingsHandler.getGame().getStatFromAbbrev(element.getText().substring(0, idx));
                    if (idxStat >= 0) {
                        try {
                            this.aPC.saveStatIncrease(element.getText().substring(0, idx), Integer.parseInt(element.getText().substring(idx + 1)), isPre);
                        }
                        catch (NumberFormatException nfe) {
                            this.warnings.add("Invalid stat modification: " + tag + ":" + element.getText());
                        }
                        continue;
                    }
                    this.warnings.add("Unknown stat: " + tag + ":" + element.getText());
                    continue;
                }
                this.warnings.add("Missing = in tag:" + tag + ":" + element.getText());
                continue;
            }
            if (pcl != null && "SKILLSGAINED".equals(tag)) {
                pcl.setSkillPointsGained(Integer.parseInt(element.getText()));
                continue;
            }
            if (pcl != null && "SKILLSREMAINING".equals(tag)) {
                pcl.setSkillPointsRemaining(Integer.parseInt(element.getText()), false, this.aPC);
                continue;
            }
            if ("DATA".equals(tag)) continue;
            String message = "Unknown tag: " + tag + ":" + element.getText();
            this.warnings.add(message);
        }
    }

    private void parseClassLine(String line) throws PCGParseException {
        PCGElement element;
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            throw new PCGParseException("parseClassLine", line, pcgpex.getMessage());
        }
        PCClass aPCClass = null;
        Iterator it = tokens.getElements().iterator();
        if (it.hasNext()) {
            element = (PCGElement)it.next();
            aPCClass = Globals.getClassKeyed(EntityEncoder.decode(element.getText()));
            if (aPCClass != null) {
                aPCClass = (PCClass)aPCClass.clone();
            } else {
                String message = "Could not add class: " + element.getText();
                this.warnings.add(message);
                return;
            }
        }
        int level = -1;
        int skillPool = -1;
        while (it.hasNext()) {
            String message;
            element = (PCGElement)it.next();
            String tag = element.getName();
            if ("SUBCLASS".equals(tag)) {
                aPCClass.setSubClassName(EntityEncoder.decode(element.getText()));
            }
            if ("LEVEL".equals(tag)) {
                try {
                    level = Integer.parseInt(element.getText());
                }
                catch (NumberFormatException nfe) {
                    message = "Invalid level specification: " + element.getText();
                    this.warnings.add(message);
                }
                continue;
            }
            if ("SKILLPOOL".equals(tag)) {
                try {
                    skillPool = Integer.parseInt(element.getText());
                }
                catch (NumberFormatException nfe) {
                    message = "Invalid skill pool specification: " + element.getText();
                    this.warnings.add(message);
                }
                continue;
            }
            if ("CANCASTPERDAY".equals(tag)) continue;
            if ("SPELLBASE".equals(tag)) {
                String spellBase = EntityEncoder.decode(element.getText());
                if (SettingsHandler.getGame().getStatFromAbbrev(spellBase.toUpperCase()) <= -1 && !"None".equalsIgnoreCase(spellBase) && !"Any".equalsIgnoreCase(spellBase) && !"SPELL".equalsIgnoreCase(spellBase)) continue;
                aPCClass.setSpellBaseStat(spellBase);
                continue;
            }
            if (!"PROHIBITED".equals(tag)) continue;
            aPCClass.setProhibitedString(EntityEncoder.decode(element.getText()));
        }
        if (level > -1) {
            this.aPC.getClassList().add(aPCClass);
            for (int i = 0; i < level; ++i) {
                aPCClass.addLevel(false, this.aPC);
            }
        }
        if (skillPool > -1) {
            aPCClass.setSkillPool(skillPool);
        }
    }

    private void parseDeityLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Deity line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        String deityName = EntityEncoder.decode(((PCGElement)tokens.getElements().get(0)).getText());
        Deity aDeity = Globals.getDeityNamed(deityName);
        if (aDeity != null) {
            this.aPC.setDeity(aDeity);
        } else if (!"None".equals(deityName)) {
            String message = "Deity not found: " + deityName + "." + Constants.s_LINE_SEP + "Check loaded campaigns.";
            this.warnings.add(message);
        }
    }

    private void parseDomainLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Domain line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        Iterator it = tokens.getElements().iterator();
        if (it.hasNext()) {
            PCGElement element = (PCGElement)it.next();
            String domainName = EntityEncoder.decode(element.getText());
            Domain aDomain = Globals.getDomainKeyed(domainName);
            if (aDomain == null && !"None".equals(domainName)) {
                String message = "Global domain not found: " + domainName + "." + Constants.s_LINE_SEP + "Check loaded campaigns.";
                this.warnings.add(message);
            } else if (this.aPC.getCharacterDomainNamed(domainName) == null && !"None".equals(domainName)) {
                CharacterDomain aCharacterDomain = new CharacterDomain();
                aCharacterDomain.setDomain(aDomain, this.aPC);
                while (it.hasNext()) {
                    element = (PCGElement)it.next();
                    String tag = element.getName();
                    if ("SOURCE".equals(tag)) {
                        CharacterDomainParser parser = new CharacterDomainParser();
                        parser.setDomainSource(aCharacterDomain, PCGVer2Parser.sourceElementToString(element));
                        continue;
                    }
                    if (!"ASSOCIATEDDATA".equals(tag)) continue;
                    aCharacterDomain.getDomain().addAssociated(EntityEncoder.decode(element.getText()));
                }
                this.aPC.addCharacterDomain(aCharacterDomain);
                aDomain.setIsLocked(true, this.aPC);
            } else {
                Logging.errorPrint("Duplicate domain found: " + domainName);
            }
        }
    }

    private void parseDomainSpellsLine(String line) {
    }

    private void parseEquipSetTempBonusLine(String line) {
        String tag;
        PCGElement element;
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal EquipSetTempBonus line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        String tagString = null;
        Iterator it = tokens.getElements().iterator();
        while (it.hasNext()) {
            element = (PCGElement)it.next();
            tag = element.getName();
            if (!"EQSETBONUS".equals(tag)) continue;
            tagString = EntityEncoder.decode(element.getText());
        }
        if (tagString == null) {
            this.warnings.add("Illegal EquipSet TempBonus line ignored: " + line);
            return;
        }
        EquipSet eSet = this.aPC.getEquipSetByIdPath(tagString);
        if (eSet == null) {
            return;
        }
        LinkedList aList = new LinkedList();
        Iterator it2 = tokens.getElements().iterator();
        while (it2.hasNext()) {
            String aString;
            StringTokenizer aTok;
            element = (PCGElement)it2.next();
            tag = element.getName();
            if (!"TBBONUS".equals(tag) || (aTok = new StringTokenizer(aString = EntityEncoder.decode(element.getText()), "|")).countTokens() < 2) continue;
            String sName = aTok.nextToken();
            String tName = aTok.nextToken();
            aList.addAll(this.getBonusFromName(sName, tName));
        }
        eSet.setTempBonusList(aList);
    }

    private void parseExperienceLine(String line) throws PCGParseException {
        StringTokenizer stok = new StringTokenizer(line.substring("EXPERIENCE".length() + 1), ":", false);
        try {
            this.aPC.setXP(Integer.parseInt(stok.nextToken()));
        }
        catch (NumberFormatException nfe) {
            throw new PCGParseException("parseExperienceLine", line, nfe.getMessage());
        }
    }

    private void parseEyeColorLine(String line) {
        this.aPC.setEyeColor(EntityEncoder.decode(line.substring("EYECOLOR".length() + 1)));
    }

    private void parseFeatLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Feat line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        boolean added = false;
        Feat aFeat = null;
        Iterator it = tokens.getElements().iterator();
        if (it.hasNext()) {
            PCGElement element = (PCGElement)it.next();
            String featKey = EntityEncoder.decode(element.getText());
            aFeat = this.aPC.getFeatNonAggregateKeyed(featKey);
            if (aFeat != null) {
                added = this.parseFeatsHandleAppliedToAndSaveTags(it, aFeat, line);
            } else {
                aFeat = Globals.getFeatKeyed(featKey);
                if (aFeat != null) {
                    added = this.parseFeatsHandleAppliedToAndSaveTags(it, aFeat = (Feat)aFeat.clone(), line);
                    if (!added) {
                        this.aPC.addFeat(aFeat);
                    }
                } else {
                    String message = "Could not add feat: " + featKey;
                    this.warnings.add(message);
                    return;
                }
            }
        }
    }

    private void parseFeatPoolLine(String line) {
        try {
            this.aPC.setFeats(Double.parseDouble(line.substring("FEATPOOL".length() + 1)));
        }
        catch (NumberFormatException nfe) {
            String message = "Illegal Feat Pool line ignored: " + line;
            this.warnings.add(message);
        }
    }

    private boolean parseFeatsHandleAppliedToAndSaveTags(Iterator it, Feat aFeat, String line) {
        boolean added = false;
        while (it.hasNext()) {
            PCGElement element = (PCGElement)it.next();
            String tag = element.getName();
            if ("APPLIEDTO".equals(tag)) {
                String appliedToKey = EntityEncoder.decode(element.getText());
                if (aFeat.getName().endsWith("Weapon Proficiency")) {
                    this.aPC.addWeaponProf(PCGVer2Parser.updateProficiencyName(appliedToKey, false));
                    added = true;
                }
                if (appliedToKey.startsWith("MULTISELECT")) {
                    StringTokenizer sTok = new StringTokenizer(appliedToKey, ":", false);
                    if (sTok.countTokens() > 2) {
                        sTok.nextToken();
                        int maxChoices = Integer.parseInt(sTok.nextToken());
                        sTok.nextToken();
                        FeatMultipleChoice fmc = new FeatMultipleChoice();
                        fmc.setMaxChoices(maxChoices);
                        while (sTok.hasMoreTokens()) {
                            fmc.addChoice(sTok.nextToken());
                        }
                        aFeat.addAssociated(fmc);
                        continue;
                    }
                    String message = "Illegal Feat line ignored: " + line;
                    this.warnings.add(message);
                    continue;
                }
                if ((!aFeat.isMultiples() || !aFeat.isStacks()) && aFeat.containsAssociated(appliedToKey)) continue;
                aFeat.addAssociated(appliedToKey);
                continue;
            }
            if (!"SAVE".equals(tag)) continue;
            String saveKey = EntityEncoder.decode(element.getText());
            if (saveKey.startsWith("BONUS") && saveKey.length() > 6) {
                aFeat.addBonusList(saveKey.substring(6), aFeat);
            }
            aFeat.addSave(saveKey);
        }
        return added;
    }

    private void parseFollowerLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Follower line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        Follower aFollower = new Follower("", "", "");
        Iterator it = tokens.getElements().iterator();
        while (it.hasNext()) {
            PCGElement element = (PCGElement)it.next();
            String tag = element.getName();
            if ("FOLLOWER".equals(tag)) {
                aFollower.setName(EntityEncoder.decode(element.getText()));
                continue;
            }
            if ("TYPE".equals(tag)) {
                aFollower.setType(EntityEncoder.decode(element.getText()));
                continue;
            }
            if ("RACE".equals(tag)) {
                aFollower.setRace(EntityEncoder.decode(element.getText()));
                continue;
            }
            if ("HITDICE".equals(tag)) {
                try {
                    aFollower.setUsedHD(Integer.parseInt(element.getText()));
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            if (!"FILE".equals(tag)) continue;
            aFollower.setRelativeFileName(EntityEncoder.decode(element.getText()));
        }
        if (!("".equals(aFollower.getFileName()) || "".equals(aFollower.getName()) || "".equals(aFollower.getType()))) {
            this.aPC.addFollower(aFollower);
        }
    }

    private void parseGameMode(String line) throws PCGParseException {
        GameMode currentGameMode;
        String currentMode;
        String requestedMode = line.substring("GAMEMODE".length() + 1);
        if (!requestedMode.equals(currentMode = (currentGameMode = SettingsHandler.getGame()).getName())) {
            throw new PCGParseException("ParseGameMode", line, "Unable to load the character as it uses game mode: '" + requestedMode + "'. PCGen is currently using gamemode '" + currentMode + "'. Use the 'Settings->Game Mode / Campaign' menu to change the current game mode");
        }
    }

    private void parseGenderLine(String line) {
        this.aPC.setGender(EntityEncoder.decode(line.substring("GENDER".length() + 1)));
    }

    private void parseHTMLOutputSheetLine(String line) {
        String aFileName = EntityEncoder.decode(line.substring("OUTPUTSHEETHTML".length() + 1));
        if (aFileName.length() <= 0) {
            aFileName = SettingsHandler.getSelectedCharacterHTMLOutputSheet(this.aPC);
        }
        this.aPC.setSelectedCharacterHTMLOutputSheet(aFileName);
    }

    private void parseHairColorLine(String line) {
        this.aPC.setHairColor(EntityEncoder.decode(line.substring("HAIRCOLOR".length() + 1)));
    }

    private void parseHairStyleLine(String line) {
        this.aPC.setHairStyle(EntityEncoder.decode(line.substring("HAIRSTYLE".length() + 1)));
    }

    private void parseHandedLine(String line) {
        this.aPC.setHanded(EntityEncoder.decode(line.substring("HANDED".length() + 1)));
    }

    private void parseHeightLine(String line) {
        try {
            this.aPC.setHeightInInches(Integer.parseInt(line.substring("HEIGHT".length() + 1)));
        }
        catch (NumberFormatException nfe) {
            String message = "Illegal Height line ignored: " + line;
            this.warnings.add(message);
        }
    }

    private void parseInterestsLine(String line) {
        this.aPC.setInterests(EntityEncoder.decode(line.substring("INTERESTS".length() + 1)));
    }

    private void parseKitLine(String line) {
        StringTokenizer stok = new StringTokenizer(line.substring("KIT".length() + 1), "|", false);
        if (stok.countTokens() != 2) {
            // empty if block
        }
        stok.nextToken();
        Kit aKit = Globals.getKitKeyed(line.substring("KIT".length() + 1));
        if (aKit == null) {
            this.warnings.add("Kit not found: " + line);
            return;
        }
        this.aPC.addKit(aKit);
    }

    private void parseLanguageLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Language line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        Iterator it = tokens.getElements().iterator();
        while (it.hasNext()) {
            PCGElement element = (PCGElement)it.next();
            this.aPC.addLanguage(EntityEncoder.decode(element.getText()));
        }
    }

    private void parseLoadCompanionLine(String line) {
        this.aPC.setLoadCompanion(line.endsWith("Y"));
    }

    private void parseLocationLine(String line) {
        this.aPC.setLocation(EntityEncoder.decode(line.substring("LOCATION".length() + 1)));
    }

    private void parseMasterLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Master line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        Follower aMaster = new Follower("", "", "");
        Iterator it = tokens.getElements().iterator();
        while (it.hasNext()) {
            PCGElement element = (PCGElement)it.next();
            String tag = element.getName();
            if ("MASTER".equals(tag)) {
                aMaster.setName(EntityEncoder.decode(element.getText()));
                continue;
            }
            if ("TYPE".equals(tag)) {
                aMaster.setType(EntityEncoder.decode(element.getText()));
                continue;
            }
            if ("HITDICE".equals(tag)) {
                try {
                    aMaster.setUsedHD(Integer.parseInt(element.getText()));
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            if (!"FILE".equals(tag)) continue;
            aMaster.setRelativeFileName(EntityEncoder.decode(element.getText()));
        }
        if (!("".equals(aMaster.getFileName()) || "".equals(aMaster.getName()) || "".equals(aMaster.getType()))) {
            this.aPC.setMaster(aMaster, this.aPC);
        }
    }

    private void parseNoteLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Notes line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        NoteItem ni = new NoteItem(-1, -1, "", "");
        Iterator it = tokens.getElements().iterator();
        while (it.hasNext()) {
            PCGElement element = (PCGElement)it.next();
            String tag = element.getName();
            if ("NOTE".equals(tag)) {
                ni.setName(EntityEncoder.decode(element.getText()));
                continue;
            }
            if ("ID".equals(tag)) {
                try {
                    ni.setIdValue(Integer.parseInt(element.getText()));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    ni.setIdValue(-1);
                    String message = "Illegal Notes line ignored: " + line;
                    this.warnings.add(message);
                    break;
                }
            }
            if ("PARENTID".equals(tag)) {
                try {
                    ni.setParentId(Integer.parseInt(element.getText()));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    ni.setIdValue(-1);
                    String message = "Illegal Notes line ignored: " + line;
                    this.warnings.add(message);
                    break;
                }
            }
            if (!"VALUE".equals(tag)) continue;
            ni.setValue(EntityEncoder.decode(element.getText()));
        }
        if (ni.getId() > -1) {
            this.aPC.addNotesItem(ni);
        }
    }

    private void parsePDFOutputSheetLine(String line) {
        String aFileName = EntityEncoder.decode(line.substring("OUTPUTSHEETPDF".length() + 1));
        if (aFileName.length() <= 0) {
            aFileName = SettingsHandler.getSelectedCharacterPDFOutputSheet(this.aPC);
        }
        this.aPC.setSelectedCharacterPDFOutputSheet(aFileName);
    }

    private void parsePersonalityTrait1Line(String line) {
        this.aPC.setTrait1(EntityEncoder.decode(line.substring("PERSONALITYTRAIT1".length() + 1)));
    }

    private void parsePersonalityTrait2Line(String line) {
        this.aPC.setTrait2(EntityEncoder.decode(line.substring("PERSONALITYTRAIT2".length() + 1)));
    }

    private void parsePhobiasLine(String line) {
        this.aPC.setPhobias(EntityEncoder.decode(line.substring("PHOBIAS".length() + 1)));
    }

    private void parsePlayerNameLine(String line) {
        this.aPC.setPlayersName(EntityEncoder.decode(line.substring("PLAYERNAME".length() + 1)));
    }

    private void parsePoolPointsLine(String line) {
        try {
            this.aPC.setPoolAmount(Integer.parseInt(line.substring("POOLPOINTS".length() + 1)));
        }
        catch (NumberFormatException nfe) {
            String message = "Illegal Pool Points line ignored: " + line;
            this.warnings.add(message);
        }
    }

    private void parsePortraitLine(String line) {
        this.aPC.setPortraitPath(EntityEncoder.decode(line.substring("PORTRAIT".length() + 1)));
    }

    private void parseRaceLine(String line) throws PCGParseException {
        StringTokenizer sTok = new StringTokenizer(line.substring("RACE".length() + 1), "|", false);
        String race_name = EntityEncoder.decode(sTok.nextToken());
        Race aRace = Globals.getRaceKeyed(race_name);
        HashMap<String, Integer> hitPointMap = new HashMap<String, Integer>();
        if (aRace != null) {
            this.aPC.setRace(aRace);
            int hitDice = aRace.hitDice(this.aPC);
            if (sTok.hasMoreTokens()) {
                String aString = sTok.nextToken();
                if (aString.startsWith("HITPOINTS")) {
                    StringTokenizer aTok = new StringTokenizer(aString.substring("HITPOINTS".length()), ":", false);
                    int i = 0;
                    if (hitDice > 0) {
                        while (aTok.hasMoreTokens()) {
                            if (i >= hitDice) {
                                this.warnings.add("Saved race (" + race_name + ") now has fewer HITDICE.");
                                break;
                            }
                            try {
                                hitPointMap.put(Integer.toString(i++), new Integer(aTok.nextToken()));
                            }
                            catch (NumberFormatException ex) {
                                throw new PCGParseException("parseRaceLine", aString, ex.getMessage());
                            }
                        }
                        if (i < hitDice) {
                            this.warnings.add("Saved race (" + race_name + ") now has more HITDICE.");
                        }
                        this.aPC.getRace().setHitPointMap(hitPointMap);
                    } else {
                        String warning = "Saved race (" + race_name + ") no longer has a HITDICE tag";
                        if (!SettingsHandler.isMonsterDefault()) {
                            warning = warning + " or," + Constants.s_LINE_SEP + "was saved with \"Use Default Monsters\" on";
                        }
                        this.warnings.add(warning + ".");
                    }
                } else {
                    this.warnings.add("Ignoring unknown race info: " + aString);
                }
            }
        } else {
            String message = "Race not found: " + race_name + "." + Constants.s_LINE_SEP + "Check loaded campaigns.";
            throw new PCGParseException("parseRaceLine", line, message);
        }
    }

    private void parseRegionLine(String line) {
        String r = EntityEncoder.decode(line.substring("REGION".length() + 1));
        this.aPC.setRegion(r);
    }

    private void parseResidenceLine(String line) {
        this.aPC.setResidence(EntityEncoder.decode(line.substring("RESIDENCE".length() + 1)));
        this.aPC.setDirty(true);
    }

    private void parseSkillLine(String line) {
        PCGElement element;
        String skillKey;
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Skill line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        Skill aSkill = null;
        Iterator it = tokens.getElements().iterator();
        if (it.hasNext() && (aSkill = this.aPC.getSkillKeyed(skillKey = EntityEncoder.decode((element = (PCGElement)it.next()).getText()))) == null) {
            aSkill = Globals.getSkillKeyed(skillKey);
            if (aSkill != null) {
                aSkill = (Skill)aSkill.clone();
                this.aPC.getSkillList().add(aSkill);
            } else {
                String message = "Could not add skill: " + skillKey;
                this.warnings.add(message);
                return;
            }
        }
        while (it.hasNext()) {
            element = (PCGElement)it.next();
            String tag = element.getName();
            if ("SYNERGY".equals(tag)) continue;
            if ("OUTPUTORDER".equals(tag)) {
                int outputindex = 0;
                try {
                    outputindex = Integer.parseInt(element.getText());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                aSkill.setOutputIndex(outputindex);
                continue;
            }
            if ("CLASSBOUGHT".equals(tag)) {
                String message;
                String childClassKey;
                String message2;
                PCGElement childClass = null;
                PCGElement childRanks = null;
                Iterator it2 = element.getChildren().iterator();
                while (it2.hasNext()) {
                    PCGElement child = (PCGElement)it2.next();
                    if ("CLASS".equals(child.getName())) {
                        childClass = child;
                        continue;
                    }
                    if (!"RANKS".equals(child.getName())) continue;
                    childRanks = child;
                }
                if (childClass == null) {
                    message2 = "Invalid class/ranks specification: " + line;
                    this.warnings.add(message2);
                    continue;
                }
                if (childRanks == null) {
                    message2 = "Invalid class/ranks specification: " + line;
                    this.warnings.add(message2);
                    continue;
                }
                PCClass aPCClass = null;
                if (!childClass.getText().equals("None") && (aPCClass = this.aPC.getClassKeyed(childClassKey = EntityEncoder.decode(childClass.getText()))) == null) {
                    message = "Could not find class: " + childClassKey;
                    this.warnings.add(message);
                    continue;
                }
                try {
                    double ranks = Double.parseDouble(childRanks.getText());
                    aSkill.modRanks(ranks, aPCClass, true, this.aPC);
                }
                catch (NumberFormatException nfe) {
                    message = "Invalid ranks specification: " + childRanks.getText();
                    this.warnings.add(message);
                }
                continue;
            }
            if (!"ASSOCIATEDDATA".equals(tag)) continue;
            aSkill.addAssociated(EntityEncoder.decode(element.getText()));
        }
    }

    private void parseSkillsOutputOrderLine(String line) {
        try {
            this.aPC.setSkillsOutputOrder(Integer.parseInt(line.substring("SKILLSOUTPUTORDER".length() + 1)));
        }
        catch (NumberFormatException nfe) {
            String message = "Illegal Skills Output Order line ignored: " + line;
            this.warnings.add(message);
        }
    }

    private void parseSkinColorLine(String line) {
        this.aPC.setSkinColor(EntityEncoder.decode(line.substring("SKINCOLOR".length() + 1)));
    }

    private void parseSpeechPatternLine(String line) {
        this.aPC.setSpeechTendency(EntityEncoder.decode(line.substring("SPEECHPATTERN".length() + 1)));
    }

    private void parseSpellLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Spell line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        Spell aSpell = null;
        PObject aPCClass = null;
        PObject source = null;
        String spellBook = null;
        int times = 0;
        int spellLevel = 0;
        ArrayList<Feat> metaFeats = new ArrayList<Feat>();
        Object obj = null;
        Iterator it = tokens.getElements().iterator();
        while (it.hasNext()) {
            String message;
            PCGElement element = (PCGElement)it.next();
            String tag = element.getName();
            if ("SPELLNAME".equals(tag)) {
                String spellName = EntityEncoder.decode(element.getText());
                obj = Globals.getSpellMap().get(spellName);
                if (obj instanceof Spell) {
                    aSpell = obj;
                }
                if (obj != null) continue;
                message = "Could not find spell named: " + spellName;
                this.warnings.add(message);
                return;
            }
            if ("TIMES".equals(tag)) {
                try {
                    times = Integer.parseInt(element.getText());
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            if ("CLASS".equals(tag)) {
                String className = EntityEncoder.decode(element.getText());
                aPCClass = this.aPC.getClassNamed(className);
                if (aPCClass != null) continue;
                message = "Invalid class specification: " + className;
                this.warnings.add(message);
                return;
            }
            if ("BOOK".equals(tag)) {
                spellBook = EntityEncoder.decode(element.getText());
                continue;
            }
            if ("SPELLLEVEL".equals(tag)) {
                try {
                    spellLevel = Integer.parseInt(element.getText());
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            if ("SOURCE".equals(tag)) {
                String typeName = "";
                String objectName = "";
                Iterator it2 = element.getChildren().iterator();
                while (it2.hasNext()) {
                    element = (PCGElement)it2.next();
                    tag = element.getName();
                    if ("TYPE".equals(tag)) {
                        typeName = element.getText().toUpperCase();
                        continue;
                    }
                    if (!"NAME".equals(tag)) continue;
                    objectName = element.getText();
                }
                if ("DOMAIN".equals(typeName)) {
                    source = this.aPC.getCharacterDomainNamed(objectName);
                    if (source != null) continue;
                    String message2 = "Could not find domain: " + objectName;
                    this.warnings.add(message2);
                    return;
                }
                if (aPCClass != null && objectName.equals(aPCClass.getName()) || ((PCClass)aPCClass).getSpellKey().indexOf(typeName + '|' + objectName) >= 0) {
                    source = aPCClass;
                    continue;
                }
                source = this.aPC.getClassNamed(objectName);
                continue;
            }
            if (!"FEATLIST".equals(tag)) continue;
            Iterator it2 = element.getChildren().iterator();
            while (it2.hasNext()) {
                Feat aFeat = Globals.getFeatNamed(EntityEncoder.decode(((PCGElement)it2.next()).getText()));
                if (aFeat == null) continue;
                metaFeats.add(aFeat);
            }
        }
        if (obj == null || aPCClass == null || spellBook == null) {
            String message = "Illegal Spell line ignored: " + line;
            this.warnings.add(message);
            return;
        }
        if (source == null) {
            source = aPCClass;
        }
        if (obj instanceof ArrayList) {
            Iterator eo = ((ArrayList)obj).iterator();
            while (eo.hasNext() && ((aSpell = (Spell)eo.next()) == null || aSpell.levelForKey(source.getSpellKey(), this.aPC)[0] < 0)) {
            }
        }
        int[] spellLevels = aSpell.levelForKey(source.getSpellKey(), this.aPC);
        for (int sindex = 0; sindex < spellLevels.length; ++sindex) {
            int level = spellLevels[sindex];
            if (level < 0) {
                PCSpell pcSpell;
                boolean found = false;
                List aList = source.getSpellList();
                if (aList == null) continue;
                Iterator ri = aList.iterator();
                while (ri.hasNext() && ((pcSpell = (PCSpell)ri.next()) == null || !(found = aSpell.getName().equals(pcSpell.getName()) && pcSpell.getSpellbook().equals(spellBook)))) {
                }
                if (found) continue;
                String message = "Could not find spell " + aSpell.getName() + " in " + PCGVer2Parser.shortClassName(source) + " " + source.getName();
                this.warnings.add(message);
                continue;
            }
            if (spellBook.equals(Globals.getDefaultSpellBook()) && ((PCClass)aPCClass).isAutoKnownSpell(aSpell.getKeyName(), level, this.aPC) && this.aPC.getAutoSpells()) continue;
            CharacterSpell aCharacterSpell = aPCClass.getCharacterSpellForSpell(aSpell, aPCClass);
            if (aCharacterSpell == null) {
                aCharacterSpell = new CharacterSpell(source, aSpell);
                if (!(source instanceof Domain)) {
                    aCharacterSpell.addInfo(level, 1, spellBook);
                }
                aPCClass.addCharacterSpell(aCharacterSpell);
            }
            SpellInfo aSpellInfo = null;
            if (!(!source.getKeyName().equals(aPCClass.getKeyName()) && spellBook.equals(Globals.getDefaultSpellBook()) || (aSpellInfo = aCharacterSpell.getSpellInfoFor(spellBook, spellLevel, -1)) != null && metaFeats.isEmpty())) {
                aSpellInfo = aCharacterSpell.addInfo(spellLevel, times, spellBook);
            }
            if (aSpellInfo == null || metaFeats.isEmpty()) continue;
            aSpellInfo.addFeatsToList(metaFeats);
        }
        this.aPC.addSpellBook(spellBook);
    }

    private void parseSpellListLines(String line) {
        String subLine = line.substring("SPELLLIST".length() + 1);
        StringTokenizer stok = new StringTokenizer(subLine, "|", false);
        try {
            String className = stok.nextToken();
            PCClass aClass = this.aPC.getClassNamed(className);
            while (aClass != null && stok.hasMoreTokens()) {
                String tok = stok.nextToken();
                aClass.addClassSpellList(tok);
            }
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseStatLine(String line) throws PCGParseException {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            throw new PCGParseException("parseStatLine", line, pcgpex.getMessage());
        }
        Iterator it = tokens.getElements().iterator();
        if (!it.hasNext()) {
            String message = "Invalid attribute specification. Cannot load character.";
            throw new PCGParseException("parseStatLine", line, "Invalid attribute specification. Cannot load character.");
        }
        PCGElement element = (PCGElement)it.next();
        String statName = element.getText();
        int index = SettingsHandler.getGame().getStatFromAbbrev(statName);
        if (index > -1 && this.seenStats.add(statName.toUpperCase()) && it.hasNext()) {
            element = (PCGElement)it.next();
            try {
                ((PCStat)this.aPC.getStatList().getStats().get(index)).setBaseScore(Integer.parseInt(element.getText()));
                return;
            }
            catch (NumberFormatException nfe) {
                throw new PCGParseException("parseStatLine", line, nfe.getMessage());
            }
        }
        String message = "Invalid attribute specification. Cannot load character.";
        throw new PCGParseException("parseStatLine", line, "Invalid attribute specification. Cannot load character.");
    }

    private void parseTabNameLine(String line) {
        this.aPC.setTabName(EntityEncoder.decode(line.substring("TABNAME".length() + 1)));
    }

    private void parseTemplateLine(String line) {
        if (line.charAt("TEMPLATESAPPLIED".length() + 1) == '[') {
            PCGTokenizer tokens;
            try {
                tokens = new PCGTokenizer(line);
            }
            catch (PCGParseException pcgpex) {
                String message = "Illegal Template line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
                this.warnings.add(message);
                return;
            }
            PCTemplate aPCTemplate = null;
            Iterator it = tokens.getElements().iterator();
            if (it.hasNext()) {
                PCGElement element = (PCGElement)it.next();
                String tag = element.getName();
                Iterator it2 = element.getChildren().iterator();
                while (it2.hasNext()) {
                    element = (PCGElement)it2.next();
                    tag = element.getName();
                    if ("NAME".equals(tag)) {
                        aPCTemplate = this.addNamedTemplate(element.getText());
                        if (aPCTemplate != null) continue;
                        break;
                    }
                    if (!"CHOSENFEAT".equals(tag)) continue;
                    String mapKey = null;
                    String mapValue = null;
                    Iterator it3 = element.getChildren().iterator();
                    while (it3.hasNext()) {
                        element = (PCGElement)it3.next();
                        tag = element.getName();
                        if ("KEY".equals(tag)) {
                            mapKey = element.getText();
                            continue;
                        }
                        if (!"VALUE".equals(tag)) continue;
                        mapValue = element.getText();
                    }
                    if (mapKey == null || mapValue == null) continue;
                    aPCTemplate.addChosenFeat(EntityEncoder.decode(mapKey), EntityEncoder.decode(mapValue));
                }
            }
        } else {
            this.addNamedTemplate(line.substring("TEMPLATESAPPLIED".length() + 1));
        }
    }

    private void parseUseTempModsLine(String line) {
        this.aPC.setUseTempMods(line.endsWith("Y"));
    }

    private void parseVFeatLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal VFeat line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        Feat aFeat = null;
        Iterator it = tokens.getElements().iterator();
        if (it.hasNext()) {
            PCGElement element = (PCGElement)it.next();
            String featKey = EntityEncoder.decode(element.getText());
            aFeat = Globals.getFeatKeyed(featKey);
            if (aFeat == null) {
                String message = "Could not add vfeat: " + featKey;
                this.warnings.add(message);
                return;
            }
            this.aPC.addVirtualFeat(featKey, this.aPC.getVirtualFeatList());
            aFeat = PlayerCharacter.getFeatNamedInList(this.aPC.getVirtualFeatList(), featKey);
            aFeat.setNeedsSaving(true);
        }
        this.parseFeatsHandleAppliedToAndSaveTags(it, aFeat, line);
    }

    private void parseVersionLine(String line) throws PCGParseException {
        int[] version = new int[]{0, 0, 0};
        int idx = 0;
        StringTokenizer aTok = new StringTokenizer(line.substring("VERSION".length() + 1), ".-", true);
        try {
            String aString;
            while (idx < 3 && aTok.hasMoreTokens() && !(aString = aTok.nextToken()).equals("-")) {
                if (aString.equals(".")) continue;
                version[idx++] = Integer.parseInt(aString);
            }
            this.pcgenVersion = version;
        }
        catch (NumberFormatException ex) {
            throw new PCGParseException("parseVersionLine", "N/A", "Invalid PCGen version.");
        }
    }

    private void parseWeaponProficienciesLine(String line) {
        PCGElement element;
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Weapon proficiencies line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        PObject source = null;
        Iterator it = tokens.getElements().iterator();
        while (it.hasNext()) {
            String message;
            element = (PCGElement)it.next();
            if (!"SOURCE".equals(element.getName())) continue;
            String type = "";
            String name = "";
            Iterator it2 = element.getChildren().iterator();
            while (it2.hasNext()) {
                element = (PCGElement)it2.next();
                String tag = element.getName();
                if ("TYPE".equals(tag)) {
                    type = element.getText().toUpperCase();
                    continue;
                }
                if (!"NAME".equals(tag)) continue;
                name = element.getText();
            }
            if ("".equals(type) || "".equals(name)) {
                message = "Illegal Weapon proficiencies line ignored: " + line;
                this.warnings.add(message);
                return;
            }
            if ("RACE".equals(type)) {
                source = this.aPC.getRace();
            } else if ("PCCLASS".equals(type)) {
                source = this.aPC.getClassNamed(name);
            } else if ("DOMAIN".equals(type)) {
                source = this.aPC.getCharacterDomainNamed(name);
            } else if ("FEAT".equals(type)) {
                source = this.aPC.getFeatNamed(name);
            }
            if (source != null) break;
            message = "Invalid source specification: " + line;
            this.warnings.add(message);
            break;
        }
        element = (PCGElement)tokens.getElements().get(0);
        if (source == null) {
            it = element.getChildren().iterator();
            while (it.hasNext()) {
                this.weaponprofs.add(PCGVer2Parser.updateProficiencyName(((PCGElement)it.next()).getText(), true));
            }
        } else {
            it = element.getChildren().iterator();
            while (it.hasNext()) {
                source.addSelectedWeaponProfBonus(PCGVer2Parser.updateProficiencyName(((PCGElement)it.next()).getText(), true));
            }
        }
    }

    private void parseWeightLine(String line) {
        try {
            this.aPC.setWeightInPounds(Integer.parseInt(line.substring("WEIGHT".length() + 1)));
        }
        catch (NumberFormatException nfe) {
            String message = "Illegal Weight line ignored: " + line;
            this.warnings.add(message);
        }
    }

    private static String shortClassName(Object o) {
        Class<?> objClass = o.getClass();
        String pckName = objClass.getPackage().getName();
        return objClass.getName().substring(pckName.length() + 1);
    }

    private static String updateProficiencyName(String aString, boolean decode) {
        if (decode) {
            aString = EntityEncoder.decode(aString);
        }
        if (Globals.getWeaponProfNamed(aString) == null) {
            int idx = aString.indexOf("1-H");
            if (idx >= 0) {
                aString = aString.substring(0, idx) + "Exotic" + aString.substring(idx + 3);
            } else {
                idx = aString.indexOf("2-H");
                if (idx >= 0) {
                    aString = aString.substring(0, idx) + "Martial" + aString.substring(idx + 3);
                }
            }
        }
        return aString;
    }

    private void checkWeaponProficiencies() {
        this.aPC.setAutomaticFeatsStable(false);
        this.aPC.featAutoList();
        Iterator it = this.weaponprofs.iterator();
        while (it.hasNext()) {
            if (!this.aPC.hasWeaponProfNamed((String)it.next())) continue;
            it.remove();
        }
        if (this.weaponprofs.size() > 0) {
            String s = this.weaponprofs.toString();
            s = s.substring(1, s.length() - 1);
            String message = "No longer proficient with following weapon(s):" + Constants.s_LINE_SEP + s;
            this.warnings.add(message);
        }
    }

    private void parseCalcEquipSet(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Calc EquipSet line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        String calcEQId = EntityEncoder.decode(((PCGElement)tokens.getElements().get(0)).getText());
        if (calcEQId != null) {
            this.aPC.setCalcEquipSetId(calcEQId);
        }
    }

    private void parseCharacterBioLine(String line) {
        this.aPC.setBio(EntityEncoder.decode(line.substring("CHARACTERBIO".length() + 1)));
    }

    private void parseEquipmentLine(String line) {
        String tag;
        Iterator it;
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal Equipment line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        PCGElement element = (PCGElement)tokens.getElements().get(0);
        String itemKey = EntityEncoder.decode(element.getText());
        Equipment aEquip = this.aPC.getEquipmentNamed(itemKey);
        if (aEquip == null) {
            aEquip = EquipmentList.getEquipmentKeyedNoCustom(itemKey);
            if (aEquip != null) {
                aEquip = (Equipment)aEquip.clone();
            }
            if (line.indexOf("CUSTOMIZATION") >= 0) {
                it = tokens.getElements().iterator();
                while (it.hasNext()) {
                    element = (PCGElement)it.next();
                    if (!"CUSTOMIZATION".equals(element.getName())) continue;
                    String baseItemKey = "";
                    String customProperties = "";
                    Iterator it2 = element.getChildren().iterator();
                    while (it2.hasNext()) {
                        element = (PCGElement)it2.next();
                        tag = element.getName();
                        if ("BASEITEM".equals(tag)) {
                            baseItemKey = EntityEncoder.decode(element.getText());
                            continue;
                        }
                        if (!"DATA".equals(tag)) continue;
                        customProperties = EntityEncoder.decode(element.getText());
                    }
                    if (aEquip != null && baseItemKey.equals(aEquip.getBaseItemName())) {
                        aEquip.load(customProperties, "$", "=", this.aPC);
                        break;
                    }
                    Equipment aEquip2 = EquipmentList.getEquipmentKeyedNoCustom(baseItemKey);
                    if (aEquip2 == null) break;
                    aEquip = (Equipment)aEquip2.clone();
                    aEquip.load(customProperties, "$", "=", this.aPC);
                    aEquip.setOutputName("");
                    EquipmentList.addEquipment((Equipment)aEquip.clone());
                    break;
                }
            }
            if (aEquip == null) {
                String message = "Could not add equipment: " + itemKey + Constants.s_LINE_SEP + "Check loaded campaigns.";
                this.warnings.add(message);
                return;
            }
            this.aPC.addEquipment(aEquip);
        }
        it = tokens.getElements().iterator();
        while (it.hasNext()) {
            element = (PCGElement)it.next();
            tag = element.getName();
            if ("QUANTITY".equals(tag)) {
                aEquip.setQty(element.getText());
                continue;
            }
            if ("OUTPUTORDER".equals(tag)) {
                int index = 0;
                try {
                    index = Integer.parseInt(element.getText());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                aEquip.setOutputIndex(index);
                continue;
            }
            if ("COST".equals(tag) || !"WT".equals(tag)) continue;
        }
    }

    private void parseEquipmentSetLine(String line) {
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal EquipSet line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        String setName = null;
        String setID = null;
        String itemKey = null;
        String setNote = null;
        Float itemQuantity = null;
        boolean useTempMods = false;
        Iterator it = tokens.getElements().iterator();
        while (it.hasNext()) {
            PCGElement element = (PCGElement)it.next();
            String tag = element.getName();
            if ("EQUIPSET".equals(tag)) {
                setName = EntityEncoder.decode(element.getText());
                continue;
            }
            if ("ID".equals(tag)) {
                setID = element.getText();
                continue;
            }
            if ("VALUE".equals(tag)) {
                itemKey = EntityEncoder.decode(element.getText());
                continue;
            }
            if ("QUANTITY".equals(tag)) {
                try {
                    itemQuantity = new Float(element.getText());
                }
                catch (NumberFormatException nfe) {
                    itemQuantity = new Float(0.0f);
                }
                continue;
            }
            if ("NOTE".equals(tag)) {
                setNote = EntityEncoder.decode(element.getText());
                continue;
            }
            if (!"USETEMPMODS".equals(tag)) continue;
            useTempMods = element.getText().endsWith("Y");
        }
        if (setName == null || "".equals(setName) || setID == null || "".equals(setID)) {
            String message = "Illegal EquipSet line ignored: " + line;
            this.warnings.add(message);
            return;
        }
        EquipSet aEquipSet = new EquipSet(setID, setName);
        if (setNote != null) {
            aEquipSet.setNote(setNote);
        }
        if (itemKey != null) {
            aEquipSet.setValue(itemKey);
            Equipment eqI = this.aPC.getEquipmentNamed(itemKey);
            if (eqI == null) {
                eqI = EquipmentList.getEquipmentNamed(itemKey);
            }
            if (eqI == null) {
                String message = "Could not find equipment: " + itemKey;
                this.warnings.add(message);
                return;
            }
            Equipment aEquip = (Equipment)eqI.clone();
            if (itemQuantity != null) {
                aEquipSet.setQty(itemQuantity);
                aEquip.setQty(itemQuantity);
                aEquip.setNumberCarried(itemQuantity);
            }
            if (new StringTokenizer(setID, ".").countTokens() > 3) {
                EquipSet aEquipSet2 = this.aPC.getEquipSetByIdPath(aEquipSet.getParentIdPath());
                Equipment aEquip2 = null;
                if (aEquipSet2 != null) {
                    aEquip2 = aEquipSet2.getItem();
                }
                if (aEquip2 != null) {
                    aEquip2.insertChild(this.aPC, aEquip);
                    aEquip.setParent(aEquip2);
                }
            }
            aEquipSet.setItem(aEquip);
        }
        aEquipSet.setUseTempMods(useTempMods);
        this.aPC.addEquipSet(aEquipSet);
    }

    private void parseMoneyLine(String line) {
        this.aPC.setGold(line.substring("MONEY".length() + 1));
    }

    private void parseTempBonusLine(String line) {
        String tag;
        PCGElement element;
        PCGTokenizer tokens;
        try {
            tokens = new PCGTokenizer(line);
        }
        catch (PCGParseException pcgpex) {
            String message = "Illegal TempBonus line ignored: " + line + Constants.s_LINE_SEP + "Error: " + pcgpex.getMessage();
            this.warnings.add(message);
            return;
        }
        String cTag = null;
        String tName = null;
        Iterator it = tokens.getElements().iterator();
        while (it.hasNext()) {
            element = (PCGElement)it.next();
            tag = element.getName();
            if ("TEMPBONUS".equals(tag)) {
                cTag = EntityEncoder.decode(element.getText());
                continue;
            }
            if (!"TBTARGET".equals(tag)) continue;
            tName = EntityEncoder.decode(element.getText());
        }
        if (cTag == null || tName == null) {
            this.warnings.add("Illegal TempBonus line ignored: " + line);
            return;
        }
        BonusObj newB = null;
        StringTokenizer aTok = new StringTokenizer(cTag, "=", false);
        if (aTok.countTokens() < 2) {
            return;
        }
        String cType = aTok.nextToken();
        String cName = aTok.nextToken();
        Equipment aEq = null;
        if (!tName.equals("PC")) {
            Equipment eq = this.aPC.getEquipmentNamed(tName);
            if (eq == null) {
                return;
            }
            aEq = (Equipment)eq.clone();
            aEq.resetTempBonusList();
        }
        Iterator it2 = tokens.getElements().iterator();
        while (it2.hasNext()) {
            Spell aSpell;
            String bonus;
            element = (PCGElement)it2.next();
            tag = element.getName();
            if (!"TBBONUS".equals(tag) || (bonus = EntityEncoder.decode(element.getText())) == null || bonus.length() <= 0) continue;
            if (cType.equals("FEAT")) {
                Feat aFeat = Globals.getFeatKeyed(cName);
                if (aFeat == null) {
                    aFeat = Globals.getFeatNamed(cName);
                }
                if (aFeat != null) {
                    newB = Bonus.newBonus(bonus);
                    newB.setCreatorObject(aFeat);
                }
            } else if (cType.equals("EQUIPMENT")) {
                Equipment aEquip = this.aPC.getEquipmentNamed(cName);
                if (aEquip == null) {
                    aEquip = EquipmentList.getEquipmentNamed(cName);
                }
                if (aEquip != null) {
                    newB = Bonus.newBonus(bonus);
                    newB.setCreatorObject(aEquip);
                }
            } else if (cType.equals("CLASS")) {
                PCClass aClass = this.aPC.getClassNamed(cName);
                if (aClass == null) continue;
                int idx = bonus.indexOf(124);
                newB = Bonus.newBonus(bonus.substring(idx + 1));
                newB.setCreatorObject(aClass);
            } else if (cType.equals("TEMPLATE")) {
                PCTemplate aTemplate = this.aPC.getTemplateNamed(cName);
                if (aTemplate == null) {
                    aTemplate = Globals.getTemplateNamed(cName);
                }
                if (aTemplate != null) {
                    newB = Bonus.newBonus(bonus);
                    newB.setCreatorObject(aTemplate);
                }
            } else if (cType.equals("SKILL")) {
                Skill aSkill = this.aPC.getSkillNamed(cName);
                if (aSkill == null) {
                    aSkill = Globals.getSkillNamed(cName);
                }
                if (aSkill != null) {
                    newB = Bonus.newBonus(bonus);
                    newB.setCreatorObject(aSkill);
                }
            } else if (cType.equals("SPELL") && (aSpell = Globals.getSpellNamed(cName)) != null) {
                newB = Bonus.newBonus(bonus);
                newB.setCreatorObject(aSpell);
            }
            if (newB == null) {
                return;
            }
            if (tName.equals("PC")) {
                newB.setApplied(true);
                newB.setTargetObject(this.aPC);
                this.aPC.addTempBonus(newB);
                continue;
            }
            newB.setApplied(true);
            newB.setTargetObject(aEq);
            aEq.addTempBonus(newB);
            this.aPC.addTempBonus(newB);
        }
        if (aEq != null) {
            aEq.setAppliedName(cName);
            this.aPC.addTempBonusItemList(aEq);
        }
    }

    private void sortCharacterSpells() {
        Iterator it = this.aPC.getClassList().iterator();
        while (it.hasNext()) {
            ((PCClass)it.next()).sortCharacterSpellList();
        }
    }

    private static String sourceElementToString(PCGElement source) {
        String type = "";
        String name = "";
        String level = "";
        String defined = "";
        Iterator it = source.getChildren().iterator();
        while (it.hasNext()) {
            PCGElement element = (PCGElement)it.next();
            String tag = element.getName();
            if ("TYPE".equals(tag)) {
                type = element.getText();
                continue;
            }
            if ("NAME".equals(tag)) {
                name = element.getText();
                continue;
            }
            if ("LEVEL".equals(tag)) {
                level = element.getText();
                continue;
            }
            if (!"DEFINED".equals(tag)) continue;
            defined = element.getText().toUpperCase();
        }
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append(type);
        buffer.append("Y".equals(defined) ? (char)'=' : '|');
        buffer.append(name);
        if (!"".equals(level)) {
            buffer.append('|');
            buffer.append(level);
        }
        return buffer.toString();
    }

    private static final class PCGTokenizer {
        private final List elements;
        private final String innerDelimiter;
        private final String nestedStartDelimiter;
        private final String nestedStopDelimiter;
        private final String outerDelimiter;
        private final char nestedStartDelimiterChar;
        private final char nestedStopDelimiterChar;

        private PCGTokenizer(String line) throws PCGParseException {
            this(line, ":|[]");
        }

        private PCGTokenizer(String line, String delimiters) throws PCGParseException {
            char[] dels = delimiters.toCharArray();
            this.innerDelimiter = String.valueOf(dels[0]);
            this.outerDelimiter = String.valueOf(dels[1]);
            this.nestedStartDelimiter = String.valueOf(dels[2]);
            this.nestedStopDelimiter = String.valueOf(dels[3]);
            this.nestedStartDelimiterChar = this.nestedStartDelimiter.charAt(0);
            this.nestedStopDelimiterChar = this.nestedStopDelimiter.charAt(0);
            this.elements = new ArrayList(0);
            this.tokenizeLine(line);
        }

        private List getElements() {
            return this.elements;
        }

        private void checkSyntax(String line) throws PCGParseException {
            char[] chars = line.toCharArray();
            int delimCount = 0;
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == this.nestedStartDelimiterChar) {
                    ++delimCount;
                    continue;
                }
                if (chars[i] != this.nestedStopDelimiterChar) continue;
                --delimCount;
            }
            if (delimCount < 0) {
                String message = "Missing " + this.nestedStartDelimiter;
                throw new PCGParseException("PCGTokenizer::checkSyntax", line, message);
            }
            if (delimCount > 0) {
                String message = "Missing " + this.nestedStopDelimiter;
                throw new PCGParseException("PCGTokenizer::checkSyntax", line, message);
            }
        }

        private void tokenizeLine(String line) throws PCGParseException {
            this.checkSyntax(line);
            PCGElement root = new PCGElement("root");
            this.tokenizeLine(root, line);
            this.elements.addAll(root.getChildren());
        }

        /*
         * Enabled aggressive block sorting
         */
        private void tokenizeLine(PCGElement parent, String line) throws PCGParseException {
            PCGElement element;
            int index;
            String token;
            String dels = this.outerDelimiter + this.nestedStartDelimiter + this.nestedStopDelimiter;
            StringTokenizer tokens = new StringTokenizer(line, dels, true);
            int nestedDepth = 0;
            String tag = null;
            StringBuffer buffer = new StringBuffer(1000);
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken().trim();
                if (token.equals(this.outerDelimiter)) {
                    if (nestedDepth == 0) {
                        if (buffer.length() <= 0) continue;
                        token = buffer.toString();
                        index = token.indexOf(this.innerDelimiter);
                        if (index < 0) {
                            String message = "Malformed PCG element: " + token;
                            throw new PCGParseException("PCGTokenizer::tokenizeLine", line, message);
                        }
                        buffer.delete(0, buffer.length());
                        element = new PCGElement(token.substring(0, index));
                        element.addContent(token.substring(index + 1));
                        parent.addContent(element);
                        continue;
                    }
                    buffer.append(token);
                    continue;
                }
                if (token.equals(this.nestedStartDelimiter)) {
                    block11: {
                        if (nestedDepth == 0) {
                            token = buffer.toString();
                            index = token.indexOf(this.innerDelimiter);
                            if (index >= 0 && index == token.length() - 1) {
                                buffer.delete(0, buffer.length());
                                tag = token.substring(0, index);
                                break block11;
                            } else {
                                String message = "Malformed PCG element: " + token;
                                throw new PCGParseException("PCGTokenizer::tokenizeLine", line, message);
                            }
                        }
                        buffer.append(token);
                    }
                    ++nestedDepth;
                    continue;
                }
                if (token.equals(this.nestedStopDelimiter)) {
                    if (--nestedDepth == 0) {
                        element = new PCGElement(tag);
                        this.tokenizeLine(element, buffer.toString());
                        parent.addContent(element);
                        buffer.delete(0, buffer.length());
                        continue;
                    }
                    buffer.append(token);
                    continue;
                }
                buffer.append(token);
            }
            if (buffer.length() <= 0) return;
            token = buffer.toString();
            index = token.indexOf(this.innerDelimiter);
            if (index >= 0) {
                buffer.delete(0, buffer.length());
                element = new PCGElement(token.substring(0, index));
                element.addContent(token.substring(index + 1));
                parent.addContent(element);
                return;
            }
            String message = "Malformed PCG element: " + token;
            throw new PCGParseException("PCGTokenizer::tokenizeLine", line, message);
        }
    }

    private static final class PCGElement {
        private final String name;
        private List children;
        private String text;

        private PCGElement(String name) {
            this.name = name;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(1000);
            buffer.append('<').append(this.getName()).append('>').append(PCGVer2Parser.LINE_SEP);
            buffer.append("<text>").append(this.getText()).append("</text>").append(PCGVer2Parser.LINE_SEP);
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                buffer.append(it.next().toString()).append(PCGVer2Parser.LINE_SEP);
            }
            buffer.append("</").append(this.getName()).append('>');
            return buffer.toString();
        }

        public List getChildren() {
            if (this.children == null) {
                this.children = new ArrayList(0);
            }
            return this.children;
        }

        private String getName() {
            return this.name;
        }

        private String getText() {
            return this.text != null ? this.text : "";
        }

        private void addContent(PCGElement child) {
            if (this.children == null) {
                this.children = new ArrayList(0);
            }
            this.children.add(child);
        }

        private void addContent(String argText) {
            this.text = argText;
        }
    }
}

