/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;
import pcgen.util.Delta;

public class AttackToken
extends Token {
    public static final String TOKENNAME = "ATTACK";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        if (aTok.hasMoreTokens()) {
            String attackType = aTok.nextToken();
            String modifier = "";
            try {
                modifier = aTok.nextToken();
            }
            catch (Exception e) {
                // empty catch block
            }
            retString = AttackToken.getParsedToken(pc, attackType, modifier);
        }
        return retString;
    }

    public static String getParsedToken(PlayerCharacter pc, String attackType, String modifier) {
        if (modifier.equals("TOTAL")) {
            if (attackType.equals("RANGED")) {
                int total = AttackToken.getTotalToken(pc, attackType);
                return pc.getAttackString(1, total);
            }
            if (attackType.equals("UNARMED")) {
                int total = AttackToken.getTotalToken(pc, "MELEE");
                return pc.getAttackString(0, total);
            }
            int total = AttackToken.getTotalToken(pc, attackType);
            return pc.getAttackString(0, total);
        }
        return AttackToken.getSubToken(pc, attackType, modifier);
    }

    private static String getSubToken(PlayerCharacter pc, String attackType, String modifier) {
        if (modifier.equals("BASE")) {
            return Delta.toString(AttackToken.getBaseToken(pc));
        }
        if (modifier.equals("EPIC")) {
            return Delta.toString(AttackToken.getEpicToken(pc));
        }
        if (modifier.equals("MISC")) {
            return Delta.toString(AttackToken.getMiscToken(pc, attackType));
        }
        if (modifier.equals("SIZE")) {
            return Delta.toString(AttackToken.getSizeToken(pc, attackType));
        }
        if (modifier.equals("STAT")) {
            return Delta.toString(AttackToken.getStatToken(pc, attackType));
        }
        if (!modifier.equals("TOTAL")) {
            if (attackType.equals("RANGED")) {
                return pc.getAttackString(1);
            }
            if (attackType.equals("UNARMED")) {
                return pc.getAttackString(2);
            }
            return pc.getAttackString(0);
        }
        return "";
    }

    public static int getBaseToken(PlayerCharacter pc) {
        return pc.baseAttackBonus();
    }

    public static int getEpicToken(PlayerCharacter pc) {
        return (int)pc.getBonusDueToType("COMBAT", "TOHIT", "EPIC");
    }

    public static int getMiscToken(PlayerCharacter pc, String aType) {
        int tohitBonus = (int)pc.getTotalBonusTo("TOHIT", "TOHIT") + (int)pc.getTotalBonusTo("TOHIT", "TYPE." + aType) - (int)pc.getStatBonusTo("TOHIT", "TYPE." + aType) - (int)pc.getSizeAdjustmentBonusTo("TOHIT", "TOHIT");
        int miscBonus = (int)pc.getTotalBonusTo("COMBAT", "TOHIT") + (int)pc.getTotalBonusTo("COMBAT", "TOHIT." + aType) - (int)pc.getStatBonusTo("COMBAT", "TOHIT." + aType) - (int)pc.getSizeAdjustmentBonusTo("COMBAT", "TOHIT") - (int)pc.getSizeAdjustmentBonusTo("COMBAT", "TOHIT." + aType) - (int)pc.getBonusDueToType("COMBAT", "TOHIT", "EPIC");
        return miscBonus + tohitBonus;
    }

    public static int getSizeToken(PlayerCharacter pc, String aType) {
        int tohitBonus = (int)pc.getSizeAdjustmentBonusTo("TOHIT", "TOHIT") + (int)pc.getSizeAdjustmentBonusTo("TOHIT", "TYPE." + aType);
        int sizeBonus = (int)pc.getSizeAdjustmentBonusTo("COMBAT", "TOHIT") + (int)pc.getSizeAdjustmentBonusTo("COMBAT", "TOHIT." + aType);
        return sizeBonus + tohitBonus;
    }

    public static int getStatToken(PlayerCharacter pc, String aType) {
        int tohitBonus = (int)pc.getStatBonusTo("TOHIT", "TYPE." + aType);
        int statBonus = (int)pc.getStatBonusTo("COMBAT", "TOHIT." + aType);
        return statBonus + tohitBonus;
    }

    public static int getTotalToken(PlayerCharacter pc, String aType) {
        int tohitBonus = (int)pc.getTotalBonusTo("TOHIT", "TOHIT") + (int)pc.getTotalBonusTo("TOHIT", "TYPE." + aType);
        int totalBonus = (int)pc.getTotalBonusTo("COMBAT", "TOHIT") + (int)pc.getTotalBonusTo("COMBAT", "TOHIT." + aType);
        return tohitBonus + totalBonus;
    }
}

