/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;

public class BaseMovementToken
extends Token {
    public static final String TOKENNAME = "BASEMOVEMENT";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String retString = "";
        if (pc.getRace() != null && !pc.getRace().equals(Globals.s_EMPTYRACE)) {
            StringTokenizer aTok = new StringTokenizer(tokenSource, ".", false);
            aTok.nextToken();
            String moveType = "WALK";
            int load = 0;
            boolean flag = true;
            if (aTok.hasMoreElements()) {
                moveType = aTok.nextToken();
                try {
                    int movNum = Integer.parseInt(moveType);
                    if (movNum < pc.getNumberOfMovements()) {
                        moveType = pc.getMovementType(movNum);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (aTok.hasMoreElements()) {
                String loadName = aTok.nextToken();
                if ("MEDIUM".equals(loadName)) {
                    load = 1;
                } else if ("HEAVY".equals(loadName)) {
                    load = 2;
                } else if ("OVERLOAD".equals(loadName)) {
                    load = 3;
                }
            }
            if (aTok.hasMoreElements()) {
                flag = "TRUE".equals(aTok.nextToken().toUpperCase());
            }
            retString = BaseMovementToken.getBaseMovementToken(pc, moveType, load, flag);
        }
        return retString;
    }

    public static String getBaseMovementToken(PlayerCharacter pc, String moveType, int loadType, boolean displayFlag) {
        for (int i = 0; i < pc.getNumberOfMovements(); ++i) {
            if (!pc.getMovementType(i).toUpperCase().equals(moveType.toUpperCase())) continue;
            if (displayFlag) {
                return moveType + " " + Globals.displayDistanceInUnitSet(Globals.convertDistanceToUnitSet(pc.basemovement(i, loadType))) + Globals.getDistanceUnit();
            }
            return Globals.displayDistanceInUnitSet(Globals.convertDistanceToUnitSet(pc.basemovement(i, loadType)));
        }
        return "";
    }
}

