/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.Iterator;
import java.util.StringTokenizer;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;

public class BonusListToken
extends Token {
    public static final String TOKENNAME = "BONUSLIST";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        return BonusListToken.getBonusListToken(tokenSource, pc);
    }

    public static String getBonusListToken(String tokenSource, PlayerCharacter pc) {
        StringTokenizer bTok = new StringTokenizer(tokenSource.substring(10), ".", false);
        String bonusString = "";
        String substring = "";
        String typeSeparator = " ";
        String delim = ", ";
        String retString = "";
        if (bTok.hasMoreTokens()) {
            bonusString = bTok.nextToken();
        }
        if (bTok.hasMoreTokens()) {
            substring = bTok.nextToken();
        }
        if (bTok.hasMoreTokens()) {
            typeSeparator = bTok.nextToken();
        }
        if (bTok.hasMoreTokens()) {
            delim = bTok.nextToken();
        }
        int typeLen = bonusString.length() + substring.length() + 2;
        if (substring.length() > 0 && bonusString.length() > 0) {
            int total = (int)pc.getTotalBonusTo(bonusString, substring);
            if ("TOTAL".equals(typeSeparator)) {
                retString = retString + total;
                return "";
            }
            boolean needDelim = false;
            String prefix = bonusString + "." + substring + ".";
            Iterator bi = pc.getActiveBonusMap().keySet().iterator();
            while (bi.hasNext()) {
                String aKey = bi.next().toString();
                if (!aKey.startsWith(prefix)) continue;
                if (needDelim) {
                    retString = retString + delim;
                }
                retString = aKey.length() > typeLen ? retString + aKey.substring(typeLen) : retString + "None";
                retString = retString + typeSeparator;
                retString = retString + pc.getActiveBonusMap().get(aKey);
                needDelim = true;
            }
        }
        return retString;
    }
}

