/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.io.exporttoken.Token;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;

public class BonusToken
extends Token {
    public static final String TOKENNAME = "BONUS";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        return BonusToken.getBonusToken(tokenSource, pc);
    }

    public static String getBonusToken(String tokenSource, PlayerCharacter pc) {
        StringTokenizer bonusTok = new StringTokenizer(tokenSource, ".", false);
        bonusTok.nextToken();
        String aType = bonusTok.nextToken();
        String aName = bonusTok.nextToken();
        double total = 0.0;
        int decimals = 0;
        double lastValue = 0.0;
        int signIt = 1;
        while (bonusTok.hasMoreTokens()) {
            String bucket = bonusTok.nextToken();
            if (CoreUtility.doublesEqual(total, 0.0) && "LISTING".equals(bucket)) {
                return pc.listBonusesFor(aType + "." + aName);
            }
            if ((bucket.startsWith("PRE") || bucket.startsWith("!PRE")) && bucket.indexOf(58) >= 0) {
                Logging.debugPrint("Why is this not parsed in loading: " + bucket + " rather than in BonsToken.getBonusToken()");
                Prerequisite prereq = null;
                try {
                    PreParserFactory factory = PreParserFactory.getInstance();
                    prereq = factory.parse(bucket);
                }
                catch (PersistenceLayerException ple) {
                    Logging.errorPrint(ple.getMessage(), ple);
                }
                if (PrereqHandler.passes(prereq, pc, null)) continue;
                total -= lastValue * (double)signIt;
                lastValue = 0.0;
                continue;
            }
            if (bucket.startsWith("MIN=")) {
                double x = Float.parseFloat(bucket.substring(4));
                if (!(lastValue < x)) continue;
                total -= lastValue - x;
                continue;
            }
            if (bucket.startsWith("MAX=")) {
                double x = Float.parseFloat(bucket.substring(4));
                x = Math.min(x, lastValue);
                total -= lastValue - x;
                lastValue = 0.0;
                continue;
            }
            signIt = 1;
            if (bucket.length() > 0 && bucket.charAt(0) == '!') {
                signIt = -1;
                bucket = bucket.substring(1);
            }
            if (bucket.equals("EQTYPE") && bonusTok.hasMoreTokens()) {
                bucket = bucket + "." + bonusTok.nextToken();
            }
            if ("TOTAL".equals(bucket)) {
                lastValue = pc.getTotalBonusTo(aType, aName);
            } else if (bucket.startsWith("DEC=")) {
                decimals = Integer.parseInt(bucket.substring(4));
            } else if (bucket.startsWith("TYPE=") || bucket.startsWith("EQTYPE.")) {
                lastValue = 0.0;
                String restOfBucket = bucket.startsWith("TYPE=") ? bucket.substring(5) : bucket.substring(7);
                List aList = pc.getEquipmentOfType(restOfBucket, "", 1);
                if (!aList.isEmpty()) {
                    Iterator e = aList.iterator();
                    while (e.hasNext()) {
                        Equipment eq = (Equipment)e.next();
                        lastValue += eq.bonusTo(pc, aType, aName, true);
                    }
                }
            } else {
                lastValue = pc.getBonusDueToType(aType, aName, bucket);
            }
            total += lastValue * (double)signIt;
        }
        return String.valueOf((int)(total * Math.pow(10.0, decimals)) / (int)Math.pow(10.0, decimals));
    }
}

