/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Delta;

public class CheckToken
extends Token {
    public static final String TOKENNAME = "CHECK";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".", false);
        aTok.nextToken();
        String saveType = aTok.nextToken();
        String saveMods = "";
        while (aTok.hasMoreTokens()) {
            if (saveMods.length() > 0) {
                saveMods = saveMods + ".";
            }
            saveMods = saveMods + aTok.nextToken();
        }
        if ("NAME".equals(saveMods)) {
            return CheckToken.getNameToken(saveType);
        }
        return Delta.toString(CheckToken.getCheckToken(pc, saveType, saveMods));
    }

    public static int getCheckToken(PlayerCharacter pc, String saveType, String saveMods) {
        saveType = CheckToken.getNameToken(saveType);
        if ("".equals(saveMods)) {
            saveMods = "TOTAL";
        }
        return pc.calculateSaveBonus(1, saveType, saveMods);
    }

    public static String getNameToken(String saveType) {
        try {
            int i = Integer.parseInt(saveType);
            if (i >= 0 && i < SettingsHandler.getGame().getUnmodifiableCheckList().size()) {
                saveType = SettingsHandler.getGame().getUnmodifiableCheckList().get(i).toString();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return saveType;
    }
}

