/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;

public class ClassToken
extends Token {
    public static final String TOKENNAME = "CLASS";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        int i = 0;
        if (aTok.hasMoreTokens()) {
            i = Integer.parseInt(aTok.nextToken());
        }
        if (aTok.hasMoreTokens()) {
            String subToken = aTok.nextToken();
            if ("LEVEL".equals(subToken)) {
                int level = ClassToken.getLevelToken(pc, i);
                if (level > 0) {
                    return level + "";
                }
                return "";
            }
            if ("SALIST".equals(subToken)) {
                return ClassToken.getSAListToken(pc, i);
            }
        }
        return ClassToken.getClassToken(pc, i);
    }

    public static String getClassToken(PlayerCharacter pc, int classNumber) {
        String retString = "";
        if (pc.getClassList().size() > classNumber) {
            PCClass pcClass = (PCClass)pc.getClassList().get(classNumber);
            retString = "None".equals(pcClass.getSubClassName()) || "".equals(pcClass.getSubClassName()) ? pcClass.getOutputName() : pcClass.getSubClassName();
        }
        return retString;
    }

    public static int getLevelToken(PlayerCharacter pc, int classNumber) {
        if (pc.getClassList().size() > classNumber) {
            PCClass pcClass = (PCClass)pc.getClassList().get(classNumber);
            return pcClass.getLevel();
        }
        return 0;
    }

    public static String getSAListToken(PlayerCharacter pc, int classNumber) {
        String retString = "";
        if (pc.getClassList().size() > classNumber) {
            boolean firstLine = true;
            PCClass pcClass = (PCClass)pc.getClassList().get(classNumber);
            for (int i = 0; i < pcClass.getClassSpecialAbilityList(pc).size(); ++i) {
                if (!firstLine) {
                    retString = retString + ", ";
                }
                firstLine = false;
                retString = retString + pcClass.getClassSpecialAbilityList(pc).get(i).toString();
            }
        }
        return retString;
    }
}

