/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.io.exporttoken.Token;

public class DeityToken
extends Token {
    public static final String TOKENNAME = "DEITY";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String retString = "";
        if (pc.getDeity() != null) {
            StringTokenizer aTok = new StringTokenizer(tokenSource, ".", false);
            String subTag = "OUTPUTNAME";
            Deity deity = pc.getDeity();
            if (aTok.countTokens() > 1) {
                aTok.nextToken();
                subTag = aTok.nextToken();
            }
            if ("NAME".equals(subTag)) {
                retString = DeityToken.getNameToken(deity);
            } else if ("OUTPUTNAME".equals(subTag)) {
                retString = DeityToken.getOutputNameToken(deity);
            } else if ("DOMAINLIST".equals(subTag)) {
                retString = DeityToken.getDomainListToken(deity);
            } else if ("FOLLOWERALIGNMENT".equals(subTag)) {
                retString = DeityToken.getFollowerAlignmentToken(deity);
            } else if ("ALIGNMENT".equals(subTag)) {
                retString = DeityToken.getAlignmentToken(deity);
            } else if ("APPEARANCE".equals(subTag)) {
                retString = DeityToken.getAppearanceToken(deity);
            } else if ("DESCRIPTION".equals(subTag)) {
                retString = DeityToken.getDescriptionToken(deity);
            } else if ("HOLYITEM".equals(subTag)) {
                retString = DeityToken.getHolyItemToken(deity);
            } else if ("FAVOREDWEAPON".equals(subTag)) {
                retString = DeityToken.getFavoredWeaponToken(deity);
            } else if ("PANTHEONLIST".equals(subTag)) {
                retString = DeityToken.getPantheonListToken(deity);
            } else if ("SOURCE".equals(subTag)) {
                retString = DeityToken.getSourceToken(deity);
            } else if ("SA".equals(subTag)) {
                retString = DeityToken.getSAToken(deity);
            } else if ("TITLE".equals(subTag)) {
                retString = DeityToken.getTitleToken(deity);
            } else if ("WORSHIPPERS".equals(subTag)) {
                retString = DeityToken.getWorshippersToken(deity);
            }
        }
        return retString;
    }

    public static String getAlignmentToken(Deity deity) {
        return deity.getAlignment();
    }

    public static String getAppearanceToken(Deity deity) {
        return deity.getAppearance();
    }

    public static String getDescriptionToken(Deity deity) {
        return deity.getDescription();
    }

    public static String getDomainListToken(Deity deity) {
        String retString = "";
        List dList = deity.getDomainList();
        boolean firstLine = true;
        for (int i = 0; i < deity.getDomainList().size(); ++i) {
            if (!firstLine) {
                retString = retString + ", ";
            }
            firstLine = false;
            retString = retString + ((Domain)deity.getDomainList().get(i)).getName();
        }
        return retString;
    }

    public static String getFavoredWeaponToken(Deity deity) {
        return deity.getFavoredWeapon();
    }

    public static String getFollowerAlignmentToken(Deity deity) {
        String retString = "";
        boolean firstLine = true;
        String fAlignment = deity.getFollowerAlignments();
        for (int i = 0; i < fAlignment.length(); ++i) {
            if (!firstLine) {
                retString = retString + ", ";
            }
            firstLine = false;
            retString = retString + SettingsHandler.getGame().getShortAlignmentAtIndex(fAlignment.charAt(i) - 48);
        }
        return retString;
    }

    public static String getHolyItemToken(Deity deity) {
        return deity.getHolyItem();
    }

    public static String getNameToken(Deity deity) {
        return deity.getName();
    }

    public static String getOutputNameToken(Deity deity) {
        return deity.getOutputName();
    }

    public static String getPantheonListToken(Deity deity) {
        return CoreUtility.join((Collection)deity.getPantheonList(), ", ");
    }

    public static String getSAToken(Deity deity) {
        if (deity.getSpecialAbilityList() != null) {
            return CoreUtility.join((Collection)deity.getSpecialAbilityList(), ", ");
        }
        return "";
    }

    public static String getSourceToken(Deity deity) {
        return deity.getSource();
    }

    public static String getTitleToken(Deity deity) {
        return deity.getTitle();
    }

    public static String getWorshippersToken(Deity deity) {
        return deity.getWorshippers();
    }
}

