/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Logging;

public class DirToken
extends Token {
    public static final String TOKENNAME = "DIR";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        String dirType = "";
        if (aTok.hasMoreTokens()) {
            dirType = aTok.nextToken();
        }
        if ("PCGEN".equals(dirType)) {
            retString = DirToken.getPCGenToken();
        } else if ("TEMPLATES".equals(dirType)) {
            retString = DirToken.getTemplatesToken();
        } else if ("PCG".equals(dirType)) {
            retString = DirToken.getPcgToken();
        } else if ("HTML".equals(dirType)) {
            retString = DirToken.getHtmlToken();
        } else if ("TEMP".equals(dirType)) {
            retString = DirToken.getTempToken();
        } else {
            Logging.errorPrint("DIR: Unknown Dir: " + dirType);
            retString = dirType;
        }
        return retString;
    }

    public static String getHtmlToken() {
        return SettingsHandler.getHTMLOutputSheetPath();
    }

    public static String getPCGenToken() {
        return SettingsHandler.getPcgenSystemDir().getAbsolutePath();
    }

    public static String getPcgToken() {
        return SettingsHandler.getPcgPath().getAbsolutePath();
    }

    public static String getTempToken() {
        return SettingsHandler.getTempPath().getAbsolutePath();
    }

    public static String getTemplatesToken() {
        return SettingsHandler.getPcgenOutputSheetDir().getAbsolutePath();
    }
}

