/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.CharacterDomain;
import pcgen.core.Domain;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;

public class DomainToken
extends Token {
    public static final String TOKENNAME = "DOMAIN";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        if (aTok.hasMoreTokens()) {
            int domainIndex = 0;
            try {
                domainIndex = Math.max(0, Integer.parseInt(aTok.nextToken()) - 1);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (aTok.hasMoreTokens()) {
                String subToken = aTok.nextToken();
                if ("POWER".equals(subToken)) {
                    retString = DomainToken.getPowerToken(pc, domainIndex);
                }
            } else {
                retString = DomainToken.getDomainToken(pc, domainIndex);
            }
        }
        return retString;
    }

    public static String getDomainToken(PlayerCharacter pc, int domainIndex) {
        try {
            Domain domain = ((CharacterDomain)pc.getCharacterDomainList().get(domainIndex)).getDomain();
            return domain.getOutputName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getPowerToken(PlayerCharacter pc, int domainIndex) {
        try {
            Domain domain = ((CharacterDomain)pc.getCharacterDomainList().get(domainIndex)).getDomain();
            return domain.piDescString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

