/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.math.BigDecimal;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;
import pcgen.util.BigDecimalHelper;

public class EqContainersToken
extends Token {
    public static final String TOKENNAME = "EQCONTAINERS";
    public static final String INDENT = "\t";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".", false);
        aTok.nextToken();
        Equipment eq = null;
        if (aTok.hasMoreElements()) {
            try {
                int containerNo = Integer.parseInt(aTok.nextToken());
                eq = this.getContainer(pc, containerNo);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (eq != null) {
            String property = "NAME";
            if (aTok.hasMoreElements()) {
                property = aTok.nextToken();
            }
            if (property.equals("ACCHECK")) {
                retString = EqContainersToken.getAcCheckToken(pc, eq) + "";
            } else if (property.equals("ACMOD")) {
                retString = EqContainersToken.getAcModToken(pc, eq) + "";
            } else if (property.equals("ALTCRIT")) {
                retString = EqContainersToken.getAltCritToken(eq);
            } else if (property.equals("ALTDAMAGE")) {
                retString = EqContainersToken.getAltDamageToken(pc, eq);
            } else if (property.equals("ATTACKS")) {
                retString = EqContainersToken.getAttacksToken(pc, eq) + "";
            } else if (property.equals("CARRIED")) {
                retString = EqContainersToken.getCarriedToken(eq) + "";
            } else if (property.equals("CONTENTS")) {
                retString = EqContainersToken.getContentsToken(eq, aTok);
            } else if (property.equals("CONTENTWEIGHT")) {
                retString = BigDecimalHelper.trimZeros(EqContainersToken.getContentWeightToken(pc, eq) + "");
            } else if (property.equals("COST")) {
                retString = BigDecimalHelper.trimZeros(EqContainersToken.getCostToken(pc, eq));
            } else if (property.equals("CRITMULT")) {
                retString = EqContainersToken.getCritMultToken(eq);
            } else if (property.equals("CRITRANGE")) {
                retString = EqContainersToken.getCritRangeToken(pc, eq);
            } else if (property.equals("DAMAGE")) {
                retString = EqContainersToken.getDamageToken(pc, eq);
            } else if (property.equals("EDR")) {
                retString = EqContainersToken.getEdrToken(pc, eq) + "";
            } else if (property.equals("EQUIPPED")) {
                retString = EqContainersToken.getEquippedToken(eq);
            } else if (property.equals("ITEMWEIGHT")) {
                retString = BigDecimalHelper.trimZeros(EqContainersToken.getItemWeightToken(pc, eq) + "");
            } else if (property.equals("LOCATION")) {
                retString = EqContainersToken.getLocationToken(eq);
            } else if (property.equals("LONGNAME")) {
                retString = EqContainersToken.getLongNameToken(eq);
            } else if (property.equals("MAXDEX")) {
                retString = EqContainersToken.getMaxDexToken(pc, eq) + "";
            } else if (property.equals("MOVE")) {
                retString = EqContainersToken.getMoveToken(eq);
            } else if (property.equals("NAME") || property.equals("OUTPUTNAME")) {
                retString = EqContainersToken.getNameToken(eq, pc);
            } else if (property.equals("PROF")) {
                retString = EqContainersToken.getProfToken(pc, eq);
            } else if (property.equals("QTY")) {
                retString = BigDecimalHelper.trimZeros(Double.toString(EqContainersToken.getQuantityToken(eq)));
            } else if (property.equals("RANGE")) {
                retString = EqContainersToken.getRangeToken(eq, pc) + "";
            } else if (property.equals("SIZE")) {
                retString = EqContainersToken.getSizeToken(eq);
            } else if (property.equals("SPELLFAILURE")) {
                retString = EqContainersToken.getSpellFailureToken(pc, eq) + "";
            } else if (property.equals("SPROP")) {
                retString = EqContainersToken.getSPropToken(pc, eq);
            } else if (property.equals("TOTALWEIGHT") || property.equals("WT")) {
                retString = BigDecimalHelper.trimZeros(EqContainersToken.getTotalWeightToken(pc, eq) + "");
            } else if (property.equals("TYPE")) {
                retString = EqContainersToken.getTypeToken(eq, aTok);
            }
        }
        return retString;
    }

    public static int getAcCheckToken(PlayerCharacter pc, Equipment eq) {
        return eq.acCheck(pc);
    }

    public static int getAcModToken(PlayerCharacter pc, Equipment eq) {
        return eq.getACMod(pc);
    }

    public static String getAltCritToken(Equipment eq) {
        return eq.getAltCritMult();
    }

    public static String getAltDamageToken(PlayerCharacter pc, Equipment eq) {
        return eq.getAltDamage(pc);
    }

    public static double getAttacksToken(PlayerCharacter pc, Equipment eq) {
        return eq.bonusTo(pc, "COMBAT", "ATTACKS", true);
    }

    public static float getCarriedToken(Equipment eq) {
        return eq.numberCarried().floatValue();
    }

    public static String getContentsToken(Equipment eq, StringTokenizer aTok) {
        String retString = "";
        if (aTok.hasMoreTokens()) {
            String aType = aTok.nextToken();
            String aSubTag = "NAME";
            if (aTok.hasMoreTokens()) {
                aSubTag = aTok.nextToken();
            }
            retString = eq.getContainerByType(aType, aSubTag);
        } else {
            retString = eq.getContainerContentsString();
        }
        return retString;
    }

    public static float getContentWeightToken(PlayerCharacter pc, Equipment eq) {
        if (eq.getChildCount() == 0) {
            return 0.0f;
        }
        return eq.getContainedWeight(pc).floatValue();
    }

    public static BigDecimal getCostToken(PlayerCharacter pc, Equipment eq) {
        return eq.getCost(pc);
    }

    public static String getCritMultToken(Equipment eq) {
        return eq.getCritMult();
    }

    public static String getCritRangeToken(PlayerCharacter pc, Equipment eq) {
        return eq.getCritRange(pc);
    }

    public static String getDamageToken(PlayerCharacter pc, Equipment eq) {
        String retString = eq.getDamage(pc);
        if (pc != null && eq.isNatural()) {
            retString = Globals.adjustDamage(retString, Globals.sizeInt(pc.getRace().getSize()), pc.sizeInt());
        }
        return retString;
    }

    public static int getEdrToken(PlayerCharacter pc, Equipment eq) {
        return eq.eDR(pc);
    }

    public static String getEquippedToken(Equipment eq) {
        if (eq.isEquipped()) {
            return "Y";
        }
        return "N";
    }

    public static float getItemWeightToken(PlayerCharacter pc, Equipment eq) {
        return eq.getWeight(pc).floatValue();
    }

    public static String getLocationToken(Equipment eq) {
        return eq.getParentName();
    }

    public static String getLongNameToken(Equipment eq) {
        String retString = "";
        for (int depth = eq.itemDepth(); depth > 0; --depth) {
            retString = retString + INDENT;
        }
        return retString + eq.longName();
    }

    public static int getMaxDexToken(PlayerCharacter pc, Equipment eq) {
        return eq.getMaxDex(pc);
    }

    public static String getMoveToken(Equipment eq) {
        return eq.moveString();
    }

    public static String getNameToken(Equipment eq, PlayerCharacter pc) {
        return eq.parseOutputName(eq.getOutputName(), pc);
    }

    public static String getProfToken(PlayerCharacter pc, Equipment eq) {
        return eq.profName(pc);
    }

    public static double getQuantityToken(Equipment eq) {
        return eq.qty();
    }

    public static int getRangeToken(Equipment eq, PlayerCharacter pc) {
        return eq.getRange(pc);
    }

    public static String getSizeToken(Equipment eq) {
        return eq.getSize();
    }

    public static int getSpellFailureToken(PlayerCharacter pc, Equipment eq) {
        return eq.spellFailure(pc);
    }

    public static String getSPropToken(PlayerCharacter pc, Equipment eq) {
        return eq.getSpecialProperties(pc);
    }

    public static float getTotalWeightToken(PlayerCharacter pc, Equipment eq) {
        return EqContainersToken.getContentWeightToken(pc, eq) + EqContainersToken.getItemWeightToken(pc, eq);
    }

    public static String getTypeToken(Equipment eq, StringTokenizer aTok) {
        String retString = "";
        if (aTok.hasMoreTokens()) {
            try {
                int x = Integer.parseInt(aTok.nextToken());
                retString = eq.typeIndex(x);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            retString = eq.getType();
        }
        return retString;
    }

    private Equipment getContainer(PlayerCharacter pc, int no) {
        List eqList = pc.getEquipmentListInOutputOrder();
        for (int i = 0; i < eqList.size(); ++i) {
            Equipment eq = (Equipment)eqList.get(i);
            if (eq.isContainer()) {
                --no;
            }
            if (no >= 0) continue;
            return eq;
        }
        return null;
    }
}

