/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SystemCollections;
import pcgen.io.exporttoken.Token;
import pcgen.util.BigDecimalHelper;

public class EqToken
extends Token {
    public static final String TOKENNAME = "EQ";
    private static String cachedString = null;
    private static List cachedList = null;
    private static int cachedSerial = 0;
    private static PlayerCharacter cachedPC = null;

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String token;
        String bFilter = "";
        String befTrue = "";
        String aftTrue = "";
        String befFalse = "";
        String aftFalse = "";
        StringTokenizer bTok = new StringTokenizer(tokenSource, "~");
        if (bTok.countTokens() >= 3) {
            bFilter = bTok.nextToken();
            befTrue = bTok.nextToken();
            aftTrue = bTok.nextToken();
            if (bTok.hasMoreTokens()) {
                befFalse = bTok.nextToken();
                aftFalse = bTok.nextToken();
            }
            tokenSource = tokenSource.substring(0, bFilter.lastIndexOf(46));
        }
        bTok = new StringTokenizer(bFilter, ".");
        boolean if_detected = false;
        while (bTok.hasMoreTokens()) {
            String bString = bTok.nextToken();
            if ("IF".equals(bString)) {
                if_detected = true;
                continue;
            }
            if (if_detected) {
                bFilter = bFilter + "." + bString;
                continue;
            }
            bFilter = bString;
        }
        String comparatorString = tokenSource.split("[0-9]+")[0];
        List<Equipment> eqList = null;
        StringTokenizer aTok = null;
        int temp = -1;
        if (comparatorString.equals(cachedString) && pc == cachedPC && pc.getSerial() == cachedSerial) {
            eqList = cachedList;
            tokenSource = tokenSource.substring(comparatorString.length());
            aTok = new StringTokenizer(tokenSource, ".", false);
            token = aTok.nextToken();
            while (aTok.hasMoreTokens()) {
                try {
                    temp = Integer.parseInt(token);
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
                if (temp < 0) {
                    token = aTok.nextToken();
                    continue;
                }
                break;
            }
        } else {
            aTok = new StringTokenizer(tokenSource, ".", false);
            aTok.nextToken();
            token = aTok.nextToken();
            int merge = 0;
            if (token.indexOf("MERGE") >= 0) {
                merge = EqToken.returnMergeType(token);
                token = aTok.nextToken();
            }
            eqList = new ArrayList<Equipment>();
            Iterator e = pc.getEquipmentListInOutputOrder(merge).iterator();
            while (e.hasNext()) {
                Equipment eq = (Equipment)e.next();
                eqList.add(eq);
            }
            while (aTok.hasMoreTokens()) {
                if ("NOT".equalsIgnoreCase(token)) {
                    eqList = EqToken.listNotType(pc, eqList, aTok.nextToken());
                } else if ("ADD".equalsIgnoreCase(token)) {
                    eqList = EqToken.listAddType(pc, eqList, aTok.nextToken());
                } else if ("IS".equalsIgnoreCase(token)) {
                    eqList = EqToken.listIsType(pc, eqList, aTok.nextToken());
                } else {
                    try {
                        temp = Integer.parseInt(token);
                    }
                    catch (NumberFormatException exc) {
                        // empty catch block
                    }
                }
                if (temp >= 0) break;
                token = aTok.nextToken();
            }
            cachedList = eqList;
            cachedString = comparatorString;
            cachedPC = pc;
            cachedSerial = pc.getSerial();
        }
        String tempString = aTok.nextToken();
        String retString = "";
        if (temp >= 0 && temp < eqList.size()) {
            Equipment eq = (Equipment)eqList.get(temp);
            retString = EqToken.getEqToken(pc, eq, tempString, aTok);
            if (!"".equals(bFilter)) {
                aTok = new StringTokenizer(bFilter, ".");
                boolean result = false;
                boolean and_operation = false;
                while (aTok.hasMoreTokens()) {
                    String bString = aTok.nextToken();
                    if ("AND".equals(bString)) {
                        and_operation = true;
                        continue;
                    }
                    if ("OR".equals(bString)) {
                        and_operation = false;
                        continue;
                    }
                    if (and_operation) {
                        result = result && eq.isType(bString);
                        continue;
                    }
                    result = result || eq.isType(bString);
                }
                retString = result ? befTrue + retString + aftTrue : befFalse + retString + aftFalse;
            }
        }
        return retString;
    }

    public static String getAcCheckToken(PlayerCharacter pc, Equipment eq) {
        return EqToken.getAcCheckTokenInt(pc, eq) + "";
    }

    public static int getAcCheckTokenInt(PlayerCharacter pc, Equipment eq) {
        return eq.acCheck(pc);
    }

    public static String getAcModToken(PlayerCharacter pc, Equipment eq) {
        return EqToken.getAcModTokenInt(pc, eq) + "";
    }

    public static int getAcModTokenInt(PlayerCharacter pc, Equipment eq) {
        return eq.getACMod(pc);
    }

    public static String getAltCritMultToken(Equipment eq) {
        return eq.getAltCritMult();
    }

    public static String getAltCritRangeToken(PlayerCharacter pc, Equipment eq) {
        return eq.getAltCritRange(pc);
    }

    public static String getAltDamageToken(PlayerCharacter pc, Equipment eq) {
        return eq.getAltDamage(pc);
    }

    public static String getAttacksToken(PlayerCharacter pc, Equipment eq) {
        return EqToken.getAttacksTokenDouble(pc, eq) + "";
    }

    public static double getAttacksTokenDouble(PlayerCharacter pc, Equipment eq) {
        return eq.bonusTo(pc, "COMBAT", "ATTACKS", true);
    }

    public static String getCarriedToken(Equipment eq) {
        return EqToken.getCarriedTokenFloat(eq) + "";
    }

    public static float getCarriedTokenFloat(Equipment eq) {
        return eq.numberCarried().floatValue();
    }

    public static String getChargesToken(Equipment eq) {
        String retString = "";
        int charges = EqToken.getChargesTokenInt(eq);
        if (charges >= 0) {
            retString = charges + "";
        }
        return retString;
    }

    public static int getChargesTokenInt(Equipment eq) {
        return eq.getRemainingCharges();
    }

    public static String getChargesUsedToken(Equipment eq) {
        String retString = "";
        int charges = EqToken.getChargesUsedTokenInt(eq);
        if (charges >= 0) {
            retString = charges + "";
        }
        return retString;
    }

    public static int getChargesUsedTokenInt(Equipment eq) {
        return eq.getUsedCharges();
    }

    public static String getContentWeightToken(PlayerCharacter pc, Equipment eq) {
        return BigDecimalHelper.trimZeros(Double.toString(EqToken.getContentWeightTokenDouble(pc, eq)));
    }

    public static double getContentWeightTokenDouble(PlayerCharacter pc, Equipment eq) {
        if (eq.getChildCount() == 0) {
            return 0.0;
        }
        return eq.getContainedWeight(pc, true).doubleValue();
    }

    public static String getContentsToken(PlayerCharacter pc, Equipment eq, StringTokenizer tokenizer) {
        if (tokenizer.hasMoreTokens()) {
            String bType = tokenizer.nextToken();
            String aSubTag = "NAME";
            if (tokenizer.hasMoreTokens()) {
                aSubTag = tokenizer.nextToken();
            }
            try {
                int contentsIndex = Integer.parseInt(bType);
                return EqToken.getEqToken(pc, eq.getContainedByIndex(contentsIndex), aSubTag, tokenizer);
            }
            catch (NumberFormatException e) {
                return eq.getContainerByType(bType, aSubTag);
            }
        }
        return EqToken.getContentsToken(eq);
    }

    public static String getContentsToken(Equipment eq) {
        return eq.getContainerContentsString();
    }

    public static String getContentsNumToken(Equipment eq) {
        return EqToken.getContentsNumTokenInt(eq) + "";
    }

    public static int getContentsNumTokenInt(Equipment eq) {
        return eq.getContents().size();
    }

    public static String getCostToken(PlayerCharacter pc, Equipment eq) {
        return BigDecimalHelper.trimZeros(eq.getCost(pc));
    }

    public static String getCritMultToken(Equipment eq) {
        return eq.getCritMult();
    }

    public static String getCritRangeToken(PlayerCharacter pc, Equipment eq) {
        return eq.getCritRange(pc);
    }

    public static String getDamageToken(PlayerCharacter pc, Equipment eq) {
        return eq.getDamage(pc);
    }

    public static String getEdrToken(PlayerCharacter pc, Equipment eq) {
        return EqToken.getEdrTokenInt(pc, eq) + "";
    }

    public static int getEdrTokenInt(PlayerCharacter pc, Equipment eq) {
        return eq.eDR(pc);
    }

    public static String getEquippedToken(Equipment eq) {
        return EqToken.getEquippedTokenBoolean(eq) ? "Y" : "N";
    }

    public static boolean getEquippedTokenBoolean(Equipment eq) {
        return eq.isEquipped();
    }

    public static String getIsTypeToken(Equipment eq, String type) {
        return EqToken.getIsTypeTokenBoolean(eq, type) ? "TRUE" : "FALSE";
    }

    public static boolean getIsTypeTokenBoolean(Equipment eq, String type) {
        return eq.isType(type);
    }

    public static String getLocationToken(Equipment eq) {
        PObject obj = (PObject)((Object)eq.getParent());
        if (obj != null) {
            return obj.getOutputName();
        }
        return eq.getParentName();
    }

    public static String getLongNameToken(Equipment eq) {
        return eq.longName();
    }

    public static String getMaxChargesToken(Equipment eq) {
        String retString = "";
        int charges = EqToken.getMaxChargesTokenInt(eq);
        if (charges >= 0) {
            retString = charges + "";
        }
        return retString;
    }

    public static int getMaxChargesTokenInt(Equipment eq) {
        return eq.getMaxCharges();
    }

    public static String getMaxDexToken(PlayerCharacter pc, Equipment eq) {
        return EqToken.getMaxDexTokenInt(pc, eq) + "";
    }

    public static int getMaxDexTokenInt(PlayerCharacter pc, Equipment eq) {
        return eq.getMaxDex(pc);
    }

    public static String getMoveToken(Equipment eq) {
        return eq.moveString();
    }

    public static String getNameToken(Equipment eq, PlayerCharacter pc) {
        return eq.parseOutputName(eq.getOutputName(), pc);
    }

    public static String getNoteToken(Equipment eq) {
        return eq.getNote();
    }

    public static String getOutputNameToken(Equipment eq, PlayerCharacter pc) {
        return EqToken.getNameToken(eq, pc);
    }

    public static String getProfToken(PlayerCharacter pc, Equipment eq) {
        return eq.profName(pc);
    }

    public static String getQtyToken(Equipment eq) {
        return BigDecimalHelper.trimZeros(Double.toString(EqToken.getQtyDoubleToken(eq)));
    }

    public static double getQtyDoubleToken(Equipment eq) {
        return eq.qty();
    }

    public static String getRangeToken(Equipment eq, PlayerCharacter pc) {
        return Globals.displayDistanceInUnitSet(Globals.convertDistanceToUnitSet(eq.getRange(pc).intValue())) + Globals.getDistanceUnit();
    }

    public static String getSizeToken(Equipment eq) {
        return eq.getSize();
    }

    public static String getSizeLongToken(Equipment eq) {
        return SystemCollections.getSizeAdjustmentAtIndex(Globals.sizeInt(eq.getSize())).getName();
    }

    public static String getSpellFailureToken(PlayerCharacter pc, Equipment eq) {
        return EqToken.getSpellFailureTokenInt(pc, eq) + "";
    }

    public static int getSpellFailureTokenInt(PlayerCharacter pc, Equipment eq) {
        return eq.spellFailure(pc);
    }

    public static String getSpropToken(PlayerCharacter pc, Equipment eq) {
        return eq.getSpecialProperties(pc);
    }

    public static String getTotalWeightToken(PlayerCharacter pc, Equipment eq) {
        return BigDecimalHelper.trimZeros(EqToken.getTotalWeightTokenDouble(pc, eq) + "");
    }

    public static double getTotalWeightTokenDouble(PlayerCharacter pc, Equipment eq) {
        return EqToken.getContentWeightTokenDouble(pc, eq) + EqToken.getWtTokenDouble(pc, eq);
    }

    public static String getTotalWtToken(PlayerCharacter pc, Equipment eq) {
        return BigDecimalHelper.trimZeros(Double.toString(EqToken.getTotalWtTokenDouble(pc, eq)));
    }

    public static double getTotalWtTokenDouble(PlayerCharacter pc, Equipment eq) {
        return eq.qty() * eq.getWeightAsDouble(pc);
    }

    public static String getTypeToken(Equipment eq) {
        return eq.getType();
    }

    public static String getTypeToken(Equipment eq, int num) {
        return eq.typeIndex(num);
    }

    public static String getWtToken(PlayerCharacter pc, Equipment eq) {
        return BigDecimalHelper.trimZeros(eq.getWeight(pc).toString());
    }

    public static double getWtTokenDouble(PlayerCharacter pc, Equipment eq) {
        return eq.getWeightAsDouble(pc);
    }

    public static List listNotType(PlayerCharacter pc, List eqList, String type) {
        return PlayerCharacter.removeEqType(eqList, type);
    }

    public static List listAddType(PlayerCharacter pc, List eqList, String type) {
        return pc.addEqType(eqList, type);
    }

    public static List listIsType(PlayerCharacter pc, List eqList, String type) {
        return PlayerCharacter.removeNotEqType(eqList, type);
    }

    protected static String getEqToken(PlayerCharacter pc, Equipment eq, String token, StringTokenizer tokenizer) {
        String retString = "";
        if ("LONGNAME".equals(token)) {
            retString = EqToken.getLongNameToken(eq);
        } else if ("NAME".equals(token) || "OUTPUTNAME".equals(token)) {
            retString = EqToken.getNameToken(eq, pc);
        } else if ("NOTE".equals(token)) {
            retString = EqToken.getNoteToken(eq);
        } else if ("WT".equals(token) || "ITEMWEIGHT".equals(token)) {
            retString = EqToken.getWtToken(pc, eq);
        } else if ("TOTALWT".equals(token)) {
            retString = EqToken.getTotalWtToken(pc, eq);
        } else if ("TOTALWEIGHT".equals(token)) {
            retString = EqToken.getTotalWeightToken(pc, eq);
        } else if ("ISTYPE".equals(token)) {
            retString = EqToken.getIsTypeToken(eq, tokenizer.nextToken());
        } else if ("CONTENTWEIGHT".equals(token)) {
            retString = EqToken.getContentWeightToken(pc, eq);
        } else if ("COST".equals(token)) {
            retString = EqToken.getCostToken(pc, eq);
        } else if ("QTY".equals(token)) {
            retString = EqToken.getQtyToken(eq);
        } else if ("EQUIPPED".equals(token)) {
            retString = EqToken.getEquippedToken(eq);
        } else if ("CARRIED".equals(token)) {
            retString = EqToken.getCarriedToken(eq);
        } else if ("CONTENTSNUM".equals(token)) {
            retString = EqToken.getContentsNumToken(eq);
        } else if ("LOCATION".equals(token)) {
            retString = EqToken.getLocationToken(eq);
        } else if ("ACMOD".equals(token)) {
            retString = EqToken.getAcModToken(pc, eq);
        } else if ("MAXDEX".equals(token)) {
            retString = EqToken.getMaxDexToken(pc, eq);
        } else if ("ACCHECK".equals(token)) {
            retString = EqToken.getAcCheckToken(pc, eq);
        } else if ("EDR".equals(token)) {
            retString = EqToken.getEdrToken(pc, eq);
        } else if ("MOVE".equals(token)) {
            retString = EqToken.getMoveToken(eq);
        } else {
            if ("TYPE".equals(token)) {
                if (tokenizer.hasMoreTokens()) {
                    try {
                        int num = Integer.parseInt(tokenizer.nextToken());
                        return EqToken.getTypeToken(eq, num);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                return EqToken.getTypeToken(eq);
            }
            if ("SPELLFAILURE".equals(token)) {
                retString = EqToken.getSpellFailureToken(pc, eq);
            } else if ("SIZE".equals(token)) {
                retString = EqToken.getSizeToken(eq);
            } else if ("SIZELONG".equals(token)) {
                retString = EqToken.getSizeLongToken(eq);
            } else if ("DAMAGE".equals(token)) {
                retString = EqToken.getDamageToken(pc, eq);
            } else if ("CRITRANGE".equals(token)) {
                retString = EqToken.getCritRangeToken(pc, eq);
            } else if ("CRITMULT".equals(token)) {
                retString = EqToken.getCritMultToken(eq);
            } else if ("ALTDAMAGE".equals(token)) {
                retString = EqToken.getAltDamageToken(pc, eq);
            } else if ("ALTCRITMULT".equals(token) || "ALTCRIT".equals(token)) {
                retString = EqToken.getAltCritMultToken(eq);
            } else if ("ALTCRITRANGE".equals(token)) {
                retString = EqToken.getAltCritRangeToken(pc, eq);
            } else if ("RANGE".equals(token)) {
                retString = EqToken.getRangeToken(eq, pc);
            } else if ("ATTACKS".equals(token)) {
                retString = EqToken.getAttacksToken(pc, eq);
            } else if ("PROF".equals(token)) {
                retString = EqToken.getProfToken(pc, eq);
            } else if ("SPROP".equals(token)) {
                retString = EqToken.getSpropToken(pc, eq);
            } else if ("CHARGES".equals(token)) {
                retString = EqToken.getChargesToken(eq);
            } else if ("CHARGESUSED".equals(token)) {
                retString = EqToken.getChargesUsedToken(eq);
            } else if ("MAXCHARGES".equals(token)) {
                retString = EqToken.getMaxChargesToken(eq);
            } else if ("CONTENTS".equals(token)) {
                retString = EqToken.getContentsToken(pc, eq, tokenizer);
            }
        }
        return retString;
    }

    protected static int returnMergeType(String type) {
        int merge = 0;
        if ("MERGENONE".equals(type)) {
            merge = 1;
        } else if ("MERGELOC".equals(type)) {
            merge = 2;
        } else if ("MERGEALL".equals(type)) {
            merge = 0;
        }
        return merge;
    }
}

