/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.EqToken;

public class EqTypeToken
extends EqToken {
    public static final String TOKENNAME = "EQTYPE";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".", false);
        aTok.nextToken();
        String token = aTok.nextToken();
        int merge = 0;
        if (token.indexOf("MERGE") >= 0) {
            merge = EqTypeToken.returnMergeType(token);
            token = aTok.nextToken();
        }
        List<Equipment> eqList = new ArrayList();
        if ("Container".equals(token)) {
            Iterator e = pc.getEquipmentListInOutputOrder(merge).iterator();
            while (e.hasNext()) {
                Equipment eq = (Equipment)e.next();
                if (!eq.acceptsChildren()) continue;
                eqList.add(eq);
            }
        } else {
            eqList = pc.getEquipmentOfTypeInOutputOrder(token, 3, merge);
        }
        int temp = -1;
        while (aTok.hasMoreTokens()) {
            if ("NOT".equalsIgnoreCase(token)) {
                eqList = EqTypeToken.listNotType(pc, eqList, aTok.nextToken());
            } else if ("ADD".equalsIgnoreCase(token)) {
                eqList = EqTypeToken.listAddType(pc, eqList, aTok.nextToken());
            } else if ("IS".equalsIgnoreCase(token)) {
                eqList = EqTypeToken.listIsType(pc, eqList, aTok.nextToken());
            } else {
                try {
                    temp = Integer.parseInt(token);
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
            }
            if (temp >= 0) break;
            token = aTok.nextToken();
        }
        String tempString = aTok.nextToken();
        if (temp >= 0 && temp < eqList.size()) {
            Equipment eq = (Equipment)eqList.get(temp);
            return EqTypeToken.getEqToken(pc, eq, tempString, aTok);
        }
        return "";
    }
}

