/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;

public class ExpToken
extends Token {
    public static final String TOKENNAME = "EXP";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        if (aTok.hasMoreTokens()) {
            String token = aTok.nextToken();
            if ("CURRENT".equals(token)) {
                retString = ExpToken.getCurrentToken(pc) + "";
            } else if ("NEXT".equals(token)) {
                retString = ExpToken.getNextToken(pc) + "";
            } else if ("FACTOR".equals(token)) {
                retString = ExpToken.getFactorToken(pc);
            } else if ("PENALTY".equals(token)) {
                retString = ExpToken.getPenaltyToken(pc);
            }
        }
        return retString;
    }

    public static int getCurrentToken(PlayerCharacter pc) {
        return pc.getXP();
    }

    public static String getFactorToken(PlayerCharacter pc) {
        StringBuffer xpFactor = new StringBuffer(5);
        xpFactor.append((int)(pc.multiclassXPMultiplier() * 100.0));
        xpFactor.append('%');
        return xpFactor.toString();
    }

    public static int getNextToken(PlayerCharacter pc) {
        return pc.minXPForNextECL();
    }

    public static String getPenaltyToken(PlayerCharacter pc) {
        StringBuffer xpFactor = new StringBuffer(5);
        xpFactor.append(100 - (int)(pc.multiclassXPMultiplier() * 100.0));
        xpFactor.append('%');
        return xpFactor.toString();
    }
}

