/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.text.DateFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;

public class ExportToken
extends Token {
    public static final String TOKENNAME = "EXPORT";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String exportString = "";
        if ("EXPORT.DATE".equals(tokenSource)) {
            exportString = ExportToken.getDateToken(tokenSource);
        } else if ("EXPORT.TIME".equals(tokenSource)) {
            exportString = ExportToken.getTimeToken(tokenSource);
        } else if ("EXPORT.VERSION".equals(tokenSource)) {
            exportString = ExportToken.getVersionToken(tokenSource);
        }
        return exportString;
    }

    public static String getDateToken(String tokenSource) {
        return DateFormat.getDateInstance().format(new Date());
    }

    public static String getTimeToken(String tokenSource) {
        return DateFormat.getTimeInstance().format(new Date());
    }

    public static String getVersionToken(String tokenSource) {
        String retString = "";
        try {
            ResourceBundle d_properties = ResourceBundle.getBundle("pcgen/gui/prop/PCGenProp");
            retString = d_properties.getString("VersionNumber");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return retString;
    }
}

