/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.awt.Dimension;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;

public class FaceToken
extends Token {
    public static final String TOKENNAME = "FACE";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String retString = "";
        if (TOKENNAME.equals(tokenSource)) {
            retString = FaceToken.getFaceToken(pc);
        } else if ("FACE.SHORT".equals(tokenSource)) {
            retString = FaceToken.getShortToken(pc);
        } else if ("FACE.1".equals(tokenSource)) {
            retString = FaceToken.get1Token(pc);
        } else if ("FACE.2".equals(tokenSource)) {
            retString = FaceToken.get2Token(pc);
        }
        return retString;
    }

    public static String getFaceToken(PlayerCharacter pc) {
        Dimension face = pc.getRace().getFace();
        String retString = "";
        retString = face.getHeight() == 0.0 ? face.getWidth() + " ft." : face.getWidth() + " ft. by " + face.getHeight() + " ft.";
        return retString;
    }

    public static String getShortToken(PlayerCharacter pc) {
        Dimension face = pc.getRace().getFace();
        String retString = "";
        retString = face.getHeight() == 0.0 ? face.getWidth() + " ft." : face.getWidth() + " x " + face.getHeight();
        return retString;
    }

    public static String get1Token(PlayerCharacter pc) {
        return pc.getRace().getFace().getWidth() + "";
    }

    public static String get2Token(PlayerCharacter pc) {
        return pc.getRace().getFace().getHeight() + "";
    }
}

