/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;

public class HPRollToken
extends Token {
    public static final String TOKENNAME = "HPROLL";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        String retString = "";
        String bString = aTok.nextToken();
        int levelOffset = Integer.valueOf(aTok.nextToken()) - 1;
        if (aTok.hasMoreTokens()) {
            bString = aTok.nextToken();
        }
        if (bString.startsWith(TOKENNAME)) {
            bString = "ROLL";
        }
        if (levelOffset >= pc.getLevelInfoSize() || levelOffset < 0) {
            return "0";
        }
        if ("ROLL".equals(bString)) {
            retString = HPRollToken.getRollToken(pc, levelOffset) + "";
        } else if ("STAT".equals(bString)) {
            retString = HPRollToken.getStatToken(pc, levelOffset) + "";
        } else if ("TOTAL".equals(bString)) {
            retString = HPRollToken.getTotalToken(pc, levelOffset) + "";
        }
        return retString;
    }

    public static int getHPRollToken(PlayerCharacter pc, int level) {
        return HPRollToken.getRollToken(pc, level);
    }

    public static int getRollToken(PlayerCharacter pc, int level) {
        int classLevel = pc.getLevelInfoClassLevel(level) - 1;
        int hpRoll = 0;
        PCClass pcClass = pc.getClassKeyed(pc.getLevelInfoClassKeyName(level));
        if (pcClass != null) {
            hpRoll = pcClass.getHitPoint(classLevel);
        }
        return hpRoll;
    }

    public static int getStatToken(PlayerCharacter pc, int level) {
        return (int)pc.getStatBonusTo("HP", "BONUS");
    }

    public static int getTotalToken(PlayerCharacter pc, int level) {
        return HPRollToken.getRollToken(pc, level) + HPRollToken.getStatToken(pc, level);
    }
}

