/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;
import pcgen.util.Delta;

public class HitDiceToken
extends Token {
    public static final String TOKENNAME = "HITDICE";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        return HitDiceToken.getHitDiceToken(pc);
    }

    public static String getHitDiceToken(PlayerCharacter pc) {
        String retString = "";
        String del = "";
        if (pc.getRace().hitDice(pc) > 0) {
            retString = retString + "(" + Integer.toString(pc.getRace().hitDice(pc)) + "d" + Integer.toString(pc.getRace().getHitDiceSize(pc)) + ")";
            del = "+";
        }
        Iterator it = pc.getClassList().iterator();
        while (it.hasNext()) {
            PCClass aClass = (PCClass)it.next();
            LinkedHashMap<Integer, Integer> hdMap = new LinkedHashMap<Integer, Integer>();
            for (int i = 0; i < aClass.getLevel(); ++i) {
                Integer hitDie = new Integer(aClass.getLevelHitDie(pc, i + 1));
                Integer num = (Integer)((HashMap)hdMap).get(hitDie);
                if (num == null) {
                    hdMap.put(hitDie, new Integer(1));
                    continue;
                }
                hdMap.put(hitDie, new Integer(num + 1));
            }
            Set keys = ((HashMap)hdMap).keySet();
            Iterator it1 = keys.iterator();
            while (it1.hasNext()) {
                Integer key = (Integer)it1.next();
                Integer value = (Integer)((HashMap)hdMap).get(key);
                retString = retString + del + "(" + value + "d" + key + ")";
                del = "+";
            }
        }
        int temp = (int)pc.getStatBonusTo("HP", "BONUS");
        int a = pc.getRace().hitDice(pc);
        int b = 0;
        b = pc.isMonsterDefault() ? pc.totalNonMonsterLevels() : pc.getTotalLevels();
        temp *= a + b;
        if ((temp += (int)pc.getTotalBonusTo("HP", "CURRENTMAX")) != 0) {
            retString = retString + Delta.toString(temp);
        }
        return retString;
    }
}

