/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;

public class LanguagesToken
extends Token {
    public static final String TOKENNAME = "LANGUAGES";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        int languageIndex = 0;
        int startIndex = 0;
        if (aTok.hasMoreTokens()) {
            try {
                startIndex = languageIndex = Integer.parseInt(aTok.nextToken());
            }
            catch (NumberFormatException e) {}
        } else {
            languageIndex = pc.getLanguagesList().size();
        }
        StringBuffer langBuf = new StringBuffer();
        for (int i = startIndex; i <= languageIndex; ++i) {
            if (i > startIndex && i < languageIndex) {
                langBuf.append(", ");
            }
            langBuf.append(LanguagesToken.getLanguagesToken(pc, i));
        }
        return langBuf.toString();
    }

    public static String getLanguagesToken(PlayerCharacter pc, int languageIndex) {
        TreeSet languageSet = pc.getLanguagesList();
        if (languageIndex >= 0 && languageIndex < languageSet.size()) {
            return languageSet.toArray()[languageIndex].toString();
        }
        return "";
    }
}

