/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.Iterator;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.io.exporttoken.Token;

public class LevelToken
extends Token {
    public static final String TOKENNAME = "LEVEL";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        int level = 1;
        if (aTok.hasMoreTokens()) {
            level = Integer.parseInt(aTok.nextToken());
        }
        PCLevelInfo pcl = null;
        Iterator i = pc.getLevelInfo().iterator();
        while (i.hasNext() && (pcl = (PCLevelInfo)i.next()).getLevel() != level) {
        }
        if (aTok.hasMoreTokens()) {
            String tokName = aTok.nextToken();
            if (tokName.equals("CLASSNAME")) {
                retString = LevelToken.getLevelClassName(pc, pcl);
            }
            if (tokName.equals("CLASSLEVEL")) {
                retString = LevelToken.getLevelClassLevel(pc, pcl);
            }
            if (tokName.equals("FEATLIST")) {
                retString = LevelToken.getLevelFeatList(pc, pcl);
            }
            if (tokName.equals("HP")) {
                retString = LevelToken.getLevelHP(pc, pcl);
            }
            if (tokName.equals("SKILLPOINTS")) {
                retString = LevelToken.getLevelSkillPoints(pc, pcl);
            }
        }
        return retString;
    }

    public static String getLevelClassName(PlayerCharacter pc, PCLevelInfo pcl) {
        return pcl.getClassKeyName();
    }

    public static String getLevelClassLevel(PlayerCharacter pc, PCLevelInfo pcl) {
        return new Integer(pcl.getLevel()).toString();
    }

    public static String getLevelFeatList(PlayerCharacter pc, PCLevelInfo pcl) {
        return "";
    }

    public static String getLevelHP(PlayerCharacter pc, PCLevelInfo pcl) {
        String classKeyName = pcl.getClassKeyName();
        PCClass aClass = pc.getClassKeyed(classKeyName);
        if (aClass == null && (aClass = Globals.getClassNamed(classKeyName)) != null) {
            aClass = pc.getClassNamed(aClass.getExClass());
        }
        if (aClass != null) {
            return aClass.getHitPoint(pcl.getLevel() - 1).toString();
        }
        return "";
    }

    public static String getLevelSkillPoints(PlayerCharacter pc, PCLevelInfo pcl) {
        return new Integer(pcl.getSkillPointsGained(false, pc)).toString();
    }
}

