/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;

public class MoveToken
extends Token {
    public static final String TOKENNAME = "MOVE";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        if (aTok.hasMoreTokens()) {
            String subToken;
            int moveIndex = Integer.parseInt(aTok.nextToken());
            retString = aTok.hasMoreTokens() ? ("NAME".equals(subToken = aTok.nextToken()) ? MoveToken.getNameToken(pc, moveIndex) : ("RATE".equals(subToken) ? MoveToken.getRateToken(pc, moveIndex) : MoveToken.getMoveToken(pc))) : MoveToken.getMoveXToken(pc, moveIndex);
        }
        return retString;
    }

    public static String getMoveToken(PlayerCharacter pc) {
        String retString = "";
        boolean firstLine = true;
        for (int i = 0; i < pc.getNumberOfMovements(); ++i) {
            if (!firstLine) {
                retString = retString + ", ";
            }
            firstLine = false;
            retString = retString + MoveToken.getMoveXToken(pc, i);
        }
        return retString;
    }

    public static String getMoveXToken(PlayerCharacter pc, int moveIndex) {
        return MoveToken.getNameToken(pc, moveIndex) + " " + MoveToken.getRateToken(pc, moveIndex);
    }

    public static String getNameToken(PlayerCharacter pc, int moveIndex) {
        return pc.getMovementType(moveIndex);
    }

    public static String getRateToken(PlayerCharacter pc, int moveIndex) {
        return Globals.displayDistanceInUnitSet(pc.movement(moveIndex)) + Globals.getDistanceUnit();
    }
}

