/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;

public class MovementToken
extends Token {
    public static final String TOKENNAME = "MOVEMENT";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        if (aTok.hasMoreTokens()) {
            String moveType = aTok.nextToken();
            retString = MovementToken.getMoveTypeToken(pc, moveType);
        } else {
            retString = MovementToken.getMovementToken(pc);
        }
        return retString;
    }

    public static String getMoveTypeToken(PlayerCharacter pc, String moveType) {
        String retString = "";
        for (int i = 0; i < pc.getNumberOfMovements(); ++i) {
            if (!pc.getMovementType(i).toUpperCase().equals(moveType.toUpperCase())) continue;
            retString = MovementToken.getRateToken(pc, i);
        }
        return retString;
    }

    public static String getMovementToken(PlayerCharacter pc) {
        String retString = "";
        boolean firstLine = true;
        for (int i = 0; i < pc.getNumberOfMovements(); ++i) {
            if (!firstLine) {
                retString = retString + ", ";
            }
            firstLine = false;
            retString = retString + pc.getMovementType(i) + " ";
            retString = retString + MovementToken.getRateToken(pc, i);
        }
        return retString;
    }

    public static String getRateToken(PlayerCharacter pc, int moveNumber) {
        return Globals.displayDistanceInUnitSet(pc.movement(moveNumber)) + Globals.getDistanceUnit();
    }
}

