/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.NoteItem;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;

public class NoteToken
extends Token {
    public static final String TOKENNAME = "NOTE";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        StringTokenizer tok = new StringTokenizer(tokenSource, ".");
        tok.nextToken();
        StringBuffer sb = new StringBuffer();
        String name = tok.nextToken();
        List noteList = NoteToken.getNoteList(pc, name);
        String beforeHeader = "<b>";
        String afterHeader = "</b><br>";
        String beforeValue = "";
        String afterValue = "<br>";
        String token = "ALL";
        if (tok.hasMoreTokens()) {
            beforeHeader = tok.nextToken();
            if ("NAME".equals(beforeHeader)) {
                token = "NAME";
                afterValue = "";
                beforeValue = "";
                afterHeader = "";
                beforeHeader = "";
                if (tok.hasMoreTokens() && !"ALL".equals(token)) {
                    beforeHeader = tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    afterHeader = tok.nextToken();
                }
            } else if ("VALUE".equals(beforeHeader)) {
                token = "VALUE";
                afterValue = "";
                beforeValue = "";
                afterHeader = "";
                beforeHeader = "";
                if (tok.hasMoreTokens()) {
                    beforeValue = tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    afterValue = tok.nextToken();
                }
            } else if ("ALL".equals(beforeHeader)) {
                token = "ALL";
                if (tok.hasMoreTokens()) {
                    beforeHeader = tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    afterHeader = tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    beforeValue = tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    afterValue = tok.nextToken();
                }
            }
        }
        for (int i = 0; i < noteList.size(); ++i) {
            NoteItem ni = (NoteItem)noteList.get(i);
            if ("ALL".equals(token)) {
                sb.append(ni.getExportString(beforeHeader, afterHeader, beforeValue, afterValue));
                continue;
            }
            if ("NAME".equals(token)) {
                sb.append(ni.getName());
                continue;
            }
            if (!"VALUE".equals(token)) continue;
            StringTokenizer cTok = new StringTokenizer(ni.getValue(), "\r\n");
            while (cTok.hasMoreTokens()) {
                sb.append(beforeValue);
                sb.append(cTok.nextToken());
                sb.append(afterValue);
            }
        }
        return sb.toString();
    }

    public static List getNoteList(PlayerCharacter pc, String name) {
        ArrayList resultList;
        block5: {
            ArrayList noteList = new ArrayList();
            NoteToken.buildSubTree(noteList, pc.getNotesList(), -1);
            if ("ALL".equals(name)) {
                resultList = noteList;
            } else {
                resultList = new ArrayList();
                try {
                    int i = Integer.parseInt(name);
                    if (i < 0 && i >= noteList.size()) break block5;
                    resultList.add(noteList.get(i));
                }
                catch (NumberFormatException e) {
                    resultList = (ArrayList)noteList.clone();
                    for (int i = resultList.size() - 1; i >= 0; --i) {
                        NoteItem ni = (NoteItem)resultList.get(i);
                        if (ni.getName().equalsIgnoreCase(name)) continue;
                        resultList.remove(i);
                    }
                }
            }
        }
        return resultList;
    }

    private static void buildSubTree(List targetList, ArrayList baseList, int parentNode) {
        Iterator baseIter = baseList.iterator();
        while (baseIter.hasNext()) {
            NoteItem note = (NoteItem)baseIter.next();
            if (note.getParentId() != parentNode && (parentNode != -1 || note.getParentId() >= 0)) continue;
            targetList.add(note);
            NoteToken.buildSubTree(targetList, baseList, note.getId());
        }
    }
}

