/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;

public class PaperInfoToken
extends Token {
    public static final String TOKENNAME = "PAPERINFO";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        return PaperInfoToken.getPaperInfoToken(tokenSource);
    }

    public static String getPaperInfoToken(String tokenSource) {
        String oString = tokenSource;
        tokenSource = tokenSource.substring(10);
        int infoType = -1;
        if (tokenSource.startsWith("NAME")) {
            infoType = 0;
        } else if (tokenSource.startsWith("HEIGHT")) {
            infoType = 1;
        } else if (tokenSource.startsWith("WIDTH")) {
            infoType = 2;
        } else if (tokenSource.startsWith("MARGIN")) {
            if ((tokenSource = tokenSource.substring(6)).startsWith("TOP")) {
                infoType = 3;
            } else if (tokenSource.startsWith("BOTTOM")) {
                infoType = 4;
            } else if (tokenSource.startsWith("LEFT")) {
                infoType = 5;
            } else if (tokenSource.startsWith("RIGHT")) {
                infoType = 6;
            }
        }
        if (infoType >= 0) {
            int offs = tokenSource.indexOf(61);
            String info = Globals.getPaperInfo(infoType);
            if (info == null) {
                if (offs >= 0) {
                    oString = tokenSource.substring(offs + 1);
                }
            } else {
                oString = info;
            }
        }
        return oString;
    }
}

