/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SpecialAbility;
import pcgen.io.exporttoken.Token;

public class RaceToken
extends Token {
    public static final String TOKENNAME = "RACE";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String retString = "";
        if (TOKENNAME.equals(tokenSource)) {
            retString = RaceToken.getRaceToken(pc);
        } else if ("RACE.ABILITYLIST".equals(tokenSource)) {
            retString = RaceToken.getAbilityListToken(pc);
        }
        return retString;
    }

    public static String getAbilityListToken(PlayerCharacter pc) {
        String retString = "";
        ArrayList saList = pc.getRace().getSpecialAbilityList();
        if (saList == null || saList.isEmpty()) {
            return "";
        }
        boolean firstLine = true;
        for (int i = 0; i < saList.size(); ++i) {
            if (!firstLine) {
                retString = retString + ", ";
            }
            firstLine = false;
            retString = retString + ((SpecialAbility)saList.get(i)).getName();
        }
        return retString;
    }

    public static String getRaceToken(PlayerCharacter pc) {
        PCClass aClass;
        String monsterClass;
        String retString = "";
        String tempRaceName = pc.getRace().getDisplayName();
        if (tempRaceName.equals("None")) {
            tempRaceName = pc.getRace().getOutputName();
        }
        StringBuffer extraRaceInfo = new StringBuffer(40);
        if (!pc.getSubRace().equals("None")) {
            extraRaceInfo.append(pc.getSubRace());
        }
        if (SettingsHandler.hideMonsterClasses() && (monsterClass = pc.getRace().getMonsterClass(pc, false)) != null && (aClass = pc.getClassNamed(monsterClass)) != null) {
            int minHD = pc.getRace().hitDice(pc) + pc.getRace().getMonsterClassLevels(pc);
            int monsterHD = pc.getRace().hitDice(pc) + aClass.getLevel();
            if (monsterHD != minHD) {
                if (extraRaceInfo.length() != 0) {
                    extraRaceInfo.append(' ');
                }
                extraRaceInfo.append(monsterHD).append("HD");
            }
        }
        retString = tempRaceName;
        if (extraRaceInfo.length() != 0) {
            retString = retString + " (" + extraRaceInfo + ')';
        }
        return retString;
    }
}

