/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import pcgen.core.PlayerCharacter;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.io.exporttoken.SkillToken;
import pcgen.util.Logging;

public class SkillLevelToken
extends SkillToken {
    public static final String TOKENNAME = "SKILLLEVEL";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        SkillToken.SkillDetails details = this.buildSkillDetails(tokenSource);
        if (details.properties.length > 0 && "TOTAL".equals(details.properties[0])) {
            try {
                int aLevelOffset = Integer.parseInt(details.skillId) - 1;
                if (aLevelOffset >= pc.getLevelInfoSize() || aLevelOffset < 0) {
                    return "0";
                }
                PCLevelInfo wLevelInfo = (PCLevelInfo)pc.getLevelInfo().get(aLevelOffset);
                int wOutput = wLevelInfo.getSkillPointsGained(pc);
                return Integer.toString(wOutput);
            }
            catch (NumberFormatException nfe) {
                Logging.errorPrint("Error replacing SKILLLEVEL." + tokenSource, nfe);
                return "";
            }
        }
        return "";
    }
}

