/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Logging;

public class SkillToken
extends Token {
    public static final String TOKENNAME = "SKILL";
    private static final int SKILL_NAME = 0;
    private static final int SKILL_TOTAL = 1;
    private static final int SKILL_RANK = 2;
    private static final int SKILL_MOD = 3;
    private static final int SKILL_ABILITY = 4;
    private static final int SKILL_ABMOD = 5;
    private static final int SKILL_MISC = 6;
    private static final int SKILL_UNTRAINED = 7;
    private static final int SKILL_EXCLUSIVE = 8;
    private static final int SKILL_UNTRAINED_EXTENDED = 9;
    private static final int SKILL_ACP = 10;
    private static final int SKILL_EXCLUSIVE_TOTAL = 11;
    private static final int SKILL_TRAINED_TOTAL = 12;
    private static final int SKILL_EXPLANATION = 13;

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        SkillDetails details = this.buildSkillDetails(tokenSource);
        Skill aSkill = this.getSkill(pc, details);
        return this.getSkillProperty(aSkill, details.properties[0], pc);
    }

    private Skill getSkill(PlayerCharacter pc, SkillDetails details) {
        Skill skill;
        block4: {
            skill = null;
            try {
                int i = Integer.parseInt(details.skillId);
                ArrayList pcSkills = pc.getSkillListInOutputOrder();
                if (i >= pcSkills.size() - 1 && ExportHandler.getExistsOnly()) {
                    ExportHandler.setNoMoreItems(true);
                }
                if (i < pcSkills.size()) {
                    skill = (Skill)pcSkills.get(i);
                }
            }
            catch (NumberFormatException exc) {
                skill = pc.getSkillNamed(details.skillId);
                if (skill != null) break block4;
                skill = Globals.getSkillNamed(details.skillId);
            }
        }
        return skill;
    }

    SkillDetails buildSkillDetails(String tokenSource) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        int numProps = 1;
        if (aTok.countTokens() > 2) {
            numProps = aTok.countTokens() - 2;
        }
        String[] props = new String[numProps];
        props[0] = "";
        String skillId = "";
        int i = 0;
        while (aTok.hasMoreTokens()) {
            if (i == 0) {
                aTok.nextToken();
            } else if (i == 1) {
                skillId = aTok.nextToken();
            } else {
                props[i - 2] = aTok.nextToken();
            }
            ++i;
        }
        return new SkillDetails(skillId, props);
    }

    String getSkillProperty(Skill aSkill, String property, PlayerCharacter pc) {
        if (aSkill == null) {
            return "";
        }
        int action = this.getPropertyId(property);
        return this.getSkillPropValue(aSkill, action, property, pc);
    }

    private int getPropertyId(String property) {
        boolean len = false;
        int cmp = 0;
        if ("NAME".equalsIgnoreCase(property)) {
            cmp = 0;
        } else if ("TOTAL".equalsIgnoreCase(property)) {
            cmp = 1;
        } else if ("RANK".equalsIgnoreCase(property)) {
            cmp = 2;
        } else if ("MOD".equalsIgnoreCase(property)) {
            cmp = 3;
        } else if ("ABILITY".equalsIgnoreCase(property)) {
            cmp = 4;
        } else if ("ABMOD".equalsIgnoreCase(property)) {
            cmp = 5;
        } else if ("MISC".equalsIgnoreCase(property)) {
            cmp = 6;
        } else if ("UNTRAINED".equalsIgnoreCase(property)) {
            cmp = 7;
        } else if ("EXCLUSIVE".equalsIgnoreCase(property)) {
            cmp = 8;
        } else if (property.toUpperCase().startsWith("UNTRAINED")) {
            cmp = 9;
        } else if (property.toUpperCase().startsWith("ACP")) {
            cmp = 10;
        } else if ("EXCLUSIVE_TOTAL".equalsIgnoreCase(property)) {
            cmp = 11;
        } else if ("TRAINED_TOTAL".equalsIgnoreCase(property)) {
            cmp = 12;
        } else if (property.toUpperCase().startsWith("EXPLAIN")) {
            cmp = 13;
        }
        return cmp;
    }

    private String getSkillPropValue(Skill aSkill, int property, String propertyText, PlayerCharacter pc) {
        StringBuffer retValue = new StringBuffer();
        if ((property == 5 || property == 6) && aSkill.getKeyStat().equals("None")) {
            retValue.append("n/a");
        } else {
            switch (property) {
                case 0: {
                    retValue.append(aSkill.qualifiedName());
                    break;
                }
                case 1: {
                    retValue.append(Integer.toString(aSkill.getTotalRank(pc).intValue() + aSkill.modifier(pc)));
                    break;
                }
                case 2: {
                    retValue.append(aSkill.getTotalRank(pc).toString());
                    break;
                }
                case 3: {
                    retValue.append(aSkill.modifier(pc).toString());
                    break;
                }
                case 4: {
                    retValue.append(aSkill.getKeyStat());
                    break;
                }
                case 5: {
                    retValue.append(Integer.toString(pc.getStatList().getStatModFor(aSkill.getKeyStat())));
                    break;
                }
                case 6: {
                    retValue.append(Integer.toString(aSkill.modifier(pc) - pc.getStatList().getStatModFor(aSkill.getKeyStat())));
                    break;
                }
                case 7: {
                    retValue.append(aSkill.getUntrained());
                    break;
                }
                case 8: {
                    retValue.append(aSkill.getExclusive());
                    break;
                }
                case 9: {
                    retValue.append(this.getUntrainedOutput(aSkill, propertyText));
                    break;
                }
                case 10: {
                    retValue.append(this.getAcpOutput(aSkill, propertyText));
                    break;
                }
                case 11: {
                    retValue.append(Integer.toString((aSkill.getExclusive().equalsIgnoreCase("Y") || aSkill.getUntrained().equalsIgnoreCase("NO")) && aSkill.getTotalRank(pc).intValue() == 0 ? 0 : aSkill.getTotalRank(pc).intValue() + aSkill.modifier(pc)));
                    break;
                }
                case 12: {
                    retValue.append(Integer.toString(aSkill.getUntrained().equalsIgnoreCase("NO") && aSkill.getTotalRank(pc).intValue() == 0 ? 0 : aSkill.getTotalRank(pc).intValue() + aSkill.modifier(pc)));
                    break;
                }
                case 13: {
                    boolean shortFrom = !"_LONG".equals(propertyText.substring(7));
                    String bonusDetails = aSkill.getModifierExplanation(pc, shortFrom);
                    retValue.append(bonusDetails);
                    break;
                }
                default: {
                    Logging.errorPrint("In ExportHandler._writeSkillProperty the cmp value " + property + " is not handled.");
                }
            }
        }
        return retValue.toString();
    }

    private String getUntrainedOutput(Skill aSkill, String property) {
        StringTokenizer aTok = new StringTokenizer(property.substring(9), ",");
        String untrained_tok = aTok.hasMoreTokens() ? aTok.nextToken() : "";
        String trained_tok = aTok.hasMoreTokens() ? aTok.nextToken() : "";
        if (aSkill.getUntrained().equalsIgnoreCase("Y")) {
            return untrained_tok;
        }
        return trained_tok;
    }

    private String getAcpOutput(Skill aSkill, String property) {
        StringTokenizer aTok = new StringTokenizer(property.substring(3), ",");
        String acp_none = aTok.hasMoreTokens() ? aTok.nextToken() : "";
        String acp_yes = aTok.hasMoreTokens() ? aTok.nextToken() : "";
        String acp_nonprof = aTok.hasMoreTokens() ? aTok.nextToken() : "";
        String acp_weight = aTok.hasMoreTokens() ? aTok.nextToken() : "";
        if (aSkill.getACheck() == 0) {
            return acp_none;
        }
        if (aSkill.getACheck() == 1) {
            return acp_yes;
        }
        if (aSkill.getACheck() == 2) {
            return acp_nonprof;
        }
        if (aSkill.getACheck() == 3) {
            return acp_weight;
        }
        return "";
    }

    final class SkillDetails {
        final String skillId;
        final String[] properties;

        SkillDetails(String inSkillId, String[] inProperties) {
            this.skillId = inSkillId;
            this.properties = inProperties;
        }
    }
}

