/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.Iterator;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.SkillToken;
import pcgen.util.Logging;

public class SkillTypeToken
extends SkillToken {
    public static final String TOKENNAME = "SKILLTYPE";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        SkillToken.SkillDetails details = this.buildSkillDetails(tokenSource);
        if (details.properties.length < 2) {
            return "";
        }
        Skill aSkill = this.getSkill(tokenSource, pc, details);
        return this.getSkillProperty(aSkill, details.properties[1], pc);
    }

    private Skill getSkill(String tokenSource, PlayerCharacter pc, SkillToken.SkillDetails details) {
        int skillIndex;
        try {
            skillIndex = Integer.parseInt(details.skillId);
        }
        catch (NumberFormatException exc) {
            Logging.errorPrint("Error replacing SKILLTYPE." + tokenSource, exc);
            return null;
        }
        ArrayList<Skill> skillSubset = new ArrayList<Skill>();
        Iterator iter = pc.getSkillListInOutputOrder().iterator();
        while (iter.hasNext()) {
            Skill bSkill = (Skill)iter.next();
            if (!bSkill.isType(details.properties[0])) continue;
            skillSubset.add(bSkill);
        }
        if (skillIndex >= skillSubset.size() - 1 && ExportHandler.getExistsOnly()) {
            ExportHandler.setNoMoreItems(true);
        }
        Skill aSkill = null;
        if (skillIndex <= skillSubset.size() - 1) {
            aSkill = (Skill)skillSubset.get(skillIndex);
        }
        return aSkill;
    }
}

