/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.Iterator;
import java.util.StringTokenizer;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.io.exporttoken.Token;

public class SkillpointsToken
extends Token {
    public static final String TOKENNAME = "SKILLPOINTS";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        String bString = aTok.nextToken();
        if (aTok.hasMoreTokens()) {
            bString = aTok.nextToken();
        }
        if (bString.startsWith(TOKENNAME)) {
            bString = "TOTAL";
        }
        float aTotalSkillPoints = 0.0f;
        if ("TOTAL".equals(bString) || "UNUSED".equals(bString)) {
            aTotalSkillPoints += (float)SkillpointsToken.getUnusedSkillPoints(pc);
        }
        if ("TOTAL".equals(bString) || "USED".equals(bString)) {
            aTotalSkillPoints += (float)SkillpointsToken.getUsedSkillPoints(pc);
        }
        return aTotalSkillPoints + "";
    }

    public static int getTotalSkillPoints(PlayerCharacter pc) {
        return SkillpointsToken.getUnusedSkillPoints(pc) + SkillpointsToken.getUsedSkillPoints(pc);
    }

    public static int getUnusedSkillPoints(PlayerCharacter pc) {
        float usedPoints = 0.0f;
        Iterator it = pc.getClassList().iterator();
        while (it.hasNext()) {
            PCClass pcClass = (PCClass)it.next();
            if (pcClass.getSkillPool(pc) <= 0) continue;
            usedPoints += (float)pcClass.getSkillPool(pc).intValue();
        }
        return (int)usedPoints;
    }

    public static int getUsedSkillPoints(PlayerCharacter pc) {
        float usedPoints = 0.0f;
        Iterator it = pc.getSkillList().iterator();
        while (it.hasNext()) {
            Skill aSkill = (Skill)it.next();
            if (!(aSkill.getRank().doubleValue() > 0.0) && aSkill.getOutputIndex() == 0) continue;
            Iterator it2 = aSkill.getRankList().iterator();
            while (it2.hasNext()) {
                String classRanks = (String)it2.next();
                int index = classRanks.indexOf(58);
                String className = classRanks.substring(0, index);
                float ranks = Float.valueOf(classRanks.substring(index + 1)).floatValue();
                PCClass pcClass = pc.getClassKeyed(className);
                usedPoints += ranks * (float)aSkill.costForPCClass(pcClass, pc).intValue();
            }
        }
        return (int)usedPoints;
    }
}

