/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.Constants;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.io.exporttoken.Token;

public class SpecialAbilityToken
extends Token {
    public static final String TOKENNAME = "SPECIALABILITY";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String subToken;
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        int i = 0;
        if (aTok.hasMoreTokens()) {
            i = Integer.parseInt(aTok.nextToken());
        }
        if (aTok.hasMoreTokens() && "DESCRIPTION".equals(subToken = aTok.nextToken())) {
            return SpecialAbilityToken.getDescriptionToken(pc, i);
        }
        return SpecialAbilityToken.getSpecialAbilityToken(pc, i);
    }

    public static String getSpecialAbilityToken(PlayerCharacter pc, int specialIndex) {
        if (specialIndex >= 0 && specialIndex < pc.getSpecialAbilityTimesList().size()) {
            return pc.getSpecialAbilityTimesList().get(specialIndex).toString();
        }
        return "";
    }

    public static String getDescriptionToken(PlayerCharacter pc, int specialIndex) {
        if (specialIndex >= 0 && specialIndex < pc.getSpecialAbilityTimesList().size() && SettingsHandler.isROG()) {
            if ("EMPTY".equals(pc.getDescriptionLst())) {
                pc.loadDescriptionFilesInDirectory("descriptions");
            }
            String description = "";
            String search = "SA:" + pc.getSpecialAbilityTimesList().get(specialIndex).toString() + Constants.s_LINE_SEP;
            int pos = pc.getDescriptionLst().indexOf(search);
            if (pos >= 0) {
                description = pc.getDescriptionLst().substring(pos + search.length());
                description = description.substring(0, description.indexOf("####") - 1).trim();
            }
            return description;
        }
        return "";
    }
}

