/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.core.CharacterDomain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellInfo;
import pcgen.core.spell.Spell;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

public class SpellMemToken
extends Token {
    public static final String TOKENNAME = "SPELLMEM";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter aPC) {
        return this.getToken(tokenSource, aPC, null);
    }

    public String getToken(String tokenSource, PlayerCharacter aPC, ExportHandler eh) {
        PObject aObject;
        StringBuffer retValue = new StringBuffer();
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        String fString = aTok.nextToken();
        int classNum = Integer.parseInt(aTok.nextToken());
        int bookNum = Integer.parseInt(aTok.nextToken());
        int spellLevel = Integer.parseInt(aTok.nextToken());
        int spellNumber = Integer.parseInt(aTok.nextToken());
        boolean found = false;
        String aLabel = "NAME";
        if (aTok.hasMoreTokens()) {
            aLabel = aTok.nextToken();
        }
        String altLabel = "";
        if (aTok.hasMoreTokens()) {
            altLabel = aTok.nextToken();
        }
        if ((aObject = aPC.getSpellClassAtIndex(classNum)) == null && ExportHandler.getExistsOnly() && classNum != -1) {
            ExportHandler.setNoMoreItems(true);
        }
        String bookName = Globals.getDefaultSpellBook();
        if (bookNum > 0) {
            bookName = (String)aPC.getSpellBooks().get(bookNum);
        }
        if (aObject != null || classNum == -1) {
            if (classNum == -1) {
                bookName = Globals.getDefaultSpellBook();
            }
            CharacterSpell cs = null;
            if (!"".equals(bookName)) {
                Spell aSpell = null;
                if (classNum == -1) {
                    ArrayList<CharacterSpell> charSpellList = new ArrayList<CharacterSpell>();
                    Iterator iClass = aPC.getClassList().iterator();
                    while (iClass.hasNext()) {
                        PCClass aClass = (PCClass)iClass.next();
                        List aList = aClass.getCharacterSpell(null, bookName, spellLevel);
                        Iterator ai = aList.iterator();
                        while (ai.hasNext()) {
                            cs = (CharacterSpell)ai.next();
                            if (charSpellList.contains(cs)) continue;
                            charSpellList.add(cs);
                        }
                    }
                    Collections.sort(charSpellList);
                    if (spellNumber < charSpellList.size()) {
                        cs = (CharacterSpell)charSpellList.get(spellNumber);
                        aSpell = cs.getSpell();
                        found = true;
                    }
                } else if (aObject != null) {
                    List charSpells = aObject.getCharacterSpell(null, bookName, spellLevel);
                    if (spellNumber < charSpells.size()) {
                        cs = (CharacterSpell)charSpells.get(spellNumber);
                        aSpell = cs.getSpell();
                        found = true;
                    }
                } else if (eh != null && eh.getInLabel() && eh.getCheckBefore()) {
                    eh.setCanWrite(false);
                }
                if (cs == null) {
                    if (ExportHandler.getExistsOnly()) {
                        ExportHandler.setNoMoreItems(true);
                    }
                    return retValue.toString();
                }
                SpellInfo si = cs.getSpellInfoFor(bookName, spellLevel, -1);
                if (found && aSpell != null && si != null) {
                    if ("NAME".equals(aLabel)) {
                        retValue.append(aSpell.getOutputName() + si.toString());
                    } else if ("OUTPUTNAME".equals(aLabel)) {
                        retValue.append(aSpell.getOutputName() + si.toString());
                    } else if ("TIMES".equals(aLabel)) {
                        if (si.getTimes() == -1) {
                            retValue.append("At Will");
                        } else {
                            retValue.append(String.valueOf(si.getTimes()));
                        }
                    } else if (aSpell != null) {
                        String sString;
                        PCClass aClass;
                        String mString;
                        if ("RANGE".equals(aLabel)) {
                            retValue.append(aPC.getSpellRange(aSpell, cs.getOwner().getName(), si));
                        } else if ("COMPONENTS".equals(aLabel)) {
                            retValue.append(aSpell.getComponentList());
                        } else if ("CASTINGTIME".equals(aLabel)) {
                            retValue.append(aSpell.getCastingTime());
                        } else if ("DC".equals(aLabel)) {
                            int dc = aSpell.getDCForPlayerCharacter(aPC, si);
                            retValue.append(String.valueOf(dc));
                        } else if ("DURATION".equals(aLabel)) {
                            mString = aPC.parseSpellString(aSpell, aSpell.getDuration(), cs.getOwner());
                            retValue.append(mString);
                        } else if ("DESC".equals(aLabel) || "EFFECT".equals(aLabel)) {
                            mString = aPC.parseSpellString(aSpell, aSpell.getDescription(), cs.getOwner());
                            retValue.append(mString);
                        } else if ("TARGET".equals(aLabel) || "EFFECTYPE".equals(aLabel)) {
                            mString = aPC.parseSpellString(aSpell, aSpell.getTarget(), cs.getOwner());
                            retValue.append(mString);
                        } else if ("SAVEINFO".equals(aLabel)) {
                            retValue.append(aSpell.getSaveInfo());
                        } else if ("SCHOOL".equals(aLabel)) {
                            retValue.append(aSpell.getSchool());
                        } else if ("SOURCELEVEL".equals(aLabel)) {
                            retValue.append(SpellMemToken.replaceTokenSpellMemSourceLevel(aSpell, aPC));
                        } else if ("SOURCE".equals(aLabel)) {
                            retValue.append(aSpell.getSource());
                        } else if ("SOURCESHORT".equals(aLabel)) {
                            retValue.append(aSpell.getSourceShort(8));
                        } else if ("SOURCEPAGE".equals(aLabel)) {
                            retValue.append(aSpell.getSourcePage());
                        } else if ("SUBSCHOOL".equals(aLabel)) {
                            retValue.append(aSpell.getSubschool());
                        } else if ("DESCRIPTOR".equals(aLabel)) {
                            retValue.append(aSpell.descriptor());
                        } else if ("FULLSCHOOL".equals(aLabel)) {
                            String aTemp = aSpell.getSchool();
                            if (aSpell.getSubschool().length() > 0 && !"NONE".equals(aSpell.getSubschool().trim().toUpperCase())) {
                                aTemp = aTemp + " (" + aSpell.getSubschool() + ')';
                            }
                            if (aSpell.descriptor().length() > 0) {
                                aTemp = aTemp + " [" + aSpell.descriptor() + ']';
                            }
                            retValue.append(aTemp);
                        } else if ("SR".equals(aLabel)) {
                            retValue.append(aSpell.getSpellResistance());
                        } else if ("CLASS".equals(aLabel)) {
                            retValue.append(aObject.getOutputName());
                        } else if ("DCSTAT".equals(aLabel)) {
                            if (aObject instanceof PCClass) {
                                aClass = (PCClass)aObject;
                                retValue.append(aClass.getSpellBaseStat());
                            }
                        } else if ("TYPE".equals(aLabel)) {
                            aClass = null;
                            if (aObject instanceof PCClass) {
                                aClass = (PCClass)aObject;
                            }
                            if (aClass != null) {
                                retValue.append(aClass.getSpellType());
                            }
                        } else if (aLabel.startsWith("DESCRIPTION")) {
                            sString = ExportHandler.getItemDescription("SPELL", aSpell.getName(), aSpell.getDescription(), aPC);
                            if (altLabel.length() > 0) {
                                retValue.append(Token.replaceWithDelimiter(sString, altLabel));
                            } else {
                                retValue.append(sString);
                            }
                        } else if (aLabel.startsWith("BONUSSPELL")) {
                            sString = "*";
                            if (aLabel.length() > 10) {
                                sString = aLabel.substring(10);
                            }
                            retValue.append(this.getBonusSpellValue(aPC, spellLevel, sString, altLabel, aObject, bookName, cs, aSpell));
                        }
                    }
                } else if (ExportHandler.getExistsOnly()) {
                    ExportHandler.setNoMoreItems(true);
                }
            } else if (ExportHandler.getExistsOnly()) {
                ExportHandler.setNoMoreItems(true);
            }
        }
        return retValue.toString();
    }

    private String getBonusSpellValue(PlayerCharacter aPC, int spellLevel, String sString, String altLabel, PObject aObject, String bookName, CharacterSpell cs, Spell aSpell) {
        ArrayList<String> dList = new ArrayList<String>();
        StringBuffer retValue = new StringBuffer();
        if (aObject != null && cs != null && cs.isSpecialtySpell() && aObject instanceof PCClass) {
            Iterator ip = aPC.getCharacterDomainList().iterator();
            while (ip.hasNext()) {
                CharacterDomain aCD = (CharacterDomain)ip.next();
                if (aCD == null || aCD.getDomain() == null || !aCD.isFromPCClass(aObject.getName())) continue;
                dList.add(aCD.getDomain().getName());
            }
            List charSpells = aObject.getCharacterSpell(aSpell, bookName, spellLevel);
            boolean isDomainOnly = true;
            Iterator e = charSpells.iterator();
            while (e.hasNext()) {
                CharacterSpell cSpell = (CharacterSpell)e.next();
                if (cSpell.isSpecialtySpell()) continue;
                isDomainOnly = false;
                break;
            }
            if (isDomainOnly) {
                retValue.append(sString);
            } else {
                retValue.append(sString + sString);
            }
        } else {
            retValue.append(altLabel);
        }
        return retValue.toString();
    }

    private static String replaceTokenSpellMemSourceLevel(Spell aSpell, PlayerCharacter aPC) {
        Map tempHash = aSpell.getLevelInfo(aPC);
        StringBuffer tempSource = new StringBuffer();
        TreeSet<String> levelSet = new TreeSet<String>();
        Iterator e = tempHash.keySet().iterator();
        while (e.hasNext()) {
            String className = (String)e.next();
            Integer classLevel = (Integer)tempHash.get(className);
            if (className.startsWith("CLASS|")) {
                if (!"ALL".equals(className = className.substring(6))) {
                    className = Globals.getClassNamed(className).getAbbrev();
                }
            } else {
                className = className.substring(7);
            }
            levelSet.add(className + classLevel.toString());
        }
        Iterator iter = levelSet.iterator();
        while (iter.hasNext()) {
            String levelString = (String)iter.next();
            if (tempSource.length() > 0) {
                tempSource.append(", ");
            }
            tempSource.append(levelString);
        }
        return tempSource.toString();
    }
}

