/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Delta;
import pcgen.util.Logging;

public class StatToken
extends Token {
    public static final String TOKENNAME = "STAT";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        int indexOfStat = Integer.parseInt(aTok.nextToken());
        if (indexOfStat < 0 || indexOfStat >= pc.getStatList().getStats().size()) {
            return "";
        }
        String findType = TOKENNAME;
        boolean useBase = false;
        boolean useLevel = false;
        int aLevel = 0;
        boolean useEquip = true;
        boolean useTemp = true;
        boolean usePost = true;
        while (aTok.hasMoreTokens()) {
            String token = aTok.nextToken();
            if ("NAME".equals(token)) {
                return StatToken.getNameToken(pc, indexOfStat);
            }
            if ("LONGNAME".equals(token)) {
                return StatToken.getLongNameToken(pc, indexOfStat);
            }
            if (TOKENNAME.equals(token)) {
                findType = TOKENNAME;
                continue;
            }
            if ("MOD".equals(token)) {
                findType = "MOD";
                continue;
            }
            if ("BASE".equals(token)) {
                useBase = true;
                continue;
            }
            if ("BASEMOD".equals(token)) {
                findType = "MOD";
                useBase = true;
                continue;
            }
            if ("NOTEMP".equals(token)) {
                useTemp = false;
                continue;
            }
            if ("NOTEMPMOD".equals(token)) {
                findType = "MOD";
                useTemp = false;
                continue;
            }
            if ("NOEQUIP".equals(token)) {
                useEquip = false;
                continue;
            }
            if ("NOPOST".equals(token)) {
                usePost = false;
                continue;
            }
            if (!"LEVEL".equals(token)) continue;
            try {
                aLevel = Integer.parseInt(aTok.nextToken());
            }
            catch (NumberFormatException nfe) {
                Logging.errorPrint("Malformed LEVEL.x tag");
            }
            useLevel = true;
        }
        retString = findType.equals("MOD") ? (useBase ? StatToken.getBaseModToken(pc, indexOfStat) : StatToken.getModToken(pc, indexOfStat, useTemp, useEquip, usePost, useLevel, aLevel)) : (useBase ? StatToken.getBaseToken(pc, indexOfStat) : StatToken.getStatToken(pc, indexOfStat, useTemp, useEquip, usePost, useLevel, aLevel));
        return retString;
    }

    public static String getStatToken(PlayerCharacter pc, int index, boolean useTemp, boolean useEquip, boolean usePost, boolean useLevel, int aLevel) {
        PCStat stat = (PCStat)pc.getStatList().getStats().get(index);
        if (pc.isNonAbility(index)) {
            return "*";
        }
        int aTotal = 0;
        aTotal = useLevel ? pc.getTotalStatAtLevel(stat.getAbb(), aLevel, usePost, useTemp) : pc.getStatList().getTotalStatFor(stat.getAbb(), useTemp);
        if (!useEquip) {
            aTotal -= (int)pc.getEquipmentBonusTo(TOKENNAME, stat.getAbb());
        }
        return aTotal + "";
    }

    public static String getModToken(PlayerCharacter pc, int index, boolean useTemp, boolean useEquip, boolean usePost, boolean useLevel, int aLevel) {
        PCStat stat = (PCStat)pc.getStatList().getStats().get(index);
        if (pc.isNonAbility(index)) {
            return "+0";
        }
        int aTotal = 0;
        aTotal = useLevel ? pc.getTotalStatAtLevel(stat.getAbb(), aLevel, usePost, useTemp) : pc.getStatList().getTotalStatFor(stat.getAbb(), useTemp);
        if (!useEquip) {
            aTotal -= (int)pc.getEquipmentBonusTo(TOKENNAME, stat.getAbb());
        }
        int temp = pc.getStatList().getModForNumber(aTotal);
        return Delta.toString(temp);
    }

    public static String getBaseToken(PlayerCharacter pc, int index) {
        PCStat stat = (PCStat)pc.getStatList().getStats().get(index);
        if (pc.isNonAbility(index)) {
            return "*";
        }
        return pc.getStatList().getBaseStatFor(stat.getAbb()) + "";
    }

    public static String getBaseModToken(PlayerCharacter pc, int index) {
        PCStat stat = (PCStat)pc.getStatList().getStats().get(index);
        if (pc.isNonAbility(index)) {
            return "+0";
        }
        int temp = pc.getStatList().getBaseStatModFor(stat.getAbb());
        return Delta.toString(temp);
    }

    public static String getNameToken(PlayerCharacter pc, int index) {
        return SettingsHandler.getGame().s_ATTRIBSHORT[index];
    }

    public static String getLongNameToken(PlayerCharacter pc, int index) {
        return SettingsHandler.getGame().s_ATTRIBLONG[index];
    }

    public static String getStatToken(PlayerCharacter pc, int index) {
        return StatToken.getStatToken(pc, index, true, true, true, false, 0);
    }

    public static String getModToken(PlayerCharacter pc, int index) {
        return StatToken.getModToken(pc, index, true, true, true, false, 0);
    }

    public static String getNoTempToken(PlayerCharacter pc, int index) {
        return StatToken.getStatToken(pc, index, true, true, true, false, 0);
    }

    public static String getNoTempModToken(PlayerCharacter pc, int index) {
        return StatToken.getModToken(pc, index, true, true, true, false, 0);
    }
}

