/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.io.exporttoken.Token;

public class TemplateToken
extends Token {
    public static final String TOKENNAME = "TEMPLATE";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String aLabel;
        PCTemplate template;
        String retString = "";
        ArrayList<PCTemplate> tl = new ArrayList<PCTemplate>();
        Iterator it = pc.getTemplateList().iterator();
        while (it.hasNext()) {
            template = (PCTemplate)it.next();
            if (template.isVisible() != 1 && template.isVisible() != 2) continue;
            tl.add(template);
        }
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        int indexOfTemplate = Integer.parseInt(aTok.nextToken());
        String string = aLabel = aTok.hasMoreTokens() ? aTok.nextToken() : "NAME";
        if (indexOfTemplate > -1 && indexOfTemplate < tl.size()) {
            template = (PCTemplate)tl.get(indexOfTemplate);
            retString = "NAME".equals(aLabel) ? TemplateToken.getNameToken(template) : ("OUTPUTNAME".equals(aLabel) ? TemplateToken.getOutputNameToken(template) : ("SA".equals(aLabel) ? TemplateToken.getSAToken(template, pc) : ("FEAT".equals(aLabel) ? TemplateToken.getFeatToken(template, pc) : ("SR".equals(aLabel) ? TemplateToken.getSRToken(template, pc) + "" : ("CR".equals(aLabel) ? TemplateToken.getCRToken(template, pc) + "" : ("DR".equals(aLabel) ? TemplateToken.getDRToken(template, pc) : TemplateToken.getModToken(pc, template, aLabel)))))));
        }
        return retString;
    }

    public static int getCRToken(PCTemplate template, PlayerCharacter pc) {
        return template.getCR(pc.getTotalLevels(), pc.totalHitDice());
    }

    public static String getDRToken(PCTemplate template, PlayerCharacter pc) {
        return template.getDR(pc.getTotalLevels(), pc.totalHitDice());
    }

    public static String getFeatToken(PCTemplate template, PlayerCharacter pc) {
        String retString = "";
        List fList = template.feats(pc.getTotalLevels(), pc.totalHitDice(), pc);
        int x = 0;
        Iterator e = fList.iterator();
        while (e.hasNext()) {
            if (x++ > 0) {
                retString = ", ";
            }
            retString = e.next().toString();
        }
        return retString;
    }

    public static String getModToken(PlayerCharacter pc, PCTemplate template, String aLabel) {
        String retString = "";
        for (int iMod = 0; iMod < SettingsHandler.getGame().s_ATTRIBSHORT.length; ++iMod) {
            String modName = SettingsHandler.getGame().s_ATTRIBSHORT[iMod] + "MOD";
            if (!aLabel.equals(modName)) continue;
            if (template.isNonAbility(iMod)) {
                retString = retString + "*";
                break;
            }
            retString = retString + template.getStatMod(iMod, pc);
            break;
        }
        return retString;
    }

    public static String getNameToken(PCTemplate template) {
        return template.toString();
    }

    public static String getOutputNameToken(PCTemplate template) {
        return template.getOutputName();
    }

    public static String getSAToken(PCTemplate template, PlayerCharacter pc) {
        String retString = "";
        List saList = template.getSpecialAbilityList(pc.getTotalLevels(), pc.totalHitDice());
        int x = 0;
        if (saList == null) {
            return "";
        }
        Iterator e = saList.iterator();
        while (e.hasNext()) {
            if (x++ > 0) {
                retString = ", ";
            }
            retString = e.next().toString();
        }
        return retString;
    }

    public static int getSRToken(PCTemplate template, PlayerCharacter pc) {
        return template.getSR(pc.getTotalLevels(), pc.totalHitDice(), pc);
    }
}

