/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Logging;

public class TotalToken
extends Token {
    public static final String TOKENNAME = "TOTAL";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String retString = "";
        if ("TOTAL.WEIGHT".equals(tokenSource)) {
            retString = TotalToken.getWeightToken(pc);
        } else if ("TOTAL.VALUE".equals(tokenSource)) {
            retString = TotalToken.getValueToken(pc);
        } else if ("TOTAL.CAPACITY".equals(tokenSource)) {
            retString = TotalToken.getCapacityToken(pc);
        } else if ("TOTAL.LOAD".equals(tokenSource)) {
            retString = TotalToken.getLoadToken(pc);
        }
        return retString;
    }

    public static String getCapacityToken(PlayerCharacter pc) {
        return Globals.maxLoadForLoadScore(pc.getVariableValue("LOADSCORE", "").intValue(), pc).toString();
    }

    public static String getLoadToken(PlayerCharacter pc) {
        int load = Globals.loadTypeForLoadScore(pc.getVariableValue("LOADSCORE", "").intValue(), pc.totalWeight(), pc);
        switch (load) {
            case 0: {
                return "Light";
            }
            case 1: {
                return "Medium";
            }
            case 2: {
                return "Heavy";
            }
            case 3: {
                return "Overload";
            }
        }
        Logging.errorPrint("Unknown load constant detected in TokenTotal.getLoadToken, the constant was " + load + ".");
        return "Unknown";
    }

    public static String getValueToken(PlayerCharacter pc) {
        return BigDecimalHelper.trimZeros(pc.totalValue()) + " " + Globals.getCurrencyDisplay();
    }

    public static String getWeightToken(PlayerCharacter pc) {
        return pc.totalWeight() + " " + Globals.getWeightUnit();
    }
}

