/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;
import pcgen.util.Delta;

public class VarToken
extends Token {
    public static final String TOKENNAME = "VAR";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        boolean isSign;
        boolean isMin = tokenSource.lastIndexOf(".MINVAL") >= 0;
        boolean isInt = tokenSource.lastIndexOf(".INTVAL") >= 0;
        boolean bl = isSign = tokenSource.lastIndexOf(".NOSIGN") < 0;
        if (isMin) {
            tokenSource = tokenSource.replaceAll(".MINVAL", "");
        }
        if (isInt) {
            tokenSource = tokenSource.replaceAll(".INTVAL", "");
        }
        if (!isSign) {
            tokenSource = tokenSource.replaceAll(".NOSIGN", "");
        }
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        String varName = "";
        if (aTok.hasMoreElements()) {
            varName = aTok.nextToken();
        }
        while (aTok.hasMoreElements()) {
            varName = varName + "." + aTok.nextToken();
        }
        if (isInt) {
            if (isSign) {
                return Delta.toString(VarToken.getIntVarToken(pc, varName, isMin));
            }
            return VarToken.getIntVarToken(pc, varName, isMin) + "";
        }
        if (isSign) {
            return Delta.toString(VarToken.getVarToken(pc, varName, isMin));
        }
        return VarToken.getVarToken(pc, varName, isMin) + "";
    }

    public static float getVarToken(PlayerCharacter pc, String varName, boolean isMin) {
        return pc.getVariable(varName, !isMin, true, "", "").floatValue();
    }

    public static int getIntVarToken(PlayerCharacter pc, String varName, boolean isMin) {
        return pc.getVariable(varName, !isMin, true, "", "").intValue();
    }
}

