/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.WeaponProf;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.ReachToken;
import pcgen.io.exporttoken.Token;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Delta;
import pcgen.util.Logging;

public class WeaponToken
extends Token {
    public static final String TOKENNAME = "WEAPON";
    public static final int WPTYPEBONUS_PC = 0;
    public static final int WPTYPEBONUS_EQ = 1;
    public static final int WPTYPEBONUS_FEAT = 2;
    public static final int WPTYPEBONUS_TEMPLATE = 3;
    public static final int DAMAGEMODE_NORMAL = 0;
    public static final int DAMAGEMODE_BASIC = 1;
    public static final int DAMAGEMODE_OFFHAND = 2;
    public static final int DAMAGEMODE_TWOHANDS = 3;
    public static final int DAMAGEMODE_DOUBLE = 4;
    public static final int HITMODE_TOTALHIT = 0;
    public static final int HITMODE_BASEHIT = 1;
    public static final int HITMODE_TWPHITH = 2;
    public static final int HITMODE_TWPHITL = 3;
    public static final int HITMODE_TWOHIT = 4;
    public static final int HITMODE_TWFOHH = 4;
    public static final int HITMODE_TWFOHL = 5;
    public static final int HITMODE_OHHIT = 6;
    public static final int HITMODE_THHIT = 7;

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        return this.getToken(tokenSource, pc, null);
    }

    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".", false);
        aTok.nextToken();
        int merge = 0;
        int weapon = 0;
        String token = aTok.nextToken();
        if (token.equals("MERGENONE")) {
            merge = 1;
            token = aTok.nextToken();
        } else if (token.equals("MERGELOC")) {
            merge = 2;
            token = aTok.nextToken();
        } else if (token.equals("MERGEALL")) {
            merge = 0;
            token = aTok.nextToken();
        }
        List weaponList = pc.getExpandedWeapons(merge);
        if (token.equals("ALL")) {
            token = aTok.nextToken();
        } else if (token.equals("EQUIPPED")) {
            Iterator it = weaponList.iterator();
            while (it.hasNext()) {
                if (((Equipment)it.next()).isEquipped()) continue;
                it.remove();
            }
            token = aTok.nextToken();
        } else if (token.equals("NOT_EQUIPPED")) {
            Iterator it = weaponList.iterator();
            while (it.hasNext()) {
                if (!((Equipment)it.next()).isEquipped()) continue;
                it.remove();
            }
            token = aTok.nextToken();
        } else if (token.equals("CARRIED")) {
            Iterator it = weaponList.iterator();
            while (it.hasNext()) {
                if (((Equipment)it.next()).numberCarried().intValue() != 0) continue;
                it.remove();
            }
            token = aTok.nextToken();
        } else if (token.equals("NOT_CARRIED")) {
            Iterator it = weaponList.iterator();
            while (it.hasNext()) {
                if (((Equipment)it.next()).numberCarried().intValue() <= 0) continue;
                it.remove();
            }
            token = aTok.nextToken();
        }
        weapon = WeaponToken.getIntToken(token, 0);
        if (weapon < weaponList.size()) {
            Equipment eq = (Equipment)weaponList.get(weapon);
            return this.getWeaponToken(pc, eq, aTok);
        }
        if (ExportHandler.getExistsOnly()) {
            ExportHandler.setNoMoreItems(true);
            if (eh != null && eh.getCheckBefore()) {
                eh.setCanWrite(false);
            }
        }
        return "";
    }

    public String getWeaponToken(PlayerCharacter pc, Equipment eq, StringTokenizer aTok) {
        String token = "";
        if (aTok.hasMoreTokens()) {
            token = aTok.nextToken();
        }
        int range = -1;
        int content = -1;
        int ammo = -1;
        if (token.equals("RANGELIST")) {
            range = WeaponToken.getIntToken(aTok, -1);
            token = aTok.hasMoreTokens() ? aTok.nextToken() : "RANGELIST";
        }
        if (token.equals("CONTENTS")) {
            if (aTok.hasMoreTokens()) {
                content = WeaponToken.getIntToken(aTok, -1);
                token = aTok.hasMoreTokens() ? aTok.nextToken() : "CONTENTS";
            } else {
                token = "CONTENTSCOUNT";
            }
        }
        if (token.equals("AMMUNITION")) {
            if (aTok.hasMoreTokens()) {
                ammo = WeaponToken.getIntToken(aTok, -1);
                token = aTok.hasMoreTokens() ? aTok.nextToken() : "AMMUNITION";
            } else {
                token = "AMMUNITIONCOUNT";
            }
        }
        if (token.equals("NAME")) {
            boolean star = true;
            if (aTok.hasMoreTokens() && "NOSTAR".equals(aTok.nextToken())) {
                star = false;
            }
            return WeaponToken.getNameToken(eq, pc, star);
        }
        if (token.equals("OUTPUTNAME")) {
            return WeaponToken.getOutputNameToken(eq, pc);
        }
        if (token.equals("LONGNAME")) {
            return WeaponToken.getLongNameToken(eq);
        }
        if (token.equals("ATTACKS")) {
            return WeaponToken.getAttacksToken(pc, eq) + "";
        }
        if (token.equals("AMMUNITIONCOUNT")) {
            return WeaponToken.getAmmunitionCountToken(pc, eq) + "";
        }
        if (token.equals("AMMUNITION")) {
            return WeaponToken.getAmmunitionToken(pc, eq, ammo);
        }
        if (token.equals("CONTENTSCOUNT")) {
            return WeaponToken.getContentsCountToken(eq) + "";
        }
        if (token.equals("CONTENTS")) {
            return WeaponToken.getContentsToken(eq, content);
        }
        if (token.equals("NUMATTACKS")) {
            return WeaponToken.getNumAttacksToken(pc, eq) + "";
        }
        if (token.equals("HEFT")) {
            return WeaponToken.getHeft(pc, eq);
        }
        if (token.equals("ISTYPE")) {
            if (aTok.hasMoreTokens()) {
                return WeaponToken.getIsTypeToken(eq, aTok.nextToken());
            }
            return "";
        }
        if (token.equals("CRIT")) {
            return WeaponToken.getCritToken(pc, eq);
        }
        if (token.equals("MULT")) {
            return WeaponToken.getMultToken(pc, eq);
        }
        if (token.equals("RANGELIST")) {
            return WeaponToken.getRangeListToken(eq, range, pc);
        }
        if (token.equals("RANGE")) {
            boolean units = true;
            if (aTok.hasMoreTokens() && "NOUNITS".equals(aTok.nextToken())) {
                units = false;
            }
            return WeaponToken.getRangeToken(eq, pc, units);
        }
        if (token.equals("SIZEMOD")) {
            return Delta.toString(WeaponToken.getSizeModToken(pc));
        }
        if (token.equals("TYPE")) {
            return WeaponToken.getTypeToken(eq);
        }
        if (token.equals("HIT") || token.equals("TOTALHIT")) {
            int attack = WeaponToken.getIntToken(aTok, -1);
            return WeaponToken.getTotalHitToken(pc, eq, range, content, ammo, attack);
        }
        if (token.equals("BASEHIT")) {
            int attack = WeaponToken.getIntToken(aTok, -1);
            return WeaponToken.getBaseHitToken(pc, eq, range, content, ammo, attack);
        }
        if (token.equals("TWPHITH")) {
            int attack = WeaponToken.getIntToken(aTok, -1);
            return WeaponToken.getTwpHitHToken(pc, eq, range, content, ammo, attack);
        }
        if (token.equals("TWPHITL")) {
            int attack = WeaponToken.getIntToken(aTok, -1);
            return WeaponToken.getTwpHitLToken(pc, eq, range, content, ammo, attack);
        }
        if (token.equals("TWOHIT")) {
            int attack = WeaponToken.getIntToken(aTok, -1);
            return WeaponToken.getTwoHitToken(pc, eq, range, content, ammo, attack);
        }
        if (token.equals("OHHIT")) {
            int attack = WeaponToken.getIntToken(aTok, -1);
            return WeaponToken.getOHHitToken(pc, eq, range, content, ammo, attack);
        }
        if (token.equals("THHIT")) {
            int attack = WeaponToken.getIntToken(aTok, -1);
            return WeaponToken.getTHHitToken(pc, eq, range, content, ammo, attack);
        }
        if (token.equals("CATEGORY")) {
            return WeaponToken.getCategoryToken(eq);
        }
        if (token.equals("HAND")) {
            return WeaponToken.getHandToken(eq);
        }
        if (token.equals("MAGICDAMAGE")) {
            return Delta.toString(WeaponToken.getMagicDamageToken(pc, eq));
        }
        if (token.equals("MAGICHIT")) {
            return Delta.toString(WeaponToken.getMagicHitToken(pc, eq));
        }
        if (token.equals("MISC")) {
            return Delta.toString(WeaponToken.getMiscToken(pc, eq));
        }
        if (token.equals("FEATDAMAGE")) {
            Delta.toString(WeaponToken.getFeatDamageToken(pc, eq));
        } else if (token.equals("FEATHIT")) {
            Delta.toString(WeaponToken.getFeatHitToken(pc, eq));
        } else if (token.equals("TEMPLATEDAMAGE")) {
            Delta.toString(WeaponToken.getTemplateDamageToken(pc, eq));
        } else if (token.equals("TEMPLATEHIT")) {
            Delta.toString(WeaponToken.getTemplateHitToken(pc, eq));
        } else {
            if (token.equals("DAMAGE")) {
                return WeaponToken.getDamageToken(pc, eq, range, content, ammo, false, false);
            }
            if (token.equals("BASEDAMAGE")) {
                return WeaponToken.getDamageToken(pc, eq, range, content, ammo, false, true);
            }
            if (token.equals("BASICDAMAGE")) {
                return WeaponToken.getBasicDamageToken(pc, eq, range, content, ammo, false);
            }
            if (token.equals("THDAMAGE")) {
                return WeaponToken.getTHDamageToken(pc, eq, range, content, ammo, false);
            }
            if (token.equals("OHDAMAGE")) {
                return WeaponToken.getOHDamageToken(pc, eq, range, content, ammo, false);
            }
            if (token.equals("DAMAGEBONUS") || token.equals("BONUSDAMAGE")) {
                return WeaponToken.getDamageToken(pc, eq, range, content, ammo, true, false);
            }
            if (token.equals("BASEDAMAGEBONUS")) {
                return WeaponToken.getDamageToken(pc, eq, range, content, ammo, true, true);
            }
            if (token.equals("THDAMAGEBONUS")) {
                return WeaponToken.getTHDamageToken(pc, eq, range, content, ammo, true);
            }
            if (token.equals("OHDAMAGEBONUS")) {
                return WeaponToken.getOHDamageToken(pc, eq, range, content, ammo, true);
            }
            if (token.equals("SIZE")) {
                return WeaponToken.getSizeToken(eq);
            }
            if (token.equals("SPROP")) {
                return WeaponToken.getSpropToken(pc, eq, content, ammo);
            }
            if (token.equals("REACH")) {
                return WeaponToken.getReachToken(pc, eq) + "";
            }
            if (token.equals("WT")) {
                return WeaponToken.getWTToken(pc, eq);
            }
            if (token.equals("RATEOFFIRE")) {
                return WeaponToken.getRateOfFireToken(eq);
            }
            if (token.equals("ISLIGHT")) {
                return WeaponToken.getIsLightToken(pc, eq);
            }
        }
        return "";
    }

    public static String getNameToken(Equipment eq, PlayerCharacter pc) {
        return WeaponToken.getNameToken(eq, pc, false);
    }

    public static String getIsLightToken(PlayerCharacter pc, Equipment eq) {
        return Globals.isWeaponLightForPC(pc, eq) ? "TRUE" : "FALSE";
    }

    public static String getNameToken(Equipment eq, PlayerCharacter pc, boolean star) {
        StringBuffer sb = new StringBuffer();
        if (eq.isEquipped() && star) {
            sb.append("*");
        }
        sb.append(eq.parseOutputName(eq.getOutputName(), pc));
        sb.append(eq.getAppliedName());
        return sb.toString();
    }

    public static String getOutputNameToken(Equipment eq, PlayerCharacter pc) {
        StringBuffer sb = new StringBuffer();
        if (eq.isEquipped()) {
            sb.append("*");
        }
        sb.append(eq.parseOutputName(eq.getOutputName(), pc));
        sb.append(eq.getAppliedName());
        return sb.toString();
    }

    public static String getLongNameToken(Equipment eq) {
        StringBuffer sb = new StringBuffer();
        if (eq.isEquipped()) {
            sb.append("*");
        }
        sb.append(eq.longName());
        sb.append(eq.getAppliedName());
        return sb.toString();
    }

    public static int getAttacksToken(PlayerCharacter pc, Equipment eq) {
        return (int)eq.bonusTo(pc, TOKENNAME, "ATTACKS", true);
    }

    public static int getAmmunitionCountToken(PlayerCharacter pc, Equipment eq) {
        int ammoCount = 0;
        String containerCapacity = eq.getContainerCapacityString();
        Iterator e = pc.getEquipmentListInOutputOrder().iterator();
        block0: while (e.hasNext()) {
            Equipment anEquip = (Equipment)e.next();
            Iterator e2 = anEquip.typeList().iterator();
            while (e2.hasNext()) {
                if (containerCapacity.indexOf(e2.next().toString()) < 0) continue;
                ++ammoCount;
                continue block0;
            }
        }
        return ammoCount;
    }

    public static String getAmmunitionToken(PlayerCharacter pc, Equipment eq, int ammo) {
        Equipment ammoUser = WeaponToken.getAmmoUser(pc, eq, ammo);
        if (ammoUser != null) {
            return ammoUser.getName();
        }
        return "";
    }

    public static int getContentsCountToken(Equipment eq) {
        return eq.getContainedEquipmentCount();
    }

    public static String getContentsToken(Equipment eq, int content) {
        if (content > -1 && content < eq.getContainedEquipmentCount()) {
            return eq.getContainedEquipment(content).getName();
        }
        return "";
    }

    public static String getHeft(PlayerCharacter pc, Equipment eq) {
        String retString = "";
        retString = pc.sizeInt() > Globals.sizeInt(eq.getSize()) ? "LIGHT" : (pc.sizeInt() == Globals.sizeInt(eq.getSize()) ? "MEDIUM" : "HEAVY");
        return retString;
    }

    public static String getIsTypeToken(Equipment eq, String type) {
        return WeaponToken.isTypeToken(eq, type) ? "TRUE" : "FALSE";
    }

    public static boolean isTypeToken(Equipment eq, String type) {
        return eq.isType(type);
    }

    public static String getMultToken(PlayerCharacter pc, Equipment eq) {
        int critMult;
        StringBuffer sb = new StringBuffer();
        boolean isDouble = eq.isDouble() && eq.getLocation() == 4;
        int mult = (int)pc.getTotalBonusTo("WEAPONPROF=" + eq.profName(pc), "CRITMULTADD") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "CRITMULTADD", 0);
        try {
            critMult = Integer.parseInt(eq.getCritMult().substring(1));
        }
        catch (Exception e) {
            critMult = 0;
        }
        sb.append(critMult + mult + "");
        int altCrit = eq.getAltCritMultiplier();
        if (isDouble && altCrit > 0) {
            sb.append("/" + (altCrit + mult));
        }
        return sb.toString();
    }

    public static String getRangeListToken(Equipment eq, int range, PlayerCharacter aPC) {
        List rangeList = eq.getRangeList(true, aPC);
        if (range < rangeList.size()) {
            return Globals.displayDistanceInUnitSet(Globals.convertDistanceToUnitSet(Integer.parseInt(rangeList.get(range).toString()))) + Globals.getDistanceUnit();
        }
        return "";
    }

    public static String getRangeToken(Equipment eq, PlayerCharacter pc, boolean units) {
        StringBuffer sb = new StringBuffer();
        sb.append(Globals.displayDistanceInUnitSet(Globals.convertDistanceToUnitSet(eq.getRange(pc).intValue())));
        if (units) {
            sb.append(Globals.getDistanceUnit());
        }
        return sb.toString();
    }

    public static int getSizeModToken(PlayerCharacter pc) {
        return (int)pc.getSizeAdjustmentBonusTo("TOHIT", "TOHIT");
    }

    public static String getCategoryToken(Equipment eq) {
        StringBuffer sb = new StringBuffer();
        sb.append(WeaponToken.weaponCategories(eq));
        sb.append("-");
        if (eq.isNatural()) {
            sb.append("Natural");
        } else if (eq.isType("Both")) {
            if (eq.isMelee()) {
                sb.append("Both (Melee)");
            } else if (eq.isRanged()) {
                sb.append("Both (Ranged)");
            }
        } else if (eq.isMelee()) {
            sb.append("Melee");
        } else if (eq.isRanged()) {
            sb.append("Ranged");
        } else {
            sb.append("Non-Standard");
        }
        return sb.toString();
    }

    public static String getTypeToken(Equipment eq) {
        String types = WeaponToken.weaponTypes(eq, true);
        if (eq.isDouble()) {
            types = types + '/' + WeaponToken.weaponTypes(eq, false);
        }
        return types;
    }

    public static String getHandToken(Equipment eq) {
        String location = Equipment.getLocationName(eq.getLocation());
        return location.replaceAll(".*\\(", "").replaceAll("\\(.*", "").replaceAll("\\).*", "");
    }

    public static int getMagicDamageToken(PlayerCharacter pc, Equipment eq) {
        int magicdamage = eq.getBonusToDamage(pc, true) + (int)eq.bonusTo("WEAPONPROF=" + eq.profName(pc), "DAMAGE", pc, pc) + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "DAMAGE", 1);
        return magicdamage;
    }

    public static int getMagicHitToken(PlayerCharacter pc, Equipment eq) {
        int magichit = eq.getBonusToHit(pc, true) + (int)eq.bonusTo("WEAPONPROF=" + eq.profName(pc), "TOHIT", pc, pc) + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "TOHIT", 1);
        return magichit;
    }

    public static int getMiscToken(PlayerCharacter pc, Equipment eq) {
        int miscBonus = (int)pc.getTotalBonusTo("WEAPONPROF=" + eq.profName(pc), "TOHIT") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "TOHIT", 0) - (int)pc.getStatBonusTo("TOHIT", "TYPE.MELEE") - (int)pc.getSizeAdjustmentBonusTo("TOHIT", "TOHIT");
        return miscBonus;
    }

    public static int getFeatDamageToken(PlayerCharacter pc, Equipment eq) {
        int featBonus = (int)pc.getFeatBonusTo(TOKENNAME, "DAMAGE", true) - (int)pc.getFeatBonusTo(TOKENNAME, "DAMAGE-SHORTRANGE", true) + (int)pc.getFeatBonusTo("WEAPONPROF=" + eq.profName(pc), "DAMAGE", true) + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "DAMAGE", 2);
        return featBonus;
    }

    public static int getFeatHitToken(PlayerCharacter pc, Equipment eq) {
        int featBonus = (int)pc.getFeatBonusTo(TOKENNAME, "TOHIT", true) + (int)pc.getFeatBonusTo("WEAPONPROF=" + eq.profName(pc), "TOHIT", true) + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "TOHIT", 2);
        return featBonus;
    }

    public static int getTemplateDamageToken(PlayerCharacter pc, Equipment eq) {
        int templateBonus = (int)pc.getTemplateBonusTo(TOKENNAME, "DAMAGE", true) + (int)pc.getTemplateBonusTo("WEAPONPROF=" + eq.profName(pc), "DAMAGE", true) + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "DAMAGE", 3);
        return templateBonus;
    }

    public static int getTemplateHitToken(PlayerCharacter pc, Equipment eq) {
        int templateBonus = (int)pc.getTemplateBonusTo(TOKENNAME, "TOHIT", true) + (int)pc.getTemplateBonusTo("WEAPONPROF=" + eq.profName(pc), "TOHIT", true) + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "TOHIT", 3);
        return templateBonus;
    }

    public static String getSizeToken(Equipment eq) {
        return eq.getSize();
    }

    public static String getSpropToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getSpropToken(pc, eq, -1, -1);
    }

    public static String getSpropToken(PlayerCharacter pc, Equipment eq, int content, int ammo) {
        String sprop = eq.getSpecialProperties(pc);
        if (content > -1) {
            sprop = "";
            if (content < eq.getContainedEquipmentCount() && !"".equals(eq.getContainedEquipment(content).getSpecialProperties(pc))) {
                sprop = eq.getContainedEquipment(content).getSpecialProperties(pc);
            }
        }
        int ammoCount = 0;
        Equipment anEquip = null;
        String containerCapacity = eq.getContainerCapacityString();
        Iterator e = pc.getEquipmentListInOutputOrder().iterator();
        while (e.hasNext() && ammo >= 0) {
            sprop = "";
            anEquip = (Equipment)e.next();
            Iterator e2 = anEquip.typeList().iterator();
            while (e2.hasNext()) {
                if (containerCapacity.indexOf(e2.next().toString()) < 0) continue;
                ++ammoCount;
                break;
            }
            if (ammoCount != ammo + 1) continue;
        }
        if (anEquip != null && ammoCount > 0 && !"".equals(anEquip.getSpecialProperties(pc))) {
            sprop = anEquip.getSpecialProperties(pc);
        }
        if (sprop.startsWith(", ")) {
            sprop = sprop.substring(2);
        }
        return sprop;
    }

    public static int getReachToken(PlayerCharacter pc, Equipment eq) {
        return ReachToken.getReachToken(pc) + eq.getReach();
    }

    public static String getWTToken(PlayerCharacter pc, Equipment eq) {
        return BigDecimalHelper.trimZeros(eq.getWeight(pc).toString());
    }

    public static String getRateOfFireToken(Equipment eq) {
        return eq.getRateOfFire();
    }

    public static int getNumAttacksToken(PlayerCharacter pc, Equipment eq) {
        String melee = WeaponToken.getMeleeAttackString(pc);
        String unarmed = WeaponToken.getUnarmedAttackString(pc);
        String ranged = WeaponToken.getRangedAttackString(pc);
        String weaponString = melee;
        if (eq.isRanged()) {
            weaponString = ranged;
        }
        if (eq.isMonk()) {
            if (unarmed.length() > melee.length()) {
                weaponString = unarmed;
            } else if (unarmed.length() == melee.length() && !melee.equals(unarmed)) {
                StringTokenizer mTok = new StringTokenizer(melee, "+/", false);
                StringTokenizer uTok = new StringTokenizer(unarmed, "+/", false);
                String msString = mTok.nextToken();
                String usString = uTok.nextToken();
                if (Integer.parseInt(usString) >= Integer.parseInt(msString)) {
                    weaponString = unarmed;
                }
            }
        }
        StringTokenizer bTok = new StringTokenizer(weaponString, "/");
        int extra_attacks = (int)eq.bonusTo(pc, TOKENNAME, "ATTACKS", true);
        return bTok.countTokens() + extra_attacks;
    }

    public static String getCritToken(PlayerCharacter pc, Equipment eq) {
        StringBuffer sb = new StringBuffer();
        boolean isDouble = eq.isDouble() && eq.getLocation() == 4;
        int rawCritRange = eq.getRawCritRange();
        if (rawCritRange == 0) {
            return "none";
        }
        int dbl = (int)pc.getTotalBonusTo("WEAPONPROF=" + eq.profName(pc), "CRITRANGEDOUBLE") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "CRITRANGEDOUBLE", 0);
        int iAdd = (int)pc.getTotalBonusTo("WEAPONPROF=" + eq.profName(pc), "CRITRANGEADD") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "CRITRANGEADD", 0);
        int eqDbl = eq.getCritRangeDouble(pc, true) + dbl;
        int critrange = eq.getRawCritRange() * (eqDbl + 1);
        critrange = 21 - (critrange + iAdd + eq.getCritRangeAdd(pc, true));
        sb.append(critrange + "");
        if (critrange < 20) {
            sb.append("-20");
        }
        if (isDouble && eq.getAltCritRange(pc).length() > 0) {
            eqDbl = eq.getCritRangeDouble(pc, false) + dbl;
            int altCritRange = eq.getRawCritRange(false) * (eqDbl + 1);
            if ((altCritRange = 21 - (altCritRange + iAdd + eq.getCritRangeAdd(pc, false))) != critrange) {
                sb.append("/" + altCritRange);
                if (altCritRange < 20) {
                    sb.append("-20");
                }
            }
        }
        return sb.toString();
    }

    public static String getDamageToken(PlayerCharacter pc, Equipment eq, boolean bonusOnly, boolean base) {
        return WeaponToken.getDamageToken(pc, eq, -1, -1, -1, bonusOnly, base);
    }

    public static String getDamageToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, boolean bonusOnly, boolean base) {
        boolean isDouble = eq.isDouble() && eq.getLocation() == 4;
        boolean isDoubleSplit = eq.isType("Head1") || eq.isType("Head2");
        WeaponProf wp = Globals.getWeaponProfNamed(eq.profName(pc));
        int damageMode = 0;
        int hands = 1;
        int wpHands = 1;
        if (eq.isNatural() && eq.getLocation() == 2) {
            damageMode = 2;
            hands = 0;
        } else if (eq.isUnarmed()) {
            damageMode = 1;
        } else if (isDouble && !isDoubleSplit) {
            damageMode = 4;
            hands = 1;
        } else if (isDoubleSplit && Globals.isWeaponTwoHanded(pc, eq, wp)) {
            damageMode = 3;
            hands = 2;
            wpHands = 2;
        } else if (pc.isSecondaryWeapon(eq)) {
            damageMode = 2;
            hands = 0;
        } else if (pc.isPrimaryWeapon(eq)) {
            if (eq.getLocation() == 3) {
                damageMode = 3;
                hands = 2;
                wpHands = 2;
            } else {
                damageMode = 1;
            }
        } else if (Globals.isWeaponTwoHanded(pc, eq, wp)) {
            damageMode = 3;
            hands = 2;
            wpHands = 2;
        } else {
            damageMode = 1;
        }
        String profName = WeaponToken.getRealProf(pc, eq, eq.profName(pc), wpHands);
        return WeaponToken.getDamage(pc, eq, profName, range, content, ammo, bonusOnly, hands, damageMode, base);
    }

    public static String getBasicDamageToken(PlayerCharacter pc, Equipment eq, boolean bonusOnly) {
        return WeaponToken.getBasicDamageToken(pc, eq, -1, -1, -1, bonusOnly);
    }

    public static String getBasicDamageToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, boolean bonusOnly) {
        int damageMode = 1;
        int hands = 1;
        String profName = WeaponToken.getRealProf(pc, eq, eq.profName(pc), hands);
        return WeaponToken.getDamage(pc, eq, profName, range, content, ammo, bonusOnly, hands, damageMode, false);
    }

    public static String getTHDamageToken(PlayerCharacter pc, Equipment eq, boolean bonusOnly) {
        return WeaponToken.getTHDamageToken(pc, eq, -1, -1, -1, bonusOnly);
    }

    public static String getTHDamageToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, boolean bonusOnly) {
        int damageMode = 3;
        int hands = 2;
        String profName = WeaponToken.getRealProf(pc, eq, eq.profName(pc), hands);
        return WeaponToken.getDamage(pc, eq, profName, range, content, ammo, bonusOnly, hands, damageMode, false);
    }

    public static String getOHDamageToken(PlayerCharacter pc, Equipment eq, boolean bonusOnly) {
        return WeaponToken.getOHDamageToken(pc, eq, -1, -1, -1, bonusOnly);
    }

    public static String getOHDamageToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, boolean bonusOnly) {
        int damageMode = 2;
        int hands = 0;
        String profName = WeaponToken.getRealProf(pc, eq, eq.profName(pc), hands);
        return WeaponToken.getDamage(pc, eq, profName, range, content, ammo, bonusOnly, hands, damageMode, false);
    }

    public static String getTotalHitToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getTotalHitToken(pc, eq, -1, -1, -1, -1);
    }

    public static String getTotalHitToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, int attackNum) {
        boolean isDouble = eq.isDouble() && eq.getLocation() == 4;
        boolean isDoubleSplit = eq.isType("Head1") || eq.isType("Head2");
        int hitModeHands = 1;
        int hitMode = 0;
        WeaponProf wp = Globals.getWeaponProfNamed(eq.profName(pc));
        if (eq.isUnarmed()) {
            hitMode = 1;
        } else if (isDouble && !isDoubleSplit) {
            hitMode = 4;
        } else if (!isDouble && isDoubleSplit) {
            hitMode = 7;
            hitModeHands = 2;
        } else if (!pc.getPrimaryWeapons().isEmpty() && !pc.getSecondaryWeapons().isEmpty()) {
            if (pc.isPrimaryWeapon(eq)) {
                Equipment sEq = (Equipment)pc.getSecondaryWeapons().get(0);
                hitMode = sEq == null ? 3 : (Globals.isWeaponLightForPC(pc, sEq) ? 3 : 2);
            } else if (pc.isSecondaryWeapon(eq)) {
                hitMode = Globals.isWeaponLightForPC(pc, eq) ? 5 : 4;
            }
        } else if (pc.isSecondaryWeapon(eq) && pc.getPrimaryWeapons().isEmpty()) {
            hitMode = 6;
        } else if (pc.isPrimaryWeapon(eq) && pc.getSecondaryWeapons().isEmpty()) {
            if (eq.getLocation() == 3) {
                hitMode = 7;
                hitModeHands = 2;
            } else {
                hitMode = 1;
            }
        } else if (Globals.isWeaponTwoHanded(pc, eq, wp)) {
            hitMode = 7;
            hitModeHands = 2;
        } else {
            hitMode = 1;
        }
        String profName = WeaponToken.getRealProf(pc, eq, eq.profName(pc), hitModeHands);
        return WeaponToken.getToHit(pc, eq, profName, range, content, ammo, hitModeHands, hitMode, attackNum, true);
    }

    public static String getBaseHitToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getBaseHitToken(pc, eq, -1, -1, -1, -1);
    }

    public static String getBaseHitToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, int attackNum) {
        int hitModeHands = 1;
        int hitMode = 1;
        String profName = WeaponToken.getRealProf(pc, eq, eq.profName(pc), hitModeHands);
        return WeaponToken.getToHit(pc, eq, profName, range, content, ammo, hitModeHands, hitMode, attackNum, false);
    }

    public static String getTwpHitHToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getTwpHitHToken(pc, eq, -1, -1, -1, -1);
    }

    public static String getTwpHitHToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, int attackNum) {
        int hitModeHands = 1;
        int hitMode = 2;
        String profName = WeaponToken.getRealProf(pc, eq, eq.profName(pc), hitModeHands);
        return WeaponToken.getToHit(pc, eq, profName, range, content, ammo, hitModeHands, hitMode, attackNum, false);
    }

    public static String getTwpHitLToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getTwpHitLToken(pc, eq, -1, -1, -1, -1);
    }

    public static String getTwpHitLToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, int attackNum) {
        int hitModeHands = 1;
        int hitMode = 3;
        String profName = WeaponToken.getRealProf(pc, eq, eq.profName(pc), hitModeHands);
        return WeaponToken.getToHit(pc, eq, profName, range, content, ammo, hitModeHands, hitMode, attackNum, false);
    }

    public static String getTwoHitToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getTwoHitToken(pc, eq, -1, -1, -1, -1);
    }

    public static String getTwoHitToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, int attackNum) {
        int hitModeHands = 1;
        int hitMode = 4;
        String profName = WeaponToken.getRealProf(pc, eq, eq.profName(pc), hitModeHands);
        return WeaponToken.getToHit(pc, eq, profName, range, content, ammo, hitModeHands, hitMode, attackNum, false);
    }

    public static String getOHHitToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getOHHitToken(pc, eq, -1, -1, -1, -1);
    }

    public static String getOHHitToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, int attackNum) {
        int hitModeHands = 1;
        int hitMode = 6;
        String profName = WeaponToken.getRealProf(pc, eq, eq.profName(pc), hitModeHands);
        return WeaponToken.getToHit(pc, eq, profName, range, content, ammo, hitModeHands, hitMode, attackNum, false);
    }

    public static String getTHHitToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getTHHitToken(pc, eq, -1, -1, -1, -1);
    }

    public static String getTHHitToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, int attackNum) {
        int hitModeHands = 2;
        int hitMode = 7;
        String profName = WeaponToken.getRealProf(pc, eq, eq.profName(pc), hitModeHands);
        return WeaponToken.getToHit(pc, eq, profName, range, content, ammo, hitModeHands, hitMode, attackNum, false);
    }

    private static String getToHit(PlayerCharacter pc, Equipment eq, String profName, int range, int content, int ammo, int hands, int hitMode, int attackNum, boolean totalHit) {
        StringTokenizer bTok;
        int tempExtraAttacks;
        Equipment ammoUser;
        Iterator e;
        boolean isDouble = eq.isDouble() && eq.getLocation() == 4;
        boolean isDoubleSplit = eq.isType("Head1") || eq.isType("Head2");
        WeaponProf wp = Globals.getWeaponProfNamed(profName);
        if (eq.isMelee() && hitMode != 7 && Globals.isWeaponTwoHanded(pc, eq, wp)) {
            return SettingsHandler.getInvalidToHitText();
        }
        if (isDoubleSplit && hitMode != 7) {
            return SettingsHandler.getInvalidToHitText();
        }
        if (eq.isMelee() && Globals.isWeaponOutsizedForPC(pc, eq) && !eq.isNatural()) {
            return SettingsHandler.getInvalidToHitText();
        }
        String melee = WeaponToken.getMeleeAttackString(pc);
        String ranged = WeaponToken.getRangedAttackString(pc);
        String unarmed = WeaponToken.getUnarmedAttackString(pc);
        if (eq.isMonk()) {
            if (unarmed.length() > melee.length()) {
                melee = unarmed;
            } else if (unarmed.length() == melee.length() && !melee.equals(unarmed)) {
                StringTokenizer mTok = new StringTokenizer(melee, "+/", false);
                StringTokenizer m1Tok = new StringTokenizer(melee, "+/", false);
                String msString = mTok.nextToken();
                String m1sString = m1Tok.nextToken();
                if (Integer.parseInt(m1sString) >= Integer.parseInt(msString)) {
                    melee = unarmed;
                }
            }
        }
        int baseBonus = 0;
        int secondaryBonus = 0;
        int primaryBonus = 0;
        if (eq.isNatural() && eq.getLocation() == 2) {
            baseBonus = -5;
            baseBonus = (int)((double)baseBonus + pc.getTotalBonusTo("COMBAT", "TOHIT-SECONDARY"));
        } else if (eq.isNatural() && eq.getLocation() == 1) {
            baseBonus = 0;
        } else {
            baseBonus = hitMode == 1 || hitMode == 7 || hitMode == 0 && eq.isRanged() ? 0 : (hitMode == 2 || hitMode == 3 ? -6 : (hitMode == 6 ? -4 : -10));
            if (hitMode == 3 || hitMode == 5) {
                baseBonus += pc.getOffHandLightBonus();
            }
            if (hitMode == 4 && (isDouble || Globals.isWeaponLightForPC(pc, eq))) {
                baseBonus += pc.getOffHandLightBonus();
            }
            if (hitMode == 4 || hitMode == 6 || hitMode == 5 || hitMode == 4) {
                secondaryBonus = (int)pc.getTotalBonusTo("COMBAT", "TOHIT-SECONDARY");
                if (eq.isRanged()) {
                    secondaryBonus -= (int)pc.getBonusDueToType("COMBAT", "TOHIT-SECONDARY", "NOTRANGED");
                }
                if (hitMode == 6) {
                    secondaryBonus -= (int)pc.getTotalBonusTo("COMBAT", "TOHIT-PRIMARY");
                }
            }
            if (hitMode == 2 || hitMode == 3) {
                primaryBonus = (int)pc.getTotalBonusTo("COMBAT", "TOHIT-PRIMARY");
                if (eq.isRanged()) {
                    primaryBonus -= (int)pc.getBonusDueToType("COMBAT", "TOHIT-PRIMARY", "NOTRANGED");
                }
            }
        }
        if ((eq.getLocation() == 1 || eq.getLocation() == 2 || eq.getLocation() == 4) && Globals.isWeaponOneHanded(pc, eq, wp, false) != Globals.isWeaponOneHanded(pc, eq, wp, true)) {
            baseBonus += (int)pc.getTotalBonusTo("WEAPONPROF=" + profName, "TOHITOVERSIZE") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "TOHITOVERSIZE", 0);
        }
        if (hitMode == 2 || hitMode == 3) {
            baseBonus += primaryBonus;
        }
        if (hitMode == 4 || hitMode == 6 || hitMode == 5 || hitMode == 4) {
            baseBonus += secondaryBonus;
        }
        if (eq.isMelee() && (hitMode == 7 || hitMode == 4 || hitMode == 6) && (e = pc.getEquipmentOfType("buckler", 1).iterator()).hasNext()) {
            --baseBonus;
        }
        Iterator ei = eq.typeList().iterator();
        while (ei.hasNext()) {
            String type = ei.next().toString();
            if (type.equalsIgnoreCase("Finesseable") || range > -1 && type.equals("MELEE") || range == -1 && eq.isMelee() && (type.equals("THROWN") || type.equals("RANGED"))) continue;
            baseBonus += (int)pc.getTotalBonusTo("TOHIT", "TYPE." + type);
            baseBonus += (int)pc.getTotalBonusTo("COMBAT", "TOHIT." + type);
        }
        if (range == -1 && eq.isMelee() && Globals.isFinessable(eq, pc)) {
            baseBonus += (int)pc.getTotalBonusTo("COMBAT", "TOHIT.Finesseable");
        }
        if (wp != null && eq.isRanged()) {
            baseBonus -= (int)pc.getBonusDueToType("WEAPONPROF=" + profName, "TOHIT", "NOTRANGED") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "TOHIT.NOTRANGED", 0);
        }
        if (!(eq.isNatural() || wp != null && pc.hasWeaponProfNamed(profName))) {
            baseBonus += pc.getNonProficiencyPenalty();
        }
        baseBonus += (int)pc.getTotalBonusTo("WEAPONPROF=" + profName, "TOHIT") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "TOHIT", 0);
        if (range > -1) {
            int rangeSize = eq.getRangeList(true, pc).size();
            if (range < rangeSize && Integer.parseInt(eq.getRangeList(true, pc).get(range).toString()) <= SettingsHandler.getGame().getShortRangeDistance()) {
                baseBonus += (int)pc.getTotalBonusTo("COMBAT", "TOHIT-SHORTRANGE");
                baseBonus += (int)pc.getTotalBonusTo("TOHIT", "SHORTRANGE");
                baseBonus += (int)pc.getTotalBonusTo("WEAPONPROF=" + profName, "TOHIT-SHORTRANGE") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "TOHIT-SHORTRANGE", 0);
                baseBonus += (int)eq.bonusTo(pc, TOKENNAME, "TOHIT-SHORTRANGE", true);
            }
            if (range < rangeSize) {
                int defaultRange = Integer.parseInt(eq.getRange(pc).toString());
                int thisRange = Integer.parseInt(eq.getRangeList(true, pc).get(range).toString());
                baseBonus -= 2 * (int)Math.max(Math.ceil((float)thisRange / (float)defaultRange) - 1.0, 0.0);
            }
        }
        if (content > -1 && content < eq.getContainedEquipmentCount()) {
            baseBonus += eq.getContainedEquipment(content).getBonusToHit(pc, true);
        }
        if ((ammoUser = WeaponToken.getAmmoUser(pc, eq, ammo)) != null) {
            baseBonus += ammoUser.getBonusToHit(pc, true);
        }
        baseBonus += (int)pc.getTotalBonusTo("TOHIT", "TOHIT");
        baseBonus += (int)pc.getTotalBonusTo("COMBAT", "TOHIT");
        baseBonus += pc.modFromArmorOnWeaponRolls();
        baseBonus += eq.getBonusToHit(pc, true);
        int extra_attacks = (int)eq.bonusTo(pc, TOKENNAME, "ATTACKS", true);
        extra_attacks += (int)pc.getTotalBonusTo("COMBAT", "ATTACKS");
        StringTokenizer zTok = null;
        if (eq.isMelee() && range == -1) {
            tempExtraAttacks = extra_attacks;
            while (tempExtraAttacks-- > 0) {
                bTok = new StringTokenizer(melee, "/");
                melee = bTok.nextToken() + "/" + melee;
            }
            zTok = new StringTokenizer(melee, "+/", false);
        } else if (eq.isRanged()) {
            tempExtraAttacks = extra_attacks;
            while (tempExtraAttacks-- > 0) {
                bTok = new StringTokenizer(ranged, "/");
                ranged = bTok.nextToken() + "/" + ranged;
            }
            zTok = new StringTokenizer(ranged, "+/", false);
        }
        int x = 0;
        int max = 1 + (int)pc.getTotalBonusTo("COMBAT", "ATTACKS-SECONDARY");
        max += (int)pc.getTotalBonusTo("COMBAT", "SECONDARYATTACKS");
        if (pc.getPrimaryWeapons().isEmpty() && hitMode == 0) {
            max = 100;
        }
        if (!eq.isAttacksProgress() || eq.bonusTo(pc, TOKENNAME, "ATTACKSPROGRESS", true) > 0.0) {
            attackNum = 0;
        }
        if (!eq.isMelee() && !eq.isRanged()) {
            return "???";
        }
        StringBuffer primaryAttack = new StringBuffer(20);
        StringBuffer secondaryAttack = new StringBuffer(20);
        StringBuffer sb = new StringBuffer();
        do {
            int iBAB = 0;
            if (hitMode == 4 && x >= max && !isDouble || pc.isSecondaryWeapon(eq) && x >= max && !isDouble) break;
            if (zTok != null) {
                if (!zTok.hasMoreTokens()) break;
                iBAB = Integer.parseInt(zTok.nextToken());
            }
            if (--attackNum < 0) {
                int iAtt = iBAB + baseBonus;
                if (primaryAttack.length() != 0) {
                    primaryAttack.append('/');
                }
                primaryAttack.append(Delta.toString(iAtt));
                if (!eq.isAttacksProgress() || eq.bonusTo(pc, TOKENNAME, "ATTACKSPROGRESS", true) > 0.0) {
                    while (extra_attacks-- > 0 && totalHit) {
                        primaryAttack.append('/').append(Delta.toString(iAtt));
                    }
                    break;
                }
                if (x < max && isDouble && eq.getLocation() == 4) {
                    if (secondaryAttack.length() != 0) {
                        secondaryAttack.append('/');
                    }
                    int iAtt2 = iBAB + baseBonus;
                    secondaryAttack.append(Delta.toString(iAtt2));
                }
            }
            if (hitMode == 4 && x == max - 1 && !isDouble) break;
            if (attackNum < -1) {
                attackNum = -1;
                continue;
            }
            if (attackNum != -1) continue;
            attackNum = -2;
        } while (++x <= 100 && attackNum >= -1);
        sb.append(primaryAttack.toString());
        if (secondaryAttack.length() != 0 && (hitMode == 0 || hitMode == 4)) {
            sb.append(";" + secondaryAttack);
        }
        return sb.toString();
    }

    private static String getDamage(PlayerCharacter pc, Equipment eq, String profName, int range, int content, int ammo, boolean bonusOnly, int hands, int damageMode, boolean base) {
        boolean isDouble = eq.isDouble() && eq.getLocation() == 4;
        boolean isDoubleSplit = eq.isType("Head1") || eq.isType("Head2");
        WeaponProf wp = Globals.getWeaponProfNamed(profName);
        if (eq.isMelee() && damageMode != 0 && damageMode != 3 && damageMode != 4 && Globals.isWeaponTwoHanded(pc, eq, wp)) {
            return SettingsHandler.getInvalidDmgText();
        }
        if (eq.isMelee() && Globals.isWeaponOutsizedForPC(pc, eq) && !eq.isNatural()) {
            return SettingsHandler.getInvalidDmgText();
        }
        if (Globals.isWeaponLightForPC(pc, eq) && hands == 2) {
            hands = 1;
        }
        String damString = WeaponToken.getEqDamage(pc, eq);
        int meleeDamageStatBonus = (int)pc.getStatBonusTo("COMBAT", "DAMAGE.MELEE");
        meleeDamageStatBonus += (int)pc.getStatBonusTo("DAMAGE", "TYPE.MELEE");
        double meleeDamageMult = pc.getTotalBonusTo("COMBAT", "DAMAGEMULT:" + hands);
        meleeDamageMult += pc.getTotalBonusTo("WEAPONPROF=" + profName, "DAMAGEMULT:" + hands);
        meleeDamageMult += eq.bonusTo(TOKENNAME, "DAMAGEMULT:" + hands, pc, pc);
        int bonus = 0;
        int weaponProfBonus = 0;
        int eqbonus = 0;
        int totalBonus = 0;
        damString = WeaponToken.getMonkUnarmed(pc, eq, damString);
        if (!base) {
            int index;
            for (index = 0; index < damString.length(); ++index) {
                if (damString.charAt(index) != '+' && damString.charAt(index) != '-') continue;
                totalBonus = Delta.decode(damString.substring(index));
                break;
            }
            eqbonus = WeaponToken.getEqBonus(pc, eq, content, ammo);
            bonus = WeaponToken.getGeneralBonus(pc, eq, range, meleeDamageStatBonus, meleeDamageMult);
            weaponProfBonus = WeaponToken.getWeaponProfBonus(pc, eq, range);
            totalBonus += bonus + weaponProfBonus + eqbonus;
            damString = damString.substring(0, index);
        }
        StringBuffer sb = new StringBuffer();
        if (!"0d0".equalsIgnoreCase(damString)) {
            if (!bonusOnly) {
                sb.append(damString);
            }
            if (totalBonus != 0 || bonusOnly) {
                sb.append(Delta.toString(totalBonus));
            }
        } else {
            sb.append("0");
        }
        if (damageMode == 4 && eq.getLocation() == 4) {
            hands = 0;
            meleeDamageMult = pc.getTotalBonusTo("COMBAT", "DAMAGEMULT:" + hands);
            meleeDamageMult += pc.getTotalBonusTo("WEAPONPROF=" + profName, "DAMAGEMULT:" + hands);
            meleeDamageMult += eq.bonusTo(TOKENNAME, "DAMAGEMULT:" + hands, pc, pc);
            totalBonus -= eqbonus;
            eqbonus = eq.getBonusToDamage(pc, false);
            if (eq.getAltDamage(pc).length() > 0) {
                totalBonus = 0;
                damString = eq.getAltDamage(pc);
                if (damString.lastIndexOf(45) >= 0) {
                    totalBonus = Integer.parseInt(damString.substring(damString.lastIndexOf(45)));
                    damString = damString.substring(0, damString.lastIndexOf(45));
                } else if (damString.lastIndexOf(43) >= 0) {
                    totalBonus = Integer.parseInt(damString.substring(damString.lastIndexOf(43) + 1));
                    damString = damString.substring(0, damString.lastIndexOf(43));
                }
            } else {
                weaponProfBonus = 0;
                bonus = 0;
            }
            if (meleeDamageStatBonus > 0) {
                bonus -= meleeDamageStatBonus;
                bonus = (int)((double)bonus + meleeDamageMult * (double)meleeDamageStatBonus);
            }
            totalBonus += bonus + weaponProfBonus + eqbonus;
            sb.append("/");
            if (!"0d0".equalsIgnoreCase(damString)) {
                if (bonusOnly) {
                    sb.append(damString);
                }
                if (totalBonus != 0 || bonusOnly) {
                    sb.append(Delta.toString(totalBonus));
                }
            } else {
                sb.append("0");
            }
        }
        return sb.toString();
    }

    private static int getGeneralBonus(PlayerCharacter pc, Equipment eq, int range, int meleeDamageStatBonus, double meleeDamageMult) {
        int rangeSize;
        int bonus = 0;
        Iterator ei = eq.typeList().iterator();
        while (ei.hasNext()) {
            String type = (String)ei.next();
            if (range > -1 && type.equals("MELEE") || range == -1 && (type.equals("THROWN") || type.equals("RANGED"))) continue;
            bonus += (int)pc.getTotalBonusTo("COMBAT", "DAMAGE." + type);
            bonus += (int)pc.getTotalBonusTo("DAMAGE", "TYPE." + type);
        }
        if (eq.isMelee() && meleeDamageStatBonus > 0) {
            bonus -= meleeDamageStatBonus;
            bonus = (int)((double)bonus + meleeDamageMult * (double)meleeDamageStatBonus);
        } else if (eq.isThrown()) {
            // empty if block
        }
        if (range > -1 && range < (rangeSize = eq.getRangeList(true, pc).size()) && Integer.parseInt(eq.getRangeList(true, pc).get(range).toString()) <= SettingsHandler.getGame().getShortRangeDistance()) {
            bonus += (int)eq.bonusTo(pc, TOKENNAME, "DAMAGE-SHORTRANGE", true);
            bonus += (int)pc.getTotalBonusTo("DAMAGE", "SHORTRANGE");
            bonus += (int)pc.getTotalBonusTo("COMBAT", "DAMAGE-SHORTRANGE");
        }
        return bonus;
    }

    private static int getWeaponProfBonus(PlayerCharacter pc, Equipment eq, int range) {
        int rangeSize;
        String profName = eq.profName(pc);
        int weaponProfBonus = (int)pc.getTotalBonusTo("WEAPONPROF=" + profName, "DAMAGE") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "DAMAGE", 0);
        if (eq.isRanged()) {
            weaponProfBonus -= (int)pc.getBonusDueToType("WEAPONPROF=" + profName.toUpperCase(), "DAMAGE", "NOTRANGED") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "DAMAGE.NOTRANGED", 0);
        }
        if (range > -1 && range < (rangeSize = eq.getRangeList(true, pc).size()) && Integer.parseInt(eq.getRangeList(true, pc).get(range).toString()) <= SettingsHandler.getGame().getShortRangeDistance()) {
            weaponProfBonus += (int)pc.getTotalBonusTo("WEAPONPROF=" + profName, "DAMAGE-SHORTRANGE") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "DAMAGE-SHORTRANGE", 0);
        }
        return weaponProfBonus;
    }

    private static int getEqBonus(PlayerCharacter pc, Equipment eq, int content, int ammo) {
        Equipment ammoUser;
        int eqbonus = eq.getBonusToDamage(pc, true);
        if (content > -1 && content < eq.getContainedEquipmentCount()) {
            eqbonus += eq.getContainedEquipment(content).getBonusToDamage(pc, true);
        }
        if ((ammoUser = WeaponToken.getAmmoUser(pc, eq, ammo)) != null) {
            eqbonus += ammoUser.getBonusToDamage(pc, true);
        }
        return eqbonus;
    }

    private static String getMonkUnarmed(PlayerCharacter pc, Equipment eq, String damString) {
        if (eq.isMonk() && eq.isUnarmed()) {
            String uDamString = pc.getUnarmedDamageString(false, false);
            StringTokenizer bTok = new StringTokenizer(damString, " d+-", false);
            bTok.nextToken();
            String b1String = bTok.nextToken();
            bTok = new StringTokenizer(uDamString, " d+-", false);
            bTok.nextToken();
            String c1String = bTok.nextToken();
            if (Integer.parseInt(b1String) < Integer.parseInt(c1String)) {
                damString = uDamString;
            }
            int eqSize = Globals.sizeInt(pc.getRace().getSize());
            int iMod = pc.sizeInt();
            iMod += (int)pc.getTotalBonusTo("WEAPONPROF=Unarmed Strike", "DAMAGESIZE");
            damString = Globals.adjustDamage(damString, eqSize, iMod += (int)pc.getTotalBonusTo("COMBAT", "DAMAGESIZE"));
        }
        return damString;
    }

    private static String getEqDamage(PlayerCharacter pc, Equipment eq) {
        String retString = eq.getDamage(pc);
        if (pc == null) {
            return retString;
        }
        String profName = eq.profName(pc);
        if (eq.isNatural()) {
            int eqSize = Globals.sizeInt(pc.getRace().getSize());
            int iMod = pc.sizeInt();
            iMod += (int)pc.getTotalBonusTo("WEAPONPROF=" + profName, "DAMAGESIZE");
            retString = Globals.adjustDamage(retString, eqSize, iMod += (int)pc.getTotalBonusTo("COMBAT", "DAMAGESIZE"));
        } else {
            int eqSize;
            int iMod = eqSize = eq.sizeInt();
            iMod += (int)pc.getTotalBonusTo("WEAPONPROF=" + profName, "DAMAGESIZE");
            retString = Globals.adjustDamage(retString, eqSize, iMod += (int)pc.getTotalBonusTo("COMBAT", "DAMAGESIZE"));
        }
        return retString;
    }

    private static String getRealProf(PlayerCharacter pc, Equipment eq, String profName, int hands) {
        String realProf = profName;
        if (!eq.isNatural() && hands != 0) {
            realProf = eq.profName(hands, pc);
        }
        return realProf;
    }

    private static Equipment getAmmoUser(PlayerCharacter pc, Equipment eq, int ammo) {
        int ammoCount = 0;
        String containerCapacity = eq.getContainerCapacityString();
        Iterator e = pc.getEquipmentListInOutputOrder().iterator();
        while (e.hasNext() && ammo >= 0) {
            Equipment anEquip = (Equipment)e.next();
            Iterator e2 = anEquip.typeList().iterator();
            while (e2.hasNext()) {
                if (containerCapacity.indexOf(e2.next().toString()) < 0) continue;
                ++ammoCount;
                break;
            }
            if (ammoCount != ammo + 1) continue;
            return anEquip;
        }
        return null;
    }

    private static int getWeaponProfTypeBonuses(PlayerCharacter pc, Equipment eq, String bonusType, int index) {
        int bonus = 0;
        boolean hasBoth = eq.isRanged() && eq.isMelee();
        String profName = eq.profName(pc);
        WeaponProf wp = Globals.getWeaponProfNamed(profName);
        if (wp == null) {
            return 0;
        }
        StringTokenizer aTok = new StringTokenizer(wp.getType(), ".");
        block6: while (aTok.hasMoreTokens()) {
            String tString = aTok.nextToken();
            if (hasBoth && "RANGED".equalsIgnoreCase(tString)) continue;
            switch (index) {
                case 0: {
                    bonus += (int)pc.getTotalBonusTo("WEAPONPROF=TYPE." + tString, bonusType);
                    continue block6;
                }
                case 1: {
                    bonus += (int)eq.bonusTo("WEAPONPROF=TYPE." + tString, bonusType, pc, pc);
                    continue block6;
                }
                case 2: {
                    bonus += (int)pc.getFeatBonusTo("WEAPONPROF=TYPE." + tString, bonusType, true);
                    continue block6;
                }
                case 3: {
                    bonus += (int)pc.getTemplateBonusTo("WEAPONPROF=TYPE." + tString, bonusType, true);
                    continue block6;
                }
            }
            Logging.errorPrint("In getWeaponProfTypeBonuses there is an unhandled case in a switch (the value is " + index + ".");
        }
        return bonus;
    }

    private static String weaponCategories(Equipment eq) {
        StringBuffer wc = new StringBuffer(10);
        StringTokenizer aTok = new StringTokenizer(SettingsHandler.getGame().getWeaponCategories(), "|", false);
        while (aTok.hasMoreTokens()) {
            String type = aTok.nextToken();
            if (!eq.isType(type, true)) continue;
            if (wc.length() != 0) {
                wc.append('/');
            }
            wc.append(type);
        }
        if (wc.length() == 0) {
            wc.append("Non-Standard");
        }
        return wc.toString();
    }

    private static String weaponTypes(Equipment eq, boolean primary) {
        StringBuffer wt = new StringBuffer(10);
        StringTokenizer aTok = new StringTokenizer(SettingsHandler.getGame().getWeaponTypes(), "|", false);
        while (aTok.countTokens() >= 2) {
            String type = aTok.nextToken();
            String abbrev = aTok.nextToken();
            if (!eq.isType(type, primary)) continue;
            wt.append(abbrev);
        }
        return wt.toString();
    }

    private static String getRangedAttackString(PlayerCharacter pc) {
        return pc.getAttackString(1, 0);
    }

    private static String getMeleeAttackString(PlayerCharacter pc) {
        return pc.getAttackString(0, 0);
    }

    private static String getUnarmedAttackString(PlayerCharacter pc) {
        return pc.getAttackString(2, 0);
    }
}

