/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.Token;

public class WeightToken
extends Token {
    public static final String TOKENNAME = "WEIGHT";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc) {
        String retString = "";
        if (TOKENNAME.equals(tokenSource)) {
            retString = WeightToken.getWeightToken(pc);
        } else if ("WEIGHT.NOUNIT".equals(tokenSource)) {
            retString = WeightToken.getNoUnitToken(pc);
        } else if ("WEIGHT.LIGHT".equals(tokenSource)) {
            retString = WeightToken.getLightToken(pc) + "";
        } else if ("WEIGHT.MEDIUM".equals(tokenSource)) {
            retString = WeightToken.getMediumToken(pc) + "";
        } else if ("WEIGHT.HEAVY".equals(tokenSource)) {
            retString = WeightToken.getHeavyToken(pc) + "";
        }
        return retString;
    }

    public static double getHeavyToken(PlayerCharacter pc) {
        double weightInPounds = 3 * Globals.maxLoadForLoadScore(pc.getVariableValue("LOADSCORE", "").intValue(), pc).intValue() / 3;
        return Globals.convertWeightToUnitSet(weightInPounds);
    }

    public static double getLightToken(PlayerCharacter pc) {
        double weightInPounds = 1 * Globals.maxLoadForLoadScore(pc.getVariableValue("LOADSCORE", "").intValue(), pc).intValue() / 3;
        return Globals.convertWeightToUnitSet(weightInPounds);
    }

    public static double getMediumToken(PlayerCharacter pc) {
        double weightInPounds = 2 * Globals.maxLoadForLoadScore(pc.getVariableValue("LOADSCORE", "").intValue(), pc).intValue() / 3;
        return Globals.convertWeightToUnitSet(weightInPounds);
    }

    public static String getNoUnitToken(PlayerCharacter pc) {
        return Globals.displayWeightInUnitSet(pc.getWeight());
    }

    public static String getWeightToken(PlayerCharacter pc) {
        return Globals.displayWeightInUnitSet(pc.getWeight()) + " " + Globals.getWeightUnit();
    }
}

