/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence;

import java.util.Iterator;
import java.util.List;
import java.util.Observer;
import java.util.Set;
import pcgen.core.Campaign;
import pcgen.core.Globals;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.SystemLoader;
import pcgen.persistence.lst.LstSystemLoader;

public final class PersistenceManager {
    private static final SystemLoader instance = new LstSystemLoader();
    private static boolean initialized;
    private static final PersistenceManager managerInstance;

    private PersistenceManager() {
    }

    public static PersistenceManager getInstance() {
        return managerInstance;
    }

    public void addObserver(Observer o) {
        instance.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        instance.deleteObserver(o);
    }

    public void setChosenCampaignSourcefiles(List l) {
        instance.setChosenCampaignSourcefiles(l);
    }

    public List getChosenCampaignSourcefiles() {
        return instance.getChosenCampaignSourcefiles();
    }

    public boolean isCustomItemsLoaded() {
        return instance.isCustomItemsLoaded();
    }

    public Set getSources() {
        return instance.getSources();
    }

    public void emptyLists() {
        instance.emptyLists();
    }

    public void initialize() throws PersistenceLayerException {
        if (!initialized) {
            instance.initialize();
            instance.loadModItems(true);
            initialized = true;
        }
    }

    public void loadCampaigns(List aSelectedCampaignsList) throws PersistenceLayerException {
        try {
            instance.loadCampaigns(aSelectedCampaignsList);
            instance.loadModItems(true);
        }
        catch (PersistenceLayerException ple) {
            Globals.emptyLists();
            this.emptyLists();
            Iterator iter = aSelectedCampaignsList.iterator();
            while (iter.hasNext()) {
                Campaign campaign = (Campaign)iter.next();
                campaign.setIsLoaded(false);
            }
            ple.fillInStackTrace();
            throw ple;
        }
    }

    public void loadFileIntoList(String fileName, int fileType, List aList) throws PersistenceLayerException {
        instance.loadFileIntoList(fileName, fileType, aList);
    }

    public void refreshCampaigns() {
        instance.refreshCampaigns();
    }

    static {
        managerInstance = new PersistenceManager();
    }
}

