/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.core.BioSet;
import pcgen.core.Globals;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;

final class BioSetLoader
extends LstLineFileLoader {
    private static String regionName = "None";
    BioSet bioSet = new BioSet();
    int currentAgeSetIndex = 0;

    public static void clear() {
        regionName = "None";
    }

    public void loadLstFile(String fileName) throws PersistenceLayerException {
        this.currentAgeSetIndex = 0;
        super.loadLstFile(fileName);
        Globals.setBioSet(this.bioSet);
    }

    public void parseLine(String lstLine, URL sourceURL) throws PersistenceLayerException {
        if (lstLine.startsWith("AGESET:")) {
            this.currentAgeSetIndex = this.bioSet.addToAgeMap(regionName, lstLine.substring(7), this.currentAgeSetIndex);
        } else {
            StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
            String raceName = "";
            ArrayList<String> preReqList = null;
            while (colToken.hasMoreTokens()) {
                String colString = colToken.nextToken();
                if (colString.startsWith("RACENAME:")) {
                    raceName = colString.substring(9);
                    continue;
                }
                if (colString.startsWith("REGION:")) {
                    regionName = colString.substring(7);
                    continue;
                }
                if (colString.startsWith("PRE") || colString.startsWith("!PRE")) {
                    if (preReqList == null) {
                        preReqList = new ArrayList<String>();
                    }
                    preReqList.add(colString);
                    continue;
                }
                String aString = "";
                if (preReqList != null) {
                    StringBuffer sBuf = new StringBuffer(100);
                    int x = preReqList.size();
                    for (int i = 0; i < x; ++i) {
                        sBuf.append('[').append(preReqList.get(i)).append(']');
                    }
                    aString = sBuf.toString();
                }
                this.bioSet.addToUserMap(regionName, raceName, colString + aString, this.currentAgeSetIndex);
            }
        }
    }
}

