/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.util.Logging;

final class BonusSpellLoader
extends LstLineFileLoader {
    public void parseLine(String lstLine, URL sourceURL) throws PersistenceLayerException {
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t", false);
        String baseStatScore = "0";
        String statRange = "0";
        String level = "0";
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (colString.startsWith("BASESTATSCORE:")) {
                baseStatScore = colString.substring(14);
                continue;
            }
            if (colString.startsWith("BONUSSPELLLEVEL:")) {
                level = colString.substring(16);
                continue;
            }
            if (colString.startsWith("STATRANGE:")) {
                statRange = colString.substring(10);
                continue;
            }
            Logging.errorPrint("Illegal bonus spell info '" + lstLine + "' in " + sourceURL.toString());
        }
        Globals.getBonusSpellMap().put(level, baseStatScore + "|" + statRange);
    }
}

