/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import pcgen.core.Campaign;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

public class CampaignLoader
extends LstLineFileLoader {
    private Campaign campaign = null;

    public void initRecursivePccFiles() throws PersistenceLayerException {
        ArrayList initialCampaigns = new ArrayList(Globals.getCampaignList());
        Iterator iter = initialCampaigns.iterator();
        while (iter.hasNext()) {
            this.initRecursivePccFiles((Campaign)iter.next());
        }
    }

    public void loadLstFile(String fileName) throws PersistenceLayerException {
        this.campaign = new Campaign();
        super.loadLstFile(fileName);
        this.finishCampaign();
    }

    public void parseLine(String inputLine, URL sourceURL) throws PersistenceLayerException {
        if (inputLine.startsWith("KIT:")) {
            this.addCampaignSource(sourceURL, this.campaign.getKitFileList(), inputLine, 4);
        } else {
            if (PObjectLoader.parseTag(this.campaign, inputLine)) {
                return;
            }
            if (inputLine.startsWith("BOOKTYPE:")) {
                this.campaign.setBookType(inputLine.substring(9));
            } else if (inputLine.startsWith("CAMPAIGN:")) {
                this.campaign.setName(inputLine.substring(9));
                this.campaign.setSourceFile(sourceURL.toString());
            } else if (inputLine.startsWith("COPYRIGHT:")) {
                this.campaign.addSection15Info(inputLine.substring(10));
            } else if (inputLine.startsWith("GAME:")) {
                this.campaign.setGameMode(inputLine.substring(5));
            } else if (inputLine.startsWith("GAMEMODE:")) {
                this.campaign.setGameMode(inputLine.substring(9));
            } else if (inputLine.startsWith("GENRE:")) {
                this.campaign.setGenre(inputLine.substring(6));
            } else if (inputLine.startsWith("HELP:")) {
                this.campaign.setHelp(inputLine.substring(5));
            } else if (inputLine.startsWith("INFOTEXT:")) {
                this.campaign.setInfoText(inputLine.substring(9));
            } else if (inputLine.startsWith("ISOGL:")) {
                this.campaign.setIsOGL(inputLine.charAt(6) == 'Y');
            } else if (inputLine.startsWith("ISD20:")) {
                this.campaign.setIsD20(inputLine.charAt(6) == 'Y');
            } else if (inputLine.startsWith("ISLICENSED:")) {
                this.campaign.setIsLicensed(inputLine.charAt(11) == 'Y');
            } else if (inputLine.startsWith("LICENSED:")) {
                this.campaign.setIsLicensed(inputLine.charAt(9) == 'Y');
            } else if (inputLine.startsWith("LICENSE:")) {
                String licenseInfo = inputLine.substring(8);
                if (licenseInfo.startsWith("FILE=")) {
                    this.campaign.addLicenseFile(CampaignLoader.convertFilePath(sourceURL, licenseInfo.substring(5)));
                } else {
                    this.campaign.addLicense(licenseInfo);
                }
            } else if (inputLine.startsWith("OPTION:")) {
                int equalsPos;
                Properties options = this.campaign.getOptions();
                if (options == null) {
                    options = new Properties();
                    this.campaign.setOptions(options);
                }
                if ((equalsPos = inputLine.indexOf("=")) >= 0) {
                    String optName = inputLine.substring(7, equalsPos);
                    if (optName.toLowerCase().startsWith("pcgen.options.")) {
                        optName = optName.substring("pcgen.options.".length());
                    }
                    String optValue = inputLine.substring(equalsPos + 1);
                    options.setProperty(optName, optValue);
                } else {
                    Logging.errorPrint("Invalid option line in source file " + sourceURL.toString() + " : " + inputLine);
                }
            } else if (inputLine.startsWith("PUBNAMELONG:")) {
                this.campaign.setPubNameLong(inputLine.substring(12));
            } else if (inputLine.startsWith("PUBNAMESHORT:")) {
                this.campaign.setPubNameShort(inputLine.substring(13));
            } else if (inputLine.startsWith("PUBNAMEWEB:")) {
                this.campaign.setPubNameWeb(inputLine.substring(11));
            } else if (inputLine.startsWith("RANK:")) {
                this.campaign.setRank(Integer.valueOf(inputLine.substring(5)));
            } else if (inputLine.startsWith("SETTING:")) {
                this.campaign.setSetting(inputLine.substring(8));
            } else if (inputLine.startsWith("SHOWINMENU:")) {
                this.campaign.setShowInMenu(Boolean.valueOf(inputLine.substring(11)));
            } else if (inputLine.startsWith("LSTEXCLUDE:")) {
                String lstList = inputLine.substring(11);
                StringTokenizer lstTok = new StringTokenizer(lstList, "|");
                while (lstTok.hasMoreTokens()) {
                    String lstFilename = lstTok.nextToken();
                    this.addCampaignSource(sourceURL, this.campaign.getLstExcludeFiles(), lstFilename, 0);
                }
            } else if (inputLine.startsWith("PCC:")) {
                CampaignLoader.addFileSource(sourceURL, this.campaign.getPccFileList(), inputLine, 4);
            } else if (inputLine.startsWith("RACE:")) {
                this.addCampaignSource(sourceURL, this.campaign.getRaceFileList(), inputLine, 5);
            } else if (inputLine.startsWith("CLASS:")) {
                this.addCampaignSource(sourceURL, this.campaign.getClassFileList(), inputLine, 6);
            } else if (inputLine.startsWith("COMPANIONMOD:")) {
                this.addCampaignSource(sourceURL, this.campaign.getCompanionmodFileList(), inputLine, 13);
            } else if (inputLine.startsWith("SKILL:")) {
                this.addCampaignSource(sourceURL, this.campaign.getSkillFileList(), inputLine, 6);
            } else if (inputLine.startsWith("FEAT:")) {
                this.addCampaignSource(sourceURL, this.campaign.getFeatFileList(), inputLine, 5);
            } else if (inputLine.startsWith("DOMAIN:")) {
                this.addCampaignSource(sourceURL, this.campaign.getDomainFileList(), inputLine, 7);
            } else if (inputLine.startsWith("DEITY:")) {
                this.addCampaignSource(sourceURL, this.campaign.getDeityFileList(), inputLine, 6);
            } else if (inputLine.startsWith("SPELL:")) {
                this.addCampaignSource(sourceURL, this.campaign.getSpellFileList(), inputLine, 6);
            } else if (inputLine.startsWith("WEAPONPROF:")) {
                this.addCampaignSource(sourceURL, this.campaign.getWeaponProfFileList(), inputLine, 11);
            } else if (inputLine.startsWith("EQUIPMENT:")) {
                this.addCampaignSource(sourceURL, this.campaign.getEquipmentFileList(), inputLine, 10);
            } else if (inputLine.startsWith("LANGUAGE:")) {
                this.addCampaignSource(sourceURL, this.campaign.getLanguageFileList(), inputLine, 9);
            } else if (inputLine.startsWith("CLASSSKILL:")) {
                this.addCampaignSource(sourceURL, this.campaign.getClassSkillFileList(), inputLine, 11);
            } else if (inputLine.startsWith("CLASSSPELL:")) {
                this.addCampaignSource(sourceURL, this.campaign.getClassSpellFileList(), inputLine, 11);
            } else if (inputLine.startsWith("REQSKILL:")) {
                this.addCampaignSource(sourceURL, this.campaign.getReqSkillFileList(), inputLine, 9);
            } else if (inputLine.startsWith("TEMPLATE:")) {
                this.addCampaignSource(sourceURL, this.campaign.getTemplateFileList(), inputLine, 9);
            } else if (inputLine.startsWith("EQUIPMOD:")) {
                this.addCampaignSource(sourceURL, this.campaign.getEquipmodFileList(), inputLine, 9);
            } else if (inputLine.startsWith("COINS:")) {
                this.addCampaignSource(sourceURL, this.campaign.getCoinFileList(), inputLine, 6);
            } else if (inputLine.startsWith("BIOSET:")) {
                CampaignLoader.addFileSource(sourceURL, this.campaign.getBioSetFileList(), inputLine, 7);
            } else {
                Logging.errorPrint("Unparsed line: " + inputLine + " in " + sourceURL.toString());
            }
        }
    }

    protected void finishCampaign() {
        if (Globals.getCampaignByFilename(this.campaign.getSourceFile(), false) == null) {
            String sect15 = this.campaign.getSection15Info();
            if (sect15 != null && sect15.trim().length() > 0) {
                Globals.getSection15().append("<br><b>Source Material:</b>");
                Globals.getSection15().append(this.campaign.getSourceInForm(0));
                Globals.getSection15().append("<br>");
                Globals.getSection15().append("<b>Section 15 Entry in Source Material:</b><br>");
                Globals.getSection15().append(sect15);
            }
            Globals.addCampaign(this.campaign);
        }
    }

    private void addCampaignSource(URL pccPath, List sourceList, String inputLine, int tagLength) {
        sourceList.add(new CampaignSourceEntry(this.campaign, CampaignLoader.convertFilePath(pccPath, inputLine.substring(tagLength))));
    }

    private static void addFileSource(URL pccPath, List sourceList, String inputLine, int tagLength) {
        sourceList.add(CampaignLoader.convertFilePath(pccPath, inputLine.substring(tagLength)));
    }

    private static String convertFilePath(URL pccPath, String basePath) {
        String convertedPath = "";
        if (basePath.length() <= 0) {
            return convertedPath;
        }
        if (CoreUtility.isURL(basePath)) {
            convertedPath = basePath;
            return convertedPath;
        }
        if (basePath.charAt(0) == '@') {
            String pathNoLeader = CampaignLoader.trimLeadingFileSeparator(basePath.substring(1));
            convertedPath = SettingsHandler.getPccFilesLocation().getAbsolutePath() + File.separator + pathNoLeader;
        } else {
            String pathNoLeader = CampaignLoader.trimLeadingFileSeparator(basePath);
            if (pathNoLeader.startsWith("data")) {
                convertedPath = SettingsHandler.getPccFilesLocation() + pathNoLeader.substring(4);
            } else {
                convertedPath = pccPath.getPath();
                int separatorLoc = convertedPath.lastIndexOf("/");
                convertedPath = convertedPath.substring(0, separatorLoc) + "/" + basePath;
            }
        }
        convertedPath = CoreUtility.fixFilenamePath(convertedPath);
        if (!convertedPath.startsWith(File.separator)) {
            convertedPath = File.separator + convertedPath;
        }
        try {
            return new URL("file:" + convertedPath).toString();
        }
        catch (MalformedURLException e) {
            Logging.errorPrint("failed to convert " + convertedPath + " to true URL.");
            return convertedPath;
        }
    }

    private static String trimLeadingFileSeparator(String basePath) {
        String pathNoLeader = basePath;
        if (pathNoLeader.startsWith("/") || pathNoLeader.startsWith(File.separator)) {
            pathNoLeader = pathNoLeader.substring(1);
        }
        return pathNoLeader;
    }

    private void initRecursivePccFiles(Campaign baseCampaign, Campaign subCampaign) {
        if (subCampaign == null) {
            return;
        }
        baseCampaign.getLstExcludeFiles().addAll(subCampaign.getLstExcludeFiles());
        baseCampaign.getRaceFileList().addAll(subCampaign.getRaceFileList());
        baseCampaign.getClassFileList().addAll(subCampaign.getClassFileList());
        baseCampaign.getCompanionmodFileList().addAll(subCampaign.getCompanionmodFileList());
        baseCampaign.getSkillFileList().addAll(subCampaign.getSkillFileList());
        baseCampaign.getFeatFileList().addAll(subCampaign.getFeatFileList());
        baseCampaign.getDeityFileList().addAll(subCampaign.getDeityFileList());
        baseCampaign.getDomainFileList().addAll(subCampaign.getDomainFileList());
        baseCampaign.getWeaponProfFileList().addAll(subCampaign.getWeaponProfFileList());
        baseCampaign.getEquipmentFileList().addAll(subCampaign.getEquipmentFileList());
        baseCampaign.getClassSkillFileList().addAll(subCampaign.getClassSkillFileList());
        baseCampaign.getClassSpellFileList().addAll(subCampaign.getClassSpellFileList());
        baseCampaign.getSpellFileList().addAll(subCampaign.getSpellFileList());
        baseCampaign.getLanguageFileList().addAll(subCampaign.getLanguageFileList());
        baseCampaign.getReqSkillFileList().addAll(subCampaign.getReqSkillFileList());
        baseCampaign.getTemplateFileList().addAll(subCampaign.getTemplateFileList());
        baseCampaign.getEquipmodFileList().addAll(subCampaign.getEquipmodFileList());
        baseCampaign.getCoinFileList().addAll(subCampaign.getCoinFileList());
        baseCampaign.getKitFileList().addAll(subCampaign.getKitFileList());
        baseCampaign.getBioSetFileList().addAll(subCampaign.getBioSetFileList());
    }

    private void initRecursivePccFiles(Campaign baseCampaign) throws PersistenceLayerException {
        if (baseCampaign == null) {
            return;
        }
        Iterator subIter = baseCampaign.getPccFileList().iterator();
        while (subIter.hasNext()) {
            String fName = (String)subIter.next();
            if (!fName.endsWith(".pcc")) continue;
            Campaign globalSubCampaign = Globals.getCampaignByFilename(fName, false);
            if (globalSubCampaign == null) {
                try {
                    this.loadLstFile(fName);
                    globalSubCampaign = Globals.getCampaignByFilename(fName, false);
                }
                catch (PersistenceLayerException e) {
                    Logging.errorPrint("Recursive init failed on file " + fName, e);
                }
            }
            this.initRecursivePccFiles(globalSubCampaign);
            this.initRecursivePccFiles(baseCampaign, globalSubCampaign);
        }
    }
}

