/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.ArrayList;
import java.util.List;
import pcgen.core.Campaign;
import pcgen.core.utils.CoreUtility;

public class CampaignSourceEntry
implements Comparable {
    private Campaign campaign = null;
    private List excludeItems = new ArrayList();
    private List includeItems = new ArrayList();
    private String file = null;
    private String stringForm = null;

    public CampaignSourceEntry(Campaign campaign, String lstFile) {
        if (campaign == null) {
            throw new IllegalArgumentException("campaign can't be null");
        }
        if (lstFile == null) {
            throw new IllegalArgumentException("lstFile can't be null");
        }
        this.campaign = campaign;
        this.file = this.getIncludesExcludes(lstFile);
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    public List getExcludeItems() {
        return this.excludeItems;
    }

    public String getFile() {
        return this.file;
    }

    public List getIncludeItems() {
        return this.includeItems;
    }

    public int compareTo(Object arg0) {
        CampaignSourceEntry argSource = (CampaignSourceEntry)arg0;
        if (arg0 == null) {
            return -1;
        }
        return this.file.compareTo(argSource.file);
    }

    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof CampaignSourceEntry)) {
            return false;
        }
        return this.file.equals(((CampaignSourceEntry)arg0).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        if (this.stringForm == null) {
            StringBuffer sBuff = new StringBuffer();
            sBuff.append("Campaign: ");
            sBuff.append(this.campaign.getName());
            sBuff.append("; SourceFile: ");
            sBuff.append(this.file);
            this.stringForm = sBuff.toString();
        }
        return this.stringForm;
    }

    private String getIncludesExcludes(String fileName) {
        this.includeItems.clear();
        this.excludeItems.clear();
        int pipePos = fileName.indexOf("|");
        if (pipePos > 0) {
            String inExString = fileName.substring(pipePos + 1);
            while (inExString.startsWith("(")) {
                inExString = inExString.substring(1, inExString.length() - 1);
            }
            if (inExString.startsWith("INCLUDE:")) {
                this.includeItems.addAll(CoreUtility.split(inExString.substring(8), '|'));
            } else if (inExString.startsWith("EXCLUDE:")) {
                this.excludeItems.addAll(CoreUtility.split(inExString.substring(8), '|'));
            }
            return fileName.substring(0, pipePos);
        }
        return fileName;
    }
}

