/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.character.CompanionMod;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

final class CompanionModLoader {
    private CompanionModLoader() {
    }

    public static void parseLine(CompanionMod aComp, String inputLine, URL sourceURL, int lineNum) throws PersistenceLayerException {
        if (aComp == null) {
            return;
        }
        StringTokenizer colToken = new StringTokenizer(inputLine, "\t", false);
        if (!aComp.isNewItem()) {
            colToken.nextToken();
        }
        while (colToken.hasMoreTokens()) {
            StringTokenizer aTok;
            String colString = colToken.nextToken().trim();
            if (PObjectLoader.parseTag(aComp, colString)) continue;
            if (colString.startsWith("FOLLOWER:")) {
                aTok = new StringTokenizer(colString.substring(9), "=");
                String someClasses = aTok.nextToken();
                String aLev = aTok.nextToken();
                aComp.setLevel(Integer.parseInt(aLev));
                StringTokenizer bTok = new StringTokenizer(someClasses, ",");
                while (bTok.hasMoreTokens()) {
                    String cN = bTok.nextToken();
                    PCClass nc = Globals.getClassNamed(cN);
                    if (nc != null) {
                        aComp.getClassMap().put(cN, aLev);
                        continue;
                    }
                    aComp.getVarMap().put(cN, aLev);
                }
                continue;
            }
            if (colString.startsWith("HD:")) {
                aComp.setHitDie(Integer.parseInt(colString.substring(3)));
                continue;
            }
            if (colString.startsWith("SWITCHRACE:")) {
                aTok = new StringTokenizer(colString.substring(11), "|", false);
                String currT = aTok.nextToken();
                String toT = aTok.nextToken();
                aComp.getSwitchRaceMap().put(currT.toUpperCase(), toT.toUpperCase());
                continue;
            }
            if (colString.startsWith("MASTERBONUSRACE:")) {
                String fRace = colString.substring(16);
                aComp.getClassMap().put(fRace.toUpperCase(), "1");
                continue;
            }
            if (colString.startsWith("USEMASTERSKILL:")) {
                aComp.setUseMasterSkill(colString.substring(15).startsWith("Y"));
                continue;
            }
            if (colString.startsWith("COPYMASTERHP:")) {
                aComp.setCopyMasterHP(colString.substring(13));
                continue;
            }
            if (colString.startsWith("COPYMASTERBAB:")) {
                aComp.setCopyMasterBAB(colString.substring(14));
                continue;
            }
            if (colString.startsWith("COPYMASTERCHECK:")) {
                aComp.setCopyMasterCheck(colString.substring(16));
                continue;
            }
            Logging.errorPrint(sourceURL.toString() + ":" + Integer.toString(lineNum) + " \"" + colString + "\"");
        }
    }
}

