/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.math.BigDecimal;
import java.net.URL;
import java.util.StringTokenizer;
import pcgen.core.money.DenominationList;
import pcgen.core.money.Denominations;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;

public class CurrencyParser
extends LstLineFileLoader {
    public void parseLine(String lstLine, URL sourceURL) throws PersistenceLayerException {
        DenominationList denominationList = DenominationList.getInstance();
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        String region = "Global";
        String name = "";
        String abbr = "";
        int factor = 0;
        float weight = 0.0f;
        boolean isDefault = false;
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken();
            if (colString.startsWith("COIN")) {
                colString = colString.replace('(', ' ');
                colString = colString.replace(')', ' ');
                colString = colString.substring(4);
                colString = colString.trim();
                continue;
            }
            if (colString.startsWith("COST:")) {
                String costString = colString.substring(5);
                try {
                    factor = Integer.parseInt(costString);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new PersistenceLayerException("Invalid Coin Cost '" + costString + "' in " + sourceURL.toString());
                }
            }
            if (colString.startsWith("ABBR:")) {
                abbr = colString.substring(5);
                continue;
            }
            if (colString.startsWith("WT:")) {
                BigDecimal bdWeight = new BigDecimal(colString.substring(3));
                weight = bdWeight.floatValue();
                continue;
            }
            if (!"DEFAULT".equalsIgnoreCase(colString)) continue;
            isDefault = true;
        }
        if (!("".equals(name) && "".equals(abbr) || factor == 0)) {
            if ("".equals(name)) {
                name = abbr;
            } else if ("".equals(abbr)) {
                abbr = name;
            }
            Denominations d = denominationList.getRegionalDenominations(region);
            if (d == null) {
                d = new Denominations();
                d.setRegion(region);
                denominationList.add(d);
            }
            d.addDenomination(name, abbr, factor, weight, isDefault);
        }
    }
}

