/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Deity;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.utils.CoreUtility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

final class DeityLoader
extends LstObjectFileLoader {
    public PObject parseLine(PObject target, String lstLine, CampaignSourceEntry source) throws PersistenceLayerException {
        Deity deity = (Deity)target;
        if (deity == null) {
            deity = new Deity();
        }
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        int col = 0;
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (PObjectLoader.parseTag(deity, colString)) continue;
            int colLen = colString.length();
            if (colLen > 6 && colString.startsWith("ALIGN:")) {
                deity.setAlignment(colString.substring(6));
                continue;
            }
            if (colString.startsWith("APPEARANCE:")) {
                deity.setAppearance(colString.substring(11));
                continue;
            }
            if (colString.startsWith("DEITYWEAP:")) {
                deity.setFavoredWeapon(colString.substring(10));
                continue;
            }
            if (colString.startsWith("DOMAINS:")) {
                Object[] domains = colString.substring(8).split(",");
                deity.setDomainNameList(CoreUtility.arrayToList(domains));
                continue;
            }
            if (colString.startsWith("FOLLOWERALIGN:")) {
                deity.setFollowerAlignments(colString.substring(14));
                continue;
            }
            if (colLen > 9 && colString.startsWith("PANTHEON:")) {
                Object[] pantheons = colString.substring(9).split("\\|");
                List list = CoreUtility.arrayToList(pantheons);
                deity.setPantheonList(list);
                continue;
            }
            if (colString.startsWith("QUALIFY:")) {
                deity.setQualifyString(colString.substring(8));
                continue;
            }
            if (colLen > 5 && colString.startsWith("RACE:")) {
                Object[] races = colString.substring(5).split("\\|");
                List raceList = CoreUtility.arrayToList(races);
                deity.setRaceNameList(raceList);
                continue;
            }
            if (colString.startsWith("SYMBOL:")) {
                deity.setHolyItem(colString.substring(7));
                continue;
            }
            if (colString.startsWith("TITLE:")) {
                deity.setTitle(colString.substring(6));
                continue;
            }
            if (colString.startsWith("WORSHIPPERS:")) {
                deity.setWorshippers(colString.substring(12));
                continue;
            }
            if (col >= 0 && col < 6) {
                switch (col) {
                    case 0: {
                        if (colString.equals(deity.getName()) || colString.indexOf(".MOD") >= 0) break;
                        this.finishObject(deity);
                        deity = new Deity();
                        deity.setName(colString);
                        deity.setSourceCampaign(source.getCampaign());
                        deity.setSourceFile(source.getFile());
                        break;
                    }
                    default: {
                        Logging.errorPrint("In DeityLoader.parseLine the column " + col + " is not possible.");
                    }
                }
                ++col;
                continue;
            }
            Logging.errorPrint("Illegal deity info '" + colString + "' in " + source.getFile());
        }
        return deity;
    }

    protected PObject getObjectNamed(String baseName) {
        return Globals.getDeityNamed(baseName);
    }

    protected void finishObject(PObject target) {
        if (this.includeObject(target) && Globals.getDeityNamed(target.getName()) == null) {
            Globals.getDeityList().add(target);
        }
    }

    protected void performForget(PObject objToForget) {
        Globals.getDeityList().remove(objToForget);
    }
}

