/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.StringTokenizer;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.io.EntityEncoder;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

final class DomainLoader
extends LstObjectFileLoader {
    public PObject parseLine(PObject target, String lstLine, CampaignSourceEntry source) throws PersistenceLayerException {
        Domain obj = (Domain)target;
        if (obj == null) {
            obj = new Domain();
        }
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        int col = 0;
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (PObjectLoader.parseTag(obj, colString)) continue;
            int aLen = colString.length();
            if (col == 0) {
                if (!colString.equals(obj.getName()) && colString.indexOf(".MOD") < 0) {
                    this.finishObject(obj);
                    obj = new Domain();
                    obj.setName(colString);
                    obj.setSourceCampaign(source.getCampaign());
                    obj.setSourceFile(source.getFile());
                }
            } else if (aLen > 5 && colString.startsWith("FEAT:")) {
                obj.addFeatToList(colString.substring(5));
            } else if (colString.startsWith("QUALIFY:")) {
                obj.setQualifyString(colString.substring(8));
            } else if (col == 1) {
                obj.setDescription(EntityEncoder.decode(colString));
            } else {
                Logging.errorPrint("Illegal obj info '" + colString + "' in " + source.getFile());
            }
            ++col;
        }
        return obj;
    }

    protected PObject getObjectNamed(String baseName) {
        return Globals.getDomainNamed(baseName);
    }

    protected void finishObject(PObject target) {
        if (this.includeObject(target) && Globals.getDomainNamed(target.getName()) == null) {
            Globals.addDomain((Domain)target);
        }
    }

    protected void performForget(PObject objToForget) {
        Globals.getDomainList().remove(objToForget);
    }
}

