/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.SystemCollections;
import pcgen.core.character.EquipSlot;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.util.Logging;

final class EquipSlotLoader
extends LstLineFileLoader {
    private String gameMode = "*";

    public void loadLstFile(String source, String gMode) throws PersistenceLayerException {
        this.gameMode = gMode;
        super.loadLstFile(source);
    }

    public void parseLine(String lstLine, URL sourceURL) throws PersistenceLayerException {
        EquipSlot eqSlot = new EquipSlot();
        StringTokenizer aTok = new StringTokenizer(lstLine, "\t");
        while (aTok.hasMoreTokens()) {
            String colString = aTok.nextToken().trim();
            if (lstLine.startsWith("NUMSLOTS:")) {
                StringTokenizer eTok = new StringTokenizer(lstLine.substring(9), "\t");
                while (eTok.hasMoreTokens()) {
                    String cString = eTok.nextToken().trim();
                    StringTokenizer cTok = new StringTokenizer(cString, ":");
                    if (cTok.countTokens() != 2) continue;
                    String eqSlotType = cTok.nextToken();
                    String aNum = cTok.nextToken();
                    Globals.setEquipSlotTypeCount(eqSlotType, aNum);
                }
                continue;
            }
            if (colString.startsWith("EQSLOT:")) {
                eqSlot.setSlotName(colString.substring(7));
                continue;
            }
            if (colString.startsWith("CONTAINS:")) {
                StringTokenizer bTok = new StringTokenizer(colString.substring(9), "=");
                if (bTok.countTokens() != 2) continue;
                String aType = bTok.nextToken();
                String numString = bTok.nextToken();
                int aNum = numString.equals("*") ? 9999 : Integer.parseInt(numString);
                eqSlot.setContainType(aType);
                eqSlot.setContainNum(aNum);
                continue;
            }
            if (colString.startsWith("NUMBER:")) {
                eqSlot.setSlotNumType(colString.substring(7));
                continue;
            }
            Logging.errorPrint("Illegal slot info '" + lstLine + "' in " + sourceURL.toString());
        }
        SystemCollections.addToEquipSlotsList(eqSlot, this.gameMode);
    }
}

