/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.SettingsHandler;
import pcgen.core.SpecialProperty;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

final class EquipmentLoader {
    private EquipmentLoader() {
    }

    public static void parseLine(Equipment equipment, String inputLine, URL sourceURL, int lineNum) throws PersistenceLayerException {
        if (equipment == null) {
            return;
        }
        StringTokenizer colToken = new StringTokenizer(inputLine, "\t");
        int col = 0;
        if (!equipment.isNewItem()) {
            col = 1;
            colToken.nextToken();
        }
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken();
            int aLen = colString.length();
            if (col == 0) {
                equipment.setName(colString);
            } else if (aLen > 3 && colString.startsWith("AC:")) {
                String aBonus = "BONUS:COMBAT|AC|" + colString.substring(3) + "|TYPE=Armor.REPLACE";
                PObjectLoader.parseTag(equipment, aBonus);
            } else if (aLen > 8 && colString.startsWith("ACCHECK:")) {
                equipment.setACCheck(colString.substring(8));
            } else if (aLen > 12 && colString.startsWith("ALTCRITICAL:")) {
                equipment.setAltCritMult(colString.substring(12));
            } else if (aLen > 12 && colString.startsWith("ALTCRITMULT:")) {
                equipment.setAltCritMult(colString.substring(12));
            } else if (aLen > 13 && colString.startsWith("ALTCRITRANGE:")) {
                equipment.setAltCritRange(colString.substring(13));
            } else if (aLen > 10 && colString.startsWith("ALTDAMAGE:")) {
                equipment.setAltDamage(colString.substring(10));
            } else if (colString.startsWith("ALTEQMOD:")) {
                equipment.addEqModifiers(colString.substring(9), false);
            } else if (aLen > 8 && colString.startsWith("ALTTYPE:")) {
                equipment.addToAltTypeList(colString.substring(8));
            } else if (colString.startsWith("BASEITEM:")) {
                equipment.setBaseItem(colString.substring(9));
            } else if (colString.startsWith("BASEQTY:")) {
                equipment.setBaseQty(colString.substring(8));
            } else if (aLen > 10 && colString.startsWith("BONUSTYPE:")) {
                equipment.setBonusType(colString.substring(10));
            } else if (aLen > 7 && colString.startsWith("CHOOSE:")) {
                equipment.setChoiceString(colString.substring(7));
            } else if (colString.startsWith("CONTAINS:")) {
                equipment.setContainer(colString.substring(9));
            } else if (aLen > 5 && (colString.startsWith("Cost:") || colString.startsWith("COST:"))) {
                equipment.setCost(colString.substring(5), true);
            } else if (aLen > 9 && colString.startsWith("CRITMULT:")) {
                equipment.setCritMult(colString.substring(9));
            } else if (aLen > 10 && colString.startsWith("CRITRANGE:")) {
                equipment.setCritRange(colString.substring(10));
            } else if (aLen > 7 && colString.startsWith("DAMAGE:")) {
                equipment.setDamage(colString.substring(7));
            } else if (aLen > 4 && colString.startsWith("EDR:")) {
                equipment.seteDR(colString.substring(4));
            } else if (colString.startsWith("EQMOD:")) {
                equipment.addEqModifiers(colString.substring(6), true);
            } else if (aLen > 6 && colString.startsWith("HANDS:")) {
                try {
                    equipment.setHands(Integer.parseInt(colString.substring(6)));
                }
                catch (NumberFormatException nfe) {
                    Logging.errorPrint("Illegal number of required hands " + sourceURL.toString() + ":" + Integer.toString(lineNum) + " \"" + colString + "\"");
                }
            } else if (aLen > 9 && colString.startsWith("LONGNAME:")) {
                equipment.setLongName(colString.substring(9));
            } else if (aLen > 7 && colString.startsWith("MAXDEX:")) {
                equipment.setMaxDex(colString.substring(7));
            } else if (colString.startsWith("MODS:")) {
                switch (colString.charAt(5)) {
                    case 'R': 
                    case 'r': {
                        equipment.setModifiersAllowed(true);
                        equipment.setModifiersRequired(true);
                        break;
                    }
                    case 'Y': 
                    case 'y': {
                        equipment.setModifiersAllowed(true);
                        equipment.setModifiersRequired(false);
                        break;
                    }
                    case 'N': 
                    case 'n': {
                        equipment.setModifiersAllowed(false);
                        equipment.setModifiersRequired(false);
                        break;
                    }
                    default: {
                        Logging.errorPrint("In EquipmentLoader.parseline the MODS: " + colString.charAt(5) + " is not handled.");
                        break;
                    }
                }
            } else if (aLen > 5 && colString.startsWith("MOVE:")) {
                equipment.setMoveString(colString.substring(5));
                Logging.errorPrint("MOVE in equipment files is now deprecated. Please remove this tag.");
            } else if (aLen > 12 && colString.startsWith("PROFICIENCY:")) {
                equipment.setProfName(colString.substring(12));
            } else if (colString.startsWith("QUALIFY:")) {
                equipment.setQualifyString(colString.substring(8));
            } else if (aLen > 6 && colString.startsWith("RANGE:")) {
                equipment.setRange(colString.substring(6));
            } else if (aLen > 6 && colString.startsWith("RATEOFFIRE:")) {
                equipment.setRateOfFire(colString.substring(11));
            } else if (colString.startsWith("REACH:")) {
                equipment.setReach(Integer.parseInt(colString.substring(6)));
            } else if (aLen > 5 && colString.startsWith("SIZE:")) {
                equipment.setSize(colString.substring(5), true);
            } else if (aLen > 5 && colString.startsWith("SLOTS:")) {
                try {
                    equipment.setSlots(Integer.parseInt(colString.substring(6)));
                }
                catch (NumberFormatException nfe) {
                    Logging.errorPrint("Illegal number of required slots " + sourceURL.toString() + ":" + Integer.toString(lineNum) + " \"" + colString + "\"");
                }
            } else if (aLen > 13 && colString.startsWith("SPELLFAILURE:")) {
                equipment.setSpellFailure(colString.substring(13));
            } else if (aLen > 6 && colString.startsWith("SPROP:")) {
                equipment.addSpecialProperty(SpecialProperty.createFromLst(colString.substring(6)));
            } else if (aLen > 13 && colString.startsWith("TREASURELIST:")) {
                if (SettingsHandler.isGMGen()) {
                    String treasureList = colString.substring(13);
                    StringTokenizer treasureTok = new StringTokenizer(treasureList, "|");
                    while (treasureTok.hasMoreTokens()) {
                        StringTokenizer cmdTok = new StringTokenizer(treasureTok.nextToken(), "=");
                        String lists = cmdTok.nextToken();
                        int weight = Integer.parseInt(cmdTok.nextToken().trim());
                        StringTokenizer listTok = new StringTokenizer(lists, ",");
                        while (listTok.hasMoreTokens()) {
                            equipment.addTreasureList(listTok.nextToken(), weight);
                        }
                    }
                }
            } else if (aLen > 3 && colString.startsWith("WT:")) {
                equipment.setWeight(colString.substring(3));
            } else if (aLen > 3 && colString.startsWith("WIELD:")) {
                equipment.setWield(colString.substring(6));
            } else {
                if (PObjectLoader.parseTag(equipment, colString)) continue;
                Logging.errorPrint("Illegal equipment info " + sourceURL.toString() + ":" + Integer.toString(lineNum) + " \"" + colString + "\"");
            }
            ++col;
        }
        String bonusType = equipment.getBonusType();
        if (equipment.isArmor()) {
            if (bonusType == null) {
                equipment.setBonusType("Armor");
                return;
            }
            if (bonusType.lastIndexOf("Armor") > -1) {
                return;
            }
            equipment.setBonusType(bonusType + "Armor");
        } else if (equipment.isShield()) {
            if (bonusType == null) {
                equipment.setBonusType("Shield");
                return;
            }
            if (bonusType.lastIndexOf("Shield") > -1) {
                return;
            }
            equipment.setBonusType(bonusType + "Shield");
        }
    }
}

